/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.osgi;

import java.io.File;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.main.application.FreeplaneGUIStarter;
import org.freeplane.main.application.FreeplaneStarter;
import org.freeplane.main.application.SingleInstanceManager;
import org.freeplane.main.headlessmode.FreeplaneHeadlessStarter;
import org.freeplane.main.osgi.IControllerExtensionProvider;
import org.freeplane.main.osgi.IModeControllerExtensionProvider;
import org.freeplane.main.osgi.ResourcesUrlHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.url.URLStreamHandlerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ActivatorImpl
implements BundleActivator {
    private static final String HEADLESS_RUN_PROPERTY_NAME = FreeplaneStarter.class.getName() + ".headless";
    private FreeplaneStarter starter;

    ActivatorImpl() {
    }

    private String[] getCallParameters() {
        String param;
        LinkedList<String> parameters = new LinkedList<String>();
        int i = 1;
        while ((param = System.getProperty("org.freeplane.param" + i, null)) != null) {
            if (!param.equals("")) {
                parameters.add(param);
            }
            ++i;
        }
        String[] array = parameters.toArray(new String[parameters.size()]);
        return array;
    }

    public void start(BundleContext context) throws Exception {
        try {
            this.startFramework(context);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        catch (Error e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void loadPlugins(BundleContext context) {
        String resourceBaseDir = FreeplaneGUIStarter.getResourceBaseDir();
        File baseDir = new File(resourceBaseDir).getAbsoluteFile().getParentFile();
        LinkedList<Bundle> loadedPlugins = new LinkedList<Bundle>();
        this.loadPlugins(context, new File(baseDir, "plugins"), loadedPlugins);
        String freeplaneUserDirectory = Compat.getFreeplaneUserDirectory();
        this.loadPlugins(context, new File(freeplaneUserDirectory), loadedPlugins);
        for (Bundle plugin : loadedPlugins) {
            try {
                plugin.start();
                System.out.println("Started: " + plugin.getLocation() + " (id#" + plugin.getBundleId() + ")");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void loadPlugins(BundleContext context, File file, List<Bundle> loadedPlugins) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void startFramework(final BundleContext context) {
        this.registerClasspathUrlHandler(context);
        if (null == System.getProperty("org.freeplane.core.dir.lib", null)) {
            File root = new File(FreeplaneGUIStarter.getResourceBaseDir()).getAbsoluteFile().getParentFile();
            try {
                String rootUrl = root.toURI().toURL().toString();
                if (!rootUrl.endsWith("/")) {
                    rootUrl = rootUrl + "/";
                }
                String libUrl = rootUrl + "core/org.freeplane.core/lib/";
                System.setProperty("org.freeplane.core.dir.lib", libUrl);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        this.starter = this.createStarter();
        SingleInstanceManager singleInstanceManager = new SingleInstanceManager(this.starter);
        singleInstanceManager.start(this.getCallParameters());
        if (singleInstanceManager.isSlave()) {
            LogUtils.info((String)"opened files in master - exiting now");
            System.exit(0);
        } else if (singleInstanceManager.isMasterPresent()) {
            this.starter.setDontLoadLastMaps();
        }
        this.loadPlugins(context);
        final Controller controller = this.starter.createController();
        this.starter.createModeControllers(controller);
        try {
            ServiceReference[] controllerProviders = context.getServiceReferences(IControllerExtensionProvider.class.getName(), null);
            if (controllerProviders != null) {
                for (int i = 0; i < controllerProviders.length; ++i) {
                    ServiceReference controllerProvider = controllerProviders[i];
                    IControllerExtensionProvider service = (IControllerExtensionProvider)context.getService(controllerProvider);
                    service.installExtension(controller);
                    context.ungetService(controllerProvider);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        try {
            Set modes = controller.getModes();
            for (String modeName : modes) {
                ServiceReference[] modeControllerProviders = context.getServiceReferences(IModeControllerExtensionProvider.class.getName(), "(mode=" + modeName + ")");
                if (modeControllerProviders == null) continue;
                ModeController modeController = controller.getModeController(modeName);
                Controller.getCurrentController().selectModeForBuild(modeController);
                for (int i = 0; i < modeControllerProviders.length; ++i) {
                    ServiceReference modeControllerProvider = modeControllerProviders[i];
                    IModeControllerExtensionProvider service = (IModeControllerExtensionProvider)context.getService(modeControllerProvider);
                    service.installExtension(modeController);
                    context.ungetService(modeControllerProvider);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        if ("true".equals(System.getProperty("org.freeplane.exit_on_start", null))) {
            controller.getViewController().invokeLater(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.exit(0);
                }
            });
            return;
        }
        controller.getViewController().invokeLater(new Runnable(){

            public void run() {
                Bundle[] bundles = context.getBundles();
                HashSet<String> plugins = new HashSet<String>();
                for (Bundle bundle : bundles) {
                    plugins.add(bundle.getSymbolicName());
                }
                FilterController.getController((Controller)controller).loadDefaultConditions();
                ActivatorImpl.this.starter.buildMenus(controller, plugins);
                ActivatorImpl.this.starter.createFrame(ActivatorImpl.this.getCallParameters());
            }
        });
    }

    public FreeplaneStarter createStarter() {
        if (Boolean.getBoolean(HEADLESS_RUN_PROPERTY_NAME)) {
            return new FreeplaneHeadlessStarter();
        }
        return new FreeplaneGUIStarter();
    }

    private void registerClasspathUrlHandler(BundleContext context) {
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        properties.put("url.handler.protocol", new String[]{"freeplaneresource"});
        context.registerService(URLStreamHandlerService.class.getName(), (Object)new ResourcesUrlHandler(), properties);
    }

    public void stop(BundleContext context) throws Exception {
        this.starter.stop();
        Bundle[] bundles = context.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            if (bundle.getState() < 32 || !bundle.getSymbolicName().startsWith("org.freeplane.plugin.")) continue;
            try {
                bundle.stop();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

