/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.Dictionary;
import com.inet.jortho.LanguageChangeEvent;
import com.inet.jortho.LanguageChangeListener;
import com.inet.jortho.RedZigZagPainter;
import com.inet.jortho.SpellChecker;
import com.inet.jortho.SpellCheckerOptions;
import com.inet.jortho.Tokenizer;
import java.awt.EventQueue;
import java.util.Locale;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

class AutoSpellChecker
implements DocumentListener,
LanguageChangeListener {
    private static final RedZigZagPainter painter = new RedZigZagPainter();
    private Dictionary dictionary;
    private final JTextComponent jText;
    private Locale locale;
    private final SpellCheckerOptions options;

    static void disable(JTextComponent text) {
        AbstractDocument doc = (AbstractDocument)text.getDocument();
        for (DocumentListener listener : doc.getDocumentListeners()) {
            if (!(listener instanceof AutoSpellChecker)) continue;
            AutoSpellChecker autoSpell = (AutoSpellChecker)listener;
            doc.removeDocumentListener(autoSpell);
            AutoSpellChecker.removeHighlights(text);
        }
    }

    static void refresh(JTextComponent text) {
        AbstractDocument doc = (AbstractDocument)text.getDocument();
        for (DocumentListener listener : doc.getDocumentListeners()) {
            if (!(listener instanceof AutoSpellChecker)) continue;
            AutoSpellChecker autoSpell = (AutoSpellChecker)listener;
            autoSpell.checkAll();
        }
    }

    private static void removeHighlights(JTextComponent text) {
        Highlighter highlighter = text.getHighlighter();
        for (Highlighter.Highlight highlight : highlighter.getHighlights()) {
            if (highlight.getPainter() != painter) continue;
            highlighter.removeHighlight(highlight);
        }
    }

    public AutoSpellChecker(JTextComponent text, SpellCheckerOptions options) {
        this.jText = text;
        this.options = options == null ? SpellChecker.getOptions() : options;
        this.jText.getDocument().addDocumentListener(this);
        SpellChecker.addLanguageChangeLister(this);
        this.dictionary = SpellChecker.getCurrentDictionary();
        this.locale = SpellChecker.getCurrentLocale();
        this.checkAll();
    }

    public void changedUpdate(DocumentEvent ev) {
    }

    private void checkAll() {
        if (this.jText == null) {
            return;
        }
        if (this.dictionary == null) {
            AutoSpellChecker.removeHighlights(this.jText);
            return;
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Document document = AutoSpellChecker.this.jText.getDocument();
                int i = 0;
                while (i < document.getLength()) {
                    try {
                        Element element = ((AbstractDocument)document).getParagraphElement(i);
                        i = element.getEndOffset();
                        AutoSpellChecker.this.checkElement(element);
                    }
                    catch (Exception ex) {
                        return;
                    }
                }
            }
        }, "JOrtho checkall");
        thread.setPriority(4);
        thread.setDaemon(true);
        thread.start();
    }

    private void checkElement(final Element element) {
        try {
            String word;
            if (!EventQueue.isDispatchThread()) {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        public void run() {
                            AutoSpellChecker.this.checkElement(element);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            int i = element.getStartOffset();
            int l = ((AbstractDocument)this.jText.getDocument()).getLength();
            int j = Math.min(element.getEndOffset(), l);
            if (i >= j) {
                return;
            }
            Dictionary dic = this.dictionary;
            Locale loc = this.locale;
            if (dic == null || loc == null) {
                return;
            }
            Tokenizer tok = new Tokenizer(this.jText, dic, loc, i, j, this.options);
            Highlighter highlighter = this.jText.getHighlighter();
            while ((word = tok.nextInvalidWord()) != null) {
                int wordOffset = tok.getWordOffset();
                highlighter.addHighlight(wordOffset, wordOffset + word.length(), painter);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void removeHighlighters(Element element) {
        int i = element.getStartOffset();
        int j = element.getEndOffset();
        Highlighter highlighter = this.jText.getHighlighter();
        Highlighter.Highlight[] highlights = highlighter.getHighlights();
        int k = highlights.length;
        while (--k >= 0) {
            Highlighter.Highlight highlight = highlights[k];
            int hlStartOffset = highlight.getStartOffset();
            int hlEndOffset = highlight.getEndOffset();
            if ((i > hlStartOffset || hlStartOffset > j) && (i > hlEndOffset || hlEndOffset > j) || highlight.getPainter() != painter) continue;
            highlighter.removeHighlight(highlight);
        }
    }

    private void checkElements(int offset, int length) {
        Element element;
        int end = offset + length;
        Document document = this.jText.getDocument();
        do {
            try {
                element = ((AbstractDocument)document).getParagraphElement(offset);
            }
            catch (Exception ex) {
                return;
            }
            this.removeHighlighters(element);
            this.checkElement(element);
        } while ((offset = element.getEndOffset()) <= end && offset < document.getLength());
    }

    public void insertUpdate(DocumentEvent ev) {
        this.checkElements(ev.getOffset(), ev.getLength());
    }

    public void languageChanged(LanguageChangeEvent ev) {
        this.dictionary = SpellChecker.getCurrentDictionary();
        this.locale = SpellChecker.getCurrentLocale();
        this.checkAll();
    }

    public void removeUpdate(DocumentEvent ev) {
        this.checkElements(ev.getOffset(), 0);
    }
}

