* ADD_LOG.PRG
* Demo Coverage AddIn, Shows multiple logs being examined

LPARAMETERS toCoverageRef

********************************
* Demo AddIn Help Material:

#DEFINE COV_ADDIN_README .T.

#IF COV_ADDIN_README

   #DEFINE COV_ADDIN_HELP "ADD_READ.PRG"

   LOCAL cFile
  
   cFile = UPPER(SYS(16))

   IF LEFT(cFile,10) = "PROCEDURE "
      cFile = ;
        SUBSTR(cFile,AT(" ",cFile,2) + 1)
   ENDIF
  
   cFile = STRTRAN(cFile,;
                   SUBSTR(cFile,RAT("\",cFile)+1), ;
                   COV_ADDIN_HELP)

   IF NOT FILE(cFile)
  
      cFile = toCoverageRef.GetResourceLocation( ;
              cFile, ;
              "Please locate AddIn Help Program", ;
              "Programs" + " (*.prg)|*.prg", ;
              COV_ADDIN_HELP, ;
              "GETFILE")
   ENDIF              
          
  
   IF NOT EMPTY(cFile)
  
      DO (cFile) WITH SYS(16)
  
   ENDIF
  
#ENDIF  

*********************

LOCAL ARRAY aTemp[1]

LOCAL cExact, cNewFormName, ;
      cNewSourceAlias, ;
      cNewTargetAlias, ;
      cOldSourceFile

cExact = SET("EXACT")
SET EXACT ON

DO CASE
CASE TYPE("toCoverageRef.BaseClass") # "C" OR ;
      ACLASS(aTemp,toCoverageRef) = 0 OR ;
      ASCAN(aTemp,"COV_STANDARD") = 0
   
      MESSAGEBOX("This Demo AddIn is designed to be used only"+ CHR(13)+;
                "a Coverage Object of the Standard UI class"+CHR(13)+ ;
                 "(COV_STANDARD).",;
                16)
              
     SET EXACT &cExact
     RETURN .F.
CASE toCoverageRef.lUnattended
   MESSAGEBOX("This Demo AddIn is not designed to be used "+ CHR(13)+;
              "when the Coverage Engine is running in "+CHR(13)+ ;
              "Unattended mode."+ ;
              CHR(13)+CHR(13)+;
              "For this AddIn, use .F. as your second parameter:"+;
              CHR(13)+CHR(13)+;
              "DO (_COVERAGE) WITH <logfile>,.F.,"+toCoverageRef.cAddIn,;
              16)
   SET EXACT &cExact
   RETURN .F.
OTHERWISE
   SET EXACT &cExact   
ENDCASE

* give the new dialog we're going to add a unique name: 
cNewFormName = "frm"+SYS(2015)
* save current Engine file information:
cOldSourceFile = toCoverageRef.cSourceFile
* create some unique aliases
cNewSourceAlias = "s"+SYS(2015)
cNewTargetAlias = "t"+SUBSTR(cNewSourceAlias,2)
* create the new workfiles
IF toCoverageRef.SetUpWorkFiles(, ;
                 cNewSourceAlias,cNewTargetAlias) ;
   AND USED(cNewTargetAlias)

   * instantiate the dialog, into the frame if necessary,
   * letting it know what target file it is supposed to
   * be working with:
   IF toCoverageRef.lInCoverageFrame
      toCoverageRef.oFrame.Show()
   ENDIF
   toCoverageRef.ADDOBJECT(cNewFormName,;
                           "frmAdditionalDialog", ;
                           cNewTargetAlias)
   toCoverageRef.&cNewFormName..Show()
ENDIF   

* put the old information back in the Engine, since
* the standard UI dialog expects it there and since
* this dialog will call to the Engine specifying its
* own information when and if necessary
* we haven't touched the standard aliases 
toCoverageRef.cSourceFile = cOldSourceFile

************
*
DEFINE CLASS frmAdditionalDialog AS form

   Left = 0
   Top  = 0
   ShowWindow = 1
   Name = "frmSecondDialog"
   KeyPreview = .T.
   cMarkedCodeField = ""
   nMargin = SYSMETRIC(3)
   lInProfileMode = .F.
  
   ADD OBJECT lstAvailableObjectsAndProcs AS listbox WITH ;
      Name = "lstAvailableObjectsAndProcs", ;
      FontName = toCoverageRef.cBaseFontName, ;
      FontSize = toCoverageRef.nBaseFontSize, ;
      FontItalic = toCoverageRef.lBaseFontItalic, ;
      FontBold = toCoverageRef.lBaseFontBold, ;      
      DragMode = 1, ;
      RowSourceType = 2, ;
      ColumnCount = 2

   ADD OBJECT edtMarkedCode AS editbox WITH ;
      Name = "edtMarkedCode", ;
      FontName = toCoverageRef.cBaseMonoFontName, ;
      FontSize = toCoverageRef.nBaseMonoFontSize, ;
      FontItalic = toCoverageRef.lBaseMonoFontItalic, ;
      FontBold = toCoverageRef.lBaseMonoFontBold, ;
      DragMode = 1

   PROC RightClick
      THISFORMSET.StandardRightClick()
   ENDPROC
   
   PROC Keypress(nKeyCode, nShiftAltCtrl)
     THISFORMSET.frmMainDialog.KeyPress(nKeyCode, nShiftAltCtrl)
   ENDPROC
  
   PROC lstAvailableObjectsAndProcs.DragDrop(oSource,nXCoord,nYCoord)
      THISFORM.DragDrop(oSource, nXCoord, nYCoord)
   ENDPROC
   
   PROC edtMarkedCode.DragDrop(oSource, nXCoord, nYCoord)
      THISFORM.DragDrop(oSource, nXCoord, nYCoord)
   ENDPROC
 
   PROC DragDrop(oSource, nXCoord, nYCoord)
      DO CASE
      CASE UPPER(oSource.Name) == ;
           UPPER(THIS.Controls(1).Name) ;
           AND ;
           BETWEEN(nYCoord, ;
                   THIS.nMargin, ;
                   THIS.Height - (THIS.nMargin * 7))

         THIS.lstAvailableObjectsAndProcs.Height = nYCoord

         THIS.edtMarkedCode.Top = ;            
              (THIS.lstAvailableObjectsAndProcs.Height + ;
               (THIS.nMargin * 2))
              
         THIS.edtMarkedCode.Height = ;
              THIS.Height - ;
              (THIS.edtMarkedCode.Top + ;
               THIS.nMargin )

      CASE UPPER(oSource.Name) == ;
           UPPER(THIS.Controls(2).Name) ;
           AND ;
           BETWEEN(nYCoord, ;
                 THIS.nMargin * 4, ;
                 THIS.Height - (THIS.nMargin * 3))

         THIS.edtMarkedCode.Top = nYCoord
         THIS.edtMarkedCode.Height = ;
              THIS.Height - (nYCoord + THIS.nMargin)
         THIS.lstAvailableObjectsAndProcs.Height = ;
              (THIS.edtMarkedCode.Top - (THIS.nMargin * 3))
             
      OTHERWISE
         ?? CHR(7)
      ENDCASE
   ENDPROC
   
   PROC Resize
           
      STORE THIS.Width - (THIS.nMargin*2) TO ;
            THIS.edtMarkedCode.Width, ;
            THIS.lstAvailableObjectsAndProcs.Width
            
      STORE STR(THIS.Width/2)+","+STR(THIS.Width/2) TO ;
           THIS.lstAvailableObjectsAndProcs.ColumnWidths
           
      STORE (THIS.Height - (THIS.nMargin*3))/2 TO ;
            THIS.edtMarkedCode.Height, ;
            THIS.lstAvailableObjectsAndProcs.Height
            
      STORE THIS.lstAvailableObjectsAndProcs.Height + ;
            (THIS.nMargin*2) TO ;
            THIS.edtMarkedCode.Top

   ENDPROC
   

   PROC Init(tcTargetAlias)
      
      IF NOT TYPE("THISFORMSET.frmMainDialog.lInZoomMode") = "L"
         * quick & dirty addtl check to make sure we're
         * instantiated by the right kind of class
         RETURN .F.
      ENDIF
   
      THIS.SetInitialPropertyValues()
 
      STORE tcTargetAlias TO ;
            THIS.lstAvailableObjectsAndProcs.RowSource
      STORE THIS.cMarkedCodeField TO THIS.edtMarkedCode.ControlSource

      STORE THIS.nMargin TO ;
            THIS.edtMarkedCode.Left, ;
            THIS.lstAvailableObjectsAndProcs.Left, ;
            THIS.lstAvailableObjectsAndProcs.Top
            
      STORE THIS.Width - (THIS.nMargin*2) TO ;
            THIS.edtMarkedCode.Width, ;
            THIS.lstAvailableObjectsAndProcs.Width

      THIS.Resize()
                            
   ENDPROC
   
   PROC SetInitialPropertyValues()
      * these can't go into the Properties Window/
      * initial settings in the DEFINE CLASS
      * because they'd be cached and each instance
      * of the dialog would have the first
      * values, not the ones current at the time
      * each instance is instantiated
      THIS.MinHeight = THISFORMSET.frmMainDialog.MinHeight
      THIS.MinWidth = THISFORMSET.frmMainDialog.MinWidth
      THIS.Height = THISFORMSET.frmMainDialog.Height
      THIS.Width = THISFORMSET.frmMainDialog.Width
   
      THIS.nMargin = THISFORMSET.frmMainDialog.nMargin
      THIS.lInProfileMode = THISFORMSET.lInProfileMode
    
   
      THIS.cMarkedCodeField = IIF(THIS.lInProfileMode, ;
                                 "Profiled", "Marked")    
   ENDPROC

   PROC lstAvailableObjectsAndProcs.Destroy
      LOCAL cAliasName
      cAliasName = THIS.RowSource
      * get rid of source and target cursors for
      * this dialog:
      USE IN ("s"+SUBSTR(cAliasName,2))
      USE IN (cAliasName)
   ENDPROC

   PROC lstAvailableObjectsAndProcs.When
      LOCAL lProfileMode
      IF EMPTY(EVAL(THIS.RowSource+"."+THISFORM.cMarkedCodeField))
         lProfileMode = THISFORMSET.lInProfileMode
         THISFORMSET.lInProfileMode = THISFORM.lInProfileMode
         THISFORMSET.MarkTargetCoverage(,THIS.RowSource)
         THISFORMSET.lInProfileMode = lProfileMode
      ENDIF
      THISFORM.edtMarkedCode.Refresh()      
      
      THISFORM.Caption = ;
           ALLTR(EVAL(THIS.RowSource+".HostFile"))
      IF EMPTY(EVAL(THIS.RowSource+".ObjClass"))
         THISFORM.Caption = THISFORM.Caption+ ": ALL Classes & Procs"
      ELSE
         THISFORM.Caption = THISFORM.Caption + ": " + ;
                    ALLTR(EVAL(THIS.RowSource+".ObjClass"))
      ENDIF
   ENDPROC

ENDDEFINE
