/*
 * Decompiled with CFR 0.152.
 */
package org.plugins.generic;

import flashsystem.Bundle;
import flashsystem.X10flash;
import foxtrot.Task;
import foxtrot.Worker;
import gui.FlasherGUI;
import gui.WaitDeviceFlashmodeGUI;
import java.io.File;
import java.util.Enumeration;
import javax.swing.JFrame;
import org.logger.MyLogger;
import org.plugins.PluginDefaults;
import org.plugins.PluginInterface;
import org.plugins.generic.About;
import org.system.DeviceChangedListener;
import org.system.Devices;
import org.system.GlobalConfig;
import org.system.OS;
import org.system.PropertiesFile;
import org.system.Shell;
import org.system.TextFile;

public class UnlockBL
extends PluginDefaults
implements PluginInterface {
    String platform = "";
    String loader = "";

    public String getName() {
        return "Bootloader Unlock";
    }

    public String getPhoneCert() {
        X10flash flash = null;
        Bundle bundle = null;
        try {
            String phoneCert = "";
            bundle = new Bundle();
            bundle.setSimulate(GlobalConfig.getProperty((String)"simulate").toLowerCase().equals("yes"));
            flash = new X10flash(bundle);
            MyLogger.getLogger().info((Object)"Please connect your device into flashmode.");
            if (new WaitDeviceFlashmodeGUI(flash).deviceFound((JFrame)FlasherGUI._root)) {
                flash.openDevice();
                flash.sendLoader(new File(this.loader));
                flash.openTA(2);
                if (this.getProperty("checkbootloader").equals("true")) {
                    if (flash.getPhoneProperty("ROOTING_STATUS").equals("ROOTED")) {
                        MyLogger.getLogger().info((Object)"Phone already unlocked");
                        MyLogger.getLogger().info((Object)"You can safely reboot in normal mode");
                    } else {
                        MyLogger.initProgress((int)1);
                        phoneCert = flash.dumpProperty(2129, "hex").trim().toUpperCase();
                    }
                } else {
                    MyLogger.initProgress((int)1);
                    phoneCert = flash.dumpProperty(2129, "hex").trim().toUpperCase();
                }
            }
            MyLogger.initProgress((int)0);
            bundle.close();
            flash.closeTA();
            flash.closeDevice();
            DeviceChangedListener.pause((boolean)false);
            if (phoneCert.length() > 874) {
                return phoneCert.substring(489, 872);
            }
            return "";
        }
        catch (Exception e) {
            MyLogger.initProgress((int)0);
            if (flash != null) {
                try {
                    flash.closeTA();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                flash.closeDevice();
            }
            if (bundle != null) {
                bundle.close();
            }
            DeviceChangedListener.pause((boolean)false);
            return "";
        }
    }

    public String getBootwrite(String phoneCert) {
        String bootwrite = "";
        if (phoneCert.length() > 0) {
            PropertiesFile certs = new PropertiesFile("", this.files.getFile(this.platform, "cert.properties"));
            Enumeration<Object> e = certs.getProperties().keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!phoneCert.equals(certs.getProperty(key))) continue;
                bootwrite = key;
                MyLogger.getLogger().info((Object)("Found " + bootwrite + "SL"));
                break;
            }
            if (bootwrite.length() == 0) {
                MyLogger.getLogger().warn((Object)"Cannot identify your SL. Aborting");
                try {
                    TextFile t = new TextFile(String.valueOf(this.files.getFileDir()) + fsep + this.platform + fsep + "notfound", "ISO8859-1");
                    t.open(true);
                    t.writeln(phoneCert);
                    t.close();
                }
                catch (Exception e1) {
                    MyLogger.getLogger().error((Object)"Error writing to notfound");
                }
            }
            MyLogger.getLogger().info((Object)"You can now unplug and turn on device, then plug it again");
            if (bootwrite.length() > 0) {
                return String.valueOf(this.platform) + "bootwrite_" + bootwrite + "SL";
            }
            return "";
        }
        MyLogger.getLogger().warn((Object)"Cancelled");
        return "";
    }

    public void doTask() {
        try {
            MyLogger.getLogger().debug((Object)("Working directory : " + this._workdir));
            this.platform = this.getProperty(Devices.getCurrent().getId());
            this.loader = String.valueOf(OS.getWorkDir()) + fsep + Devices.getCurrent().getLoader();
            String currentCert = this.getPhoneCert();
            String boottool = this.getBootwrite(currentCert);
            if (boottool.length() > 0) {
                Devices.waitForReboot((boolean)false);
                if (Devices.getCurrent().isRecovery()) {
                    MyLogger.getLogger().info((Object)"Phone rebooted into recovery mode. Restart it normally");
                    Devices.waitForReboot((boolean)false);
                }
                String kernel = Devices.getCurrent().getKernelVersion();
                if (!this.files.push(this.platform, boottool)) {
                    throw new Exception("Error pushing " + boottool);
                }
                if (!this.files.push(this.platform, "mapper_" + kernel + ".ko")) {
                    throw new Exception("Error pushing mapper_" + kernel + ".ko");
                }
                if (!this.files.push(this.platform, "fixPart")) {
                    throw new Exception("Error pushing fixPart");
                }
                Shell fixpart = this.sfactory.createShell("runfixPart");
                Shell bootwrite = this.sfactory.createShell("runbootwrite");
                Shell clean = this.sfactory.createShell("runClean");
                bootwrite.setProperty("KVER", kernel);
                bootwrite.setProperty("BOOTWRITEBIN", boottool);
                clean.setProperty("BOOTWRITEBIN", boottool);
                clean.setProperty("KVER", kernel);
                if (fixpart.runRoot().contains("success")) {
                    MyLogger.getLogger().info((Object)"Successfully applied fixPart. Rebooting");
                    Devices.getCurrent().reboot();
                    Devices.waitForReboot((boolean)false);
                    if (Devices.getCurrent().isRecovery()) {
                        MyLogger.getLogger().info((Object)"Phone rebooted into recovery mode. Restart it normally");
                        Devices.waitForReboot((boolean)false);
                    }
                    if (bootwrite.runRoot().contains("successfully wrote")) {
                        MyLogger.getLogger().info((Object)"Successfully applied unlock. Rebooting");
                        clean.runRoot();
                        Devices.getCurrent().reboot();
                    } else {
                        MyLogger.getLogger().error((Object)(String.valueOf(boottool) + " failed. Aborting"));
                        clean.runRoot();
                    }
                } else {
                    MyLogger.getLogger().error((Object)"Cannot apply fixPart. Aborting");
                    clean.runRoot();
                }
            }
        }
        catch (Exception e) {
            MyLogger.getLogger().error((Object)e.getMessage());
        }
    }

    public void run() {
        try {
            if (FlasherGUI.guimode) {
                Worker.post((Task)new RunTask());
            } else {
                this.doTask();
            }
        }
        catch (Exception e) {
            MyLogger.getLogger().error((Object)e.getMessage());
        }
    }

    public void showAbout() {
        About about = new About();
        about.setVisible(true);
    }

    public class RunTask
    extends Task {
        public Object run() {
            UnlockBL.this.doTask();
            return null;
        }
    }
}

