/*
 * Decompiled with CFR 0.152.
 */
package win32lib;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.SetupApi;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.util.Map;
import org.logger.MyLogger;
import win32lib.SetupApi;

public class JsetupAPi {
    static SetupApi setupapi = (SetupApi)Native.loadLibrary((String)"setupapi", SetupApi.class, (Map)W32APIOptions.UNICODE_OPTIONS);
    public static Guid.GUID USBGuid = new Guid.GUID();
    private static SetupApi.SP_DEVINFO_DATA DeviceInfoData = new SetupApi.SP_DEVINFO_DATA();

    static {
        JsetupAPi.USBGuid.Data1 = -1512259824;
        JsetupAPi.USBGuid.Data2 = (short)25904;
        JsetupAPi.USBGuid.Data3 = (short)4562;
        JsetupAPi.USBGuid.Data4 = new byte[8];
        JsetupAPi.USBGuid.Data4[0] = -112;
        JsetupAPi.USBGuid.Data4[1] = 31;
        JsetupAPi.USBGuid.Data4[2] = 0;
        JsetupAPi.USBGuid.Data4[3] = -64;
        JsetupAPi.USBGuid.Data4[4] = 79;
        JsetupAPi.USBGuid.Data4[5] = -71;
        JsetupAPi.USBGuid.Data4[6] = 81;
        JsetupAPi.USBGuid.Data4[7] = -19;
        JsetupAPi.DeviceInfoData.cbSize = DeviceInfoData.size();
    }

    public static String getClassName(Guid.GUID guid) {
        char[] ClassName = new char[100];
        boolean result = setupapi.SetupDiClassNameFromGuid(guid, ClassName, 100, null);
        if (result) {
            String name = new String();
            int i = 0;
            while (i < 100) {
                if (ClassName[i] != '\u0000') {
                    name = String.valueOf(name) + ClassName[i];
                }
                ++i;
            }
            return name;
        }
        MyLogger.getLogger().error((Object)"Error calling SetupDiClassNameFromGuid");
        return "";
    }

    public static Guid.GUID getGUID(String classname) {
        Guid.GUID[] ClassGuidList = new Guid.GUID[100];
        IntByReference size = new IntByReference();
        boolean result = setupapi.SetupDiClassGuidsFromName(classname, ClassGuidList, 100, size);
        if (result && size.getValue() == 1) {
            return ClassGuidList[0];
        }
        MyLogger.getLogger().error((Object)("Error calling SetupDiClassNameFromGuid for " + classname));
        return null;
    }

    public static void destroyHandle(SetupApi.HDEVINFO hDevInfo) {
        setupapi.SetupDiDestroyDeviceInfoList(hDevInfo);
    }

    public static SetupApi.SP_DEVINFO_DATA enumDevInfo(SetupApi.HDEVINFO hDevInfo, int index) {
        int result = setupapi.SetupDiEnumDeviceInfo(hDevInfo, index, DeviceInfoData);
        if (result == 0) {
            return null;
        }
        return DeviceInfoData;
    }

    public static SetupApi.HDEVINFO getHandleForConnectedInterfaces() {
        return setupapi.SetupDiGetClassDevs(USBGuid, null, null, 18);
    }

    public static SetupApi.HDEVINFO getHandleForConnectedDevices() {
        return setupapi.SetupDiGetClassDevs(null, null, null, 6);
    }

    public static boolean isInstalled(SetupApi.HDEVINFO DeviceInfoSet, SetupApi.SP_DEVINFO_DATA DeviceInfoData) {
        byte[] res = new byte[]{97, 97, 97, 97};
        setupapi.SetupDiGetDeviceRegistryProperty(DeviceInfoSet, DeviceInfoData, 34, null, res, 4, null);
        return res[0] == 0;
    }

    public static String getDevId(SetupApi.HDEVINFO DeviceInfoSet, SetupApi.SP_DEVINFO_DATA DeviceInfoData) {
        char[] DeviceId = new char[100];
        boolean result = setupapi.SetupDiGetDeviceInstanceId(DeviceInfoSet, DeviceInfoData, DeviceId, 100, null);
        if (result) {
            String name = new String();
            int i = 0;
            while (i < 100) {
                if (DeviceId[i] != '\u0000') {
                    name = String.valueOf(name) + DeviceId[i];
                }
                ++i;
            }
            return name;
        }
        return "";
    }

    public static String getDevicePath(SetupApi.HDEVINFO hDevInfo, SetupApi.SP_DEVINFO_DATA DeviceInfoData) {
        int result;
        String devpath = "";
        SetupApi.SP_DEVICE_INTERFACE_DATA DeviceInterfaceData = new SetupApi.SP_DEVICE_INTERFACE_DATA();
        DeviceInterfaceData.cbSize = DeviceInterfaceData.size();
        int index = 0;
        while ((result = setupapi.SetupDiEnumDeviceInterfaces(hDevInfo, DeviceInfoData, USBGuid, index, DeviceInterfaceData)) != 0) {
            IntByReference reqlength = new IntByReference();
            result = setupapi.SetupDiGetDeviceInterfaceDetail(hDevInfo, DeviceInterfaceData, null, 0, reqlength, null);
            SetupApi.SP_DEVICE_INTERFACE_DETAIL_DATA DeviceInterfaceDetailData = new SetupApi.SP_DEVICE_INTERFACE_DETAIL_DATA(reqlength.getValue());
            result = setupapi.SetupDiGetDeviceInterfaceDetail(hDevInfo, DeviceInterfaceData, DeviceInterfaceDetailData, reqlength.getValue(), reqlength, null);
            devpath = Native.toString((char[])DeviceInterfaceDetailData.devicePath);
            if (devpath.length() == 0) {
                SetupApi.SP_DEVICE_INTERFACE_DETAIL_DATA DeviceInterfaceDetailDataDummy = new SetupApi.SP_DEVICE_INTERFACE_DETAIL_DATA();
                DeviceInterfaceDetailData.cbSize = DeviceInterfaceDetailDataDummy.size();
                result = setupapi.SetupDiGetDeviceInterfaceDetail(hDevInfo, DeviceInterfaceData, DeviceInterfaceDetailData, reqlength.getValue(), reqlength, null);
                devpath = Native.toString((char[])DeviceInterfaceDetailData.devicePath);
            }
            ++index;
        }
        return devpath;
    }
}

