/*
 * Decompiled with CFR 0.152.
 */
package win32lib;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.W32APIOptions;
import flashsystem.BytesUtil;
import java.io.IOException;
import java.util.Map;
import org.system.Device;
import win32lib.Kernel32RW;

public class JKernel32 {
    public static Kernel32RW kernel32 = (Kernel32RW)Native.loadLibrary((String)"kernel32", Kernel32RW.class, (Map)W32APIOptions.UNICODE_OPTIONS);
    static WinNT.HANDLE HandleToDevice = WinBase.INVALID_HANDLE_VALUE;
    static WinBase.OVERLAPPED ovwrite = new WinBase.OVERLAPPED();

    public static boolean openDevice() throws IOException {
        int shareMode = 3;
        int Access = -1073741824;
        HandleToDevice = Kernel32.INSTANCE.CreateFile(Device.getConnectedDeviceWin32().getDevPath(), Access, shareMode, null, 3, 0, null);
        if (HandleToDevice == WinBase.INVALID_HANDLE_VALUE) {
            throw new IOException(JKernel32.getLastError());
        }
        return true;
    }

    public static boolean openDeviceAsync() throws IOException {
        int shareMode = 3;
        int Access = -1073741824;
        HandleToDevice = Kernel32.INSTANCE.CreateFile(Device.getConnectedDeviceWin32().getDevPath(), Access, shareMode, null, 3, 0x40000000, null);
        if (HandleToDevice == WinBase.INVALID_HANDLE_VALUE) {
            throw new IOException(JKernel32.getLastError());
        }
        return true;
    }

    public static byte[] readBytes(int bufsize) throws IOException {
        byte[] b2 = new byte[bufsize];
        IntByReference nbread = new IntByReference();
        boolean result = kernel32.ReadFile(HandleToDevice, b2, bufsize, nbread, null);
        if (!result) {
            throw new IOException("Read error :" + JKernel32.getLastError());
        }
        return BytesUtil.getReply(b2, nbread.getValue());
    }

    public static WinNT.HANDLE createEvent() throws IOException {
        WinNT.HANDLE hevent = kernel32.CreateEvent(null, false, false, null);
        int res = kernel32.GetLastError();
        if (hevent == WinBase.INVALID_HANDLE_VALUE || res != 0) {
            throw new IOException(JKernel32.getLastError());
        }
        return hevent;
    }

    public static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean writeBytes(byte[] bytes) throws IOException {
        IntByReference nbwritten = new IntByReference();
        boolean result = kernel32.WriteFile(HandleToDevice, bytes, bytes.length, nbwritten, null);
        if (!result && !result) {
            throw new IOException(JKernel32.getLastError());
        }
        if (nbwritten.getValue() != bytes.length) {
            throw new IOException("Did not write all data");
        }
        bytes = null;
        return result;
    }

    public static boolean closeDevice() {
        boolean result = true;
        if (HandleToDevice != WinBase.INVALID_HANDLE_VALUE) {
            result = kernel32.CloseHandle(HandleToDevice);
        }
        HandleToDevice = WinBase.INVALID_HANDLE_VALUE;
        return result;
    }

    public static int getLastErrorCode() {
        return Kernel32.INSTANCE.GetLastError();
    }

    public static String getLastError() {
        int code = Kernel32.INSTANCE.GetLastError();
        Kernel32 lib = Kernel32.INSTANCE;
        PointerByReference pref = new PointerByReference();
        lib.FormatMessage(4864, null, code, 0, pref, 0, null);
        String s = String.valueOf(code) + " : " + pref.getValue().getString(0L, !Boolean.getBoolean("w32.ascii"));
        lib.LocalFree(pref.getValue());
        return s.replaceAll("[\n\r]+", " ");
    }
}

