/*
 * Decompiled with CFR 0.152.
 */
package org.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.io.IOUtils;

public final class TextFile {
    private final String fFileName;
    private final String fEncoding;
    private PrintWriter pwriter;
    private Map<Integer, String> lines = null;

    public TextFile(String aFileName, String aEncoding) {
        this.fFileName = aFileName;
        this.fEncoding = aEncoding;
    }

    public void open(boolean append) throws IOException {
        this.pwriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fFileName), this.fEncoding));
    }

    public void write(String aText) throws IOException {
        this.pwriter.print(aText);
    }

    public void writeln(String aText) throws IOException {
        this.pwriter.print(String.valueOf(aText) + "\n");
    }

    public void close() throws IOException {
        try {
            this.pwriter.flush();
            this.pwriter.close();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void delete() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        File f = new File(this.fFileName);
        f.delete();
    }

    public void readLines() throws IOException {
        this.lines = new Hashtable<Integer, String>();
        Scanner scanner = new Scanner(new FileInputStream(this.fFileName));
        try {
            int linenumber = 1;
            while (scanner.hasNextLine()) {
                String aline = scanner.nextLine();
                this.lines.put(linenumber++, aline);
            }
        }
        finally {
            scanner.close();
        }
    }

    public Collection<String> getLines() throws IOException {
        if (this.lines == null) {
            this.readLines();
        }
        return this.lines.values();
    }

    public Map<Integer, String> getMap() throws IOException {
        if (this.lines == null) {
            this.readLines();
        }
        return this.lines;
    }

    public static boolean exists(String name) {
        File f = new File(name);
        return f.exists();
    }

    public void setProperty(String property, String value) throws Exception {
        String content = IOUtils.toString((InputStream)new FileInputStream(this.fFileName), (String)this.fEncoding);
        content = content.replaceAll(property, value);
        IOUtils.write((String)content, (OutputStream)new FileOutputStream(this.fFileName), (String)this.fEncoding);
    }
}

