/*
 * Decompiled with CFR 0.152.
 */
package org.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.adb.AdbUtility;
import org.apache.commons.io.IOUtils;
import org.system.Devices;
import org.system.GlobalConfig;
import org.system.OS;

public class Shell {
    File _file;
    File _runfile = null;
    String _name;
    String content;
    String fsep = OS.getFileSeparator();

    public Shell(File file) throws Exception {
        this.init(file);
    }

    public void init(File file) throws Exception {
        this._file = file;
        this._name = file.getName();
        FileInputStream fin = new FileInputStream(this._file);
        this.content = IOUtils.toString((InputStream)fin, (String)"ISO-8859-1");
        fin.close();
        this.setProperty("DEVICEWORKDIR", GlobalConfig.getProperty("deviceworkdir"));
        this.setProperty("SHELLPATH", AdbUtility.getShPath(false));
    }

    public Shell(String shell) throws Exception {
        this.init(new File(String.valueOf(AdbUtility.getShellPath()) + this.fsep + shell));
    }

    public void save() throws Exception {
        this._runfile = new File(this._file.getAbsoluteFile() + "_work");
        FileOutputStream fout = new FileOutputStream(this._runfile);
        IOUtils.write((String)this.content, (OutputStream)fout, (String)"ISO-8859-1");
        fout.flush();
        fout.close();
    }

    public void setProperty(String property, String value) {
        this.content = this.content.replaceAll(property, value);
    }

    public String getName() {
        return this._name;
    }

    public String getPath() {
        if (this._runfile != null) {
            return this._runfile.getAbsolutePath();
        }
        return this._file.getAbsolutePath();
    }

    public void clean() {
        if (this._runfile != null) {
            this._runfile.delete();
        }
    }

    public String run(boolean log) throws Exception {
        this.save();
        String result = AdbUtility.run(this, log);
        this.clean();
        return result;
    }

    public String runRoot() throws Exception {
        this.save();
        boolean datamounted = true;
        boolean systemmounted = true;
        if (Devices.getCurrent().isRecovery()) {
            datamounted = AdbUtility.isMounted("/data");
            systemmounted = AdbUtility.isMounted("/data");
            if (!datamounted) {
                AdbUtility.mount("/data", "rw", "yaffs2");
            }
            if (!systemmounted) {
                AdbUtility.mount("/system", "ro", "yaffs2");
            }
        }
        String result = AdbUtility.runRoot(this);
        this.clean();
        if (Devices.getCurrent().isRecovery()) {
            if (!datamounted) {
                AdbUtility.umount("/data");
            }
            if (!systemmounted) {
                AdbUtility.umount("/system");
            }
        }
        return result;
    }

    public String runRoot(boolean debug) throws Exception {
        this.save();
        boolean datamounted = true;
        boolean systemmounted = true;
        if (Devices.getCurrent().isRecovery()) {
            datamounted = AdbUtility.isMounted("/data");
            systemmounted = AdbUtility.isMounted("/data");
            if (!datamounted) {
                AdbUtility.mount("/data", "rw", "yaffs2");
            }
            if (!systemmounted) {
                AdbUtility.mount("/system", "ro", "yaffs2");
            }
        }
        String result = AdbUtility.runRoot(this, debug);
        this.clean();
        if (Devices.getCurrent().isRecovery()) {
            if (!datamounted) {
                AdbUtility.umount("/data");
            }
            if (!systemmounted) {
                AdbUtility.umount("/system");
            }
        }
        return result;
    }
}

