/*
 * Decompiled with CFR 0.152.
 */
package org.system;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.Set;

public class PropertiesFile {
    String rname;
    String fname;
    Properties props;

    public PropertiesFile() {
        this.props = new Properties();
    }

    public void setProperties(Properties p) {
        this.props = p;
    }

    public void open(String arname, String afname) {
        this.rname = arname;
        this.fname = afname;
        try {
            this.props = new Properties();
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(this.fname), "UTF-8");
            this.props.load(in);
        }
        catch (Exception e) {
            try {
                this.props = new Properties();
                if (this.rname.length() > 0) {
                    InputStreamReader in = new InputStreamReader(PropertiesFile.class.getClassLoader().getResourceAsStream(this.rname), "UTF-8");
                    this.props.load(in);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public PropertiesFile(String arname, String afname) {
        this.open(arname, afname);
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public Set<Object> keySet() {
        return this.props.keySet();
    }

    public void setProperty(String key, String value) {
        this.props.setProperty(key, value);
    }

    public void write(String filename, String encoding) {
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(filename), encoding);
            this.props.store(out, null);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void write(String encoding) {
        this.write(this.fname, encoding);
    }

    public Properties getProperties() {
        return this.props;
    }

    public void load(InputStream is) throws Exception {
        this.props.load(is);
    }

    public void remove(String key) {
        this.props.remove(key);
    }
}

