/*
 * Decompiled with CFR 0.152.
 */
package org.system;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.logger.MyLogger;
import org.system.RunOutputs;

public class ProcessBuilderWrapper {
    private StringWriter infos;
    private StringWriter errors;
    private int status;
    private boolean print = false;

    public ProcessBuilderWrapper(File directory, List<String> command) throws Exception {
        this.run(directory, command);
    }

    public void run(File directory, List<String> command) throws Exception {
        this.infos = new StringWriter();
        this.errors = new StringWriter();
        ProcessBuilder pb = new ProcessBuilder(command);
        if (directory != null) {
            pb.directory(directory);
        }
        Process process = pb.start();
        StreamBoozer seInfo = new StreamBoozer(process.getInputStream(), new PrintWriter((Writer)this.infos, true));
        StreamBoozer seError = new StreamBoozer(process.getErrorStream(), new PrintWriter((Writer)this.errors, true));
        seInfo.start();
        seError.start();
        this.status = process.waitFor();
        seInfo.join();
        seError.join();
    }

    public ProcessBuilderWrapper(List<String> command) throws Exception {
        this.run(null, command);
    }

    public ProcessBuilderWrapper(String[] command, boolean print) throws Exception {
        this.print = print;
        ArrayList<String> cmd = new ArrayList<String>();
        int i = 0;
        while (i < command.length) {
            cmd.add(command[i]);
            ++i;
        }
        this.run(null, cmd);
    }

    public String getStdErr() {
        return this.errors.toString();
    }

    public String getStdOut() {
        return this.infos.toString();
    }

    public RunOutputs getOutputs() {
        return new RunOutputs(this.infos.toString(), this.errors.toString());
    }

    public int getStatus() {
        return this.status;
    }

    public void kill() {
    }

    class StreamBoozer
    extends Thread {
        private InputStream in;
        private PrintWriter pw;

        StreamBoozer(InputStream in, PrintWriter pw) {
            this.in = in;
            this.pw = pw;
        }

        @Override
        public void run() {
            BufferedReader br = null;
            try {
                try {
                    br = new BufferedReader(new InputStreamReader(this.in));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        if (line.trim().replaceAll("\n", "").length() <= 0) continue;
                        line = line.replaceAll("\n", "");
                        if (ProcessBuilderWrapper.this.print) {
                            MyLogger.getLogger().info((Object)line);
                        } else {
                            MyLogger.getLogger().debug((Object)line);
                        }
                        this.pw.println(line);
                    }
                }
                catch (Exception exception) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

