/*
 * Decompiled with CFR 0.152.
 */
package org.system;

import javax.swing.event.EventListenerList;
import org.system.Device;
import org.system.DeviceIdent;
import org.system.GlobalState;
import org.system.StatusEvent;
import org.system.StatusListener;

public class PhoneThread
extends Thread {
    boolean done = false;
    boolean paused = false;
    boolean forced = false;
    String status = "";
    private final EventListenerList listeners = new EventListenerList();

    @Override
    public void run() {
        int count = 0;
        int nbnull = 0;
        DeviceIdent id = null;
        while (!this.done) {
            if (!this.paused) {
                id = Device.getConnectedDevice();
                if (id.getPid().equals("ADDE")) {
                    GlobalState.setState(id.getSerial(), id.getPid(), "flash");
                } else if (id.getPid().equals("0DDE")) {
                    GlobalState.setState(id.getSerial(), id.getPid(), "fastboot");
                }
                if (id.getStatus().length() == 0) {
                    if (++nbnull == 5) {
                        GlobalState.setState(id.getSerial(), id.getPid(), "normal");
                    }
                } else {
                    nbnull = 0;
                    String lstatus = id.getStatus();
                    if (!lstatus.equals(this.status)) {
                        if (!lstatus.equals("adb")) {
                            this.fireStatusChanged(new StatusEvent(lstatus, id.isDriverOk()));
                        }
                        this.status = lstatus;
                    }
                }
            }
            try {
                while (count < 50 && !this.done) {
                    PhoneThread.sleep(10L);
                    ++count;
                }
                count = 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Device.clean();
    }

    public void pause(boolean ppaused) {
        this.paused = ppaused;
        this.status = "paused";
    }

    public void end() {
        this.done = true;
    }

    public void addStatusListener(StatusListener listener) {
        this.listeners.add(StatusListener.class, listener);
    }

    public void removeStatusListener(StatusListener listener) {
        this.listeners.remove(StatusListener.class, listener);
    }

    public StatusListener[] getStatusListeners() {
        return (StatusListener[])this.listeners.getListeners(StatusListener.class);
    }

    protected void fireStatusChanged(StatusEvent e) {
        StatusListener[] statusListenerArray = this.getStatusListeners();
        int n = statusListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            StatusListener listener = statusListenerArray[n2];
            listener.statusChanged(e);
            ++n2;
        }
    }

    public void forceDetection() {
        if (!this.forced) {
            this.forced = true;
        }
    }

    public void doSleep(int time) {
        try {
            PhoneThread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

