/*
 * Decompiled with CFR 0.152.
 */
package org.system;

import flashsystem.HexDump;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Collection;
import java.util.HashSet;
import javax.crypto.Cipher;
import org.logger.MyLogger;
import org.system.ProcessBuilderWrapper;

public class OS {
    public static String getName() {
        String os = "";
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
            os = "windows";
        } else if (System.getProperty("os.name").toLowerCase().indexOf("linux") > -1) {
            os = "linux";
        } else if (System.getProperty("os.name").toLowerCase().indexOf("mac") > -1) {
            os = "mac";
        }
        return os;
    }

    public static void unyaffs(String yaffsfile, String folder) {
        try {
            File f = new File(folder);
            if (!f.exists()) {
                f.mkdir();
            } else if (f.isFile()) {
                throw new IOException("destination must be a folder");
            }
            ProcessBuilderWrapper processBuilderWrapper = new ProcessBuilderWrapper(new String[]{String.valueOf(OS.getWorkDir()) + File.separator + "x10flasher_lib" + File.separator + "unyaffs." + OS.getName(), yaffsfile, folder}, false);
        }
        catch (Exception e) {
            MyLogger.getLogger().warn((Object)("Failed : " + e.getMessage()));
        }
    }

    public static String getAdbPath() {
        String fsep = OS.getFileSeparator();
        if (OS.getName().equals("windows")) {
            return new File(String.valueOf(System.getProperty("user.dir")) + fsep + "x10flasher_lib" + fsep + "adb.exe").getAbsolutePath();
        }
        return new File(String.valueOf(System.getProperty("user.dir")) + fsep + "x10flasher_lib" + fsep + "adb." + OS.getName()).getAbsolutePath();
    }

    public static String getBin2SinPath() {
        String fsep = OS.getFileSeparator();
        if (OS.getName().equals("windows")) {
            return new File(String.valueOf(System.getProperty("user.dir")) + fsep + "x10flasher_lib" + fsep + "bin2sin.exe").getAbsolutePath();
        }
        return new File(String.valueOf(System.getProperty("user.dir")) + fsep + "x10flasher_lib" + fsep + "bin2sin").getAbsolutePath();
    }

    public static String getBin2ElfPath() {
        String fsep = OS.getFileSeparator();
        if (OS.getName().equals("windows")) {
            return new File(String.valueOf(System.getProperty("user.dir")) + fsep + "x10flasher_lib" + fsep + "bin2elf.exe").getAbsolutePath();
        }
        return new File(String.valueOf(System.getProperty("user.dir")) + fsep + "x10flasher_lib" + fsep + "bin2elf").getAbsolutePath();
    }

    public static String get7z() {
        String fsep = OS.getFileSeparator();
        return new File(String.valueOf(System.getProperty("user.dir")) + fsep + "x10flasher_lib" + fsep + "7z.exe").getAbsolutePath();
    }

    public static String getFastBootPath() {
        String fsep = OS.getFileSeparator();
        if (OS.getName().equals("windows")) {
            return new File(String.valueOf(System.getProperty("user.dir")) + fsep + "x10flasher_lib" + fsep + "fastboot.exe").getAbsolutePath();
        }
        return new File(String.valueOf(System.getProperty("user.dir")) + fsep + "x10flasher_lib" + fsep + "fastboot." + OS.getName()).getAbsolutePath();
    }

    public static String getWorkDir() {
        return System.getProperty("user.dir");
    }

    public static String getSHA256(byte[] array) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(array, 0, array.length);
            byte[] sha256 = digest.digest();
            return HexDump.toHex(sha256);
        }
        catch (NoSuchAlgorithmException nsa) {
            throw new RuntimeException("Unable to process file for SHA-256", nsa);
        }
    }

    public static String getSHA1(byte[] array) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(array, 0, array.length);
            byte[] sha1 = digest.digest();
            return HexDump.toHex(sha1);
        }
        catch (NoSuchAlgorithmException nsa) {
            throw new RuntimeException("Unable to process file for SHA-256", nsa);
        }
    }

    public static String getSHA256(File f) {
        byte[] buffer = new byte[8192];
        int read = 0;
        InputStream is = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            is = new FileInputStream(f);
            while ((read = is.read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] sha256 = digest.digest();
            BigInteger bigInt = new BigInteger(1, sha256);
            String output = bigInt.toString(32);
            String string = output.toUpperCase();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to process file for SHA-256", e);
        }
        catch (NoSuchAlgorithmException nsa) {
            throw new RuntimeException("Unable to process file for SHA-256", nsa);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close input stream for SHA-256 calculation", e);
            }
        }
    }

    public static void copyfile(String srFile, String dtFile) {
        try {
            File f1 = new File(srFile);
            File f2 = new File(dtFile);
            if (!f1.getAbsolutePath().equals(f2.getAbsolutePath())) {
                int len;
                FileInputStream in = new FileInputStream(f1);
                FileOutputStream out = new FileOutputStream(f2);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
        }
        catch (FileNotFoundException ex) {
            MyLogger.getLogger().error((Object)(String.valueOf(ex.getMessage()) + " in the specified directory."));
        }
        catch (IOException e) {
            MyLogger.getLogger().error((Object)e.getMessage());
        }
    }

    public static String getMD5(File f) {
        byte[] buffer = new byte[8192];
        int read = 0;
        InputStream is = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            is = new FileInputStream(f);
            while ((read = is.read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            String output = bigInt.toString(16);
            String string = output.toUpperCase();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to process file for MD5", e);
        }
        catch (NoSuchAlgorithmException nsa) {
            throw new RuntimeException("Unable to process file for MD5", nsa);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close input stream for MD5 calculation", e);
            }
        }
    }

    public static String getVersion() {
        return System.getProperty("os.version");
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getWinDir() {
        if (System.getenv("WINDIR") == null) {
            return System.getenv("SYSTEMROOT");
        }
        if (System.getenv("WINDIR").length() == 0) {
            return System.getenv("SYSTEMROOT");
        }
        return System.getenv("WINDIR");
    }

    public static String getSystem32Dir() {
        return String.valueOf(OS.getWinDir()) + OS.getFileSeparator() + "System32";
    }

    public static Collection<File> listFileTree(File dir) {
        HashSet<File> fileTree = new HashSet<File>();
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File entry = fileArray[n2];
            if (entry.isFile()) {
                fileTree.add(entry);
            } else {
                fileTree.addAll(OS.listFileTree(entry));
                fileTree.add(entry);
            }
            ++n2;
        }
        return fileTree;
    }

    public static void decrypt(File in) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        FileInputStream keyfis = new FileInputStream(String.valueOf(OS.getWorkDir()) + File.separator + "custom" + File.separator + "root" + File.separator + "keys" + File.separator + "privkey");
        byte[] encKey = new byte[keyfis.available()];
        keyfis.read(encKey);
        keyfis.close();
        PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(encKey);
        PrivateKey privKey = keyFactory.generatePrivate(privKeySpec);
        OS.encryptDecryptFile(in.getAbsolutePath(), String.valueOf(in.getAbsolutePath()) + ".dec", privKey, 2);
    }

    public static void encrypt(File in) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        FileInputStream keyfis = new FileInputStream(String.valueOf(OS.getWorkDir()) + File.separator + "custom" + File.separator + "root" + File.separator + "keys" + File.separator + "pubkey");
        byte[] decKey = new byte[keyfis.available()];
        keyfis.read(decKey);
        keyfis.close();
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(decKey);
        PublicKey pubKey = keyFactory.generatePublic(pubKeySpec);
        OS.encryptDecryptFile(in.getAbsolutePath(), String.valueOf(in.getAbsolutePath()) + ".enc", pubKey, 1);
    }

    public static void encryptDecryptFile(String srcFileName, String destFileName, Key key, int cipherMode) throws Exception {
        if (srcFileName.endsWith(".enc")) {
            destFileName = srcFileName.substring(0, srcFileName.lastIndexOf(".enc"));
        }
        OutputStream outputWriter = null;
        InputStream inputReader = null;
        if (cipherMode == 1) {
            MyLogger.getLogger().info((Object)("Encrypting " + srcFileName + " to " + destFileName));
        } else {
            MyLogger.getLogger().info((Object)("Decrypting " + srcFileName + " to " + destFileName));
        }
        try {
            int bufl;
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            Object textLine = null;
            byte[] buf = cipherMode == 1 ? new byte[100] : new byte[128];
            cipher.init(cipherMode, key);
            outputWriter = new FileOutputStream(destFileName);
            inputReader = new FileInputStream(srcFileName);
            while ((bufl = inputReader.read(buf)) != -1) {
                byte[] encText = null;
                encText = cipherMode == 1 ? OS.encrypt(OS.copyBytes(buf, bufl), (PublicKey)key) : OS.decrypt(OS.copyBytes(buf, bufl), (PrivateKey)key);
                outputWriter.write(encText);
            }
            outputWriter.flush();
        }
        finally {
            try {
                if (outputWriter != null) {
                    outputWriter.close();
                }
                if (inputReader != null) {
                    inputReader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static byte[] copyBytes(byte[] arr, int length) {
        byte[] newArr = null;
        if (arr.length == length) {
            newArr = arr;
        } else {
            newArr = new byte[length];
            int i = 0;
            while (i < length) {
                newArr[i] = arr[i];
                ++i;
            }
        }
        return newArr;
    }

    public static byte[] encrypt(byte[] text, PublicKey key) throws Exception {
        byte[] cipherText = null;
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, key);
        cipherText = cipher.doFinal(text);
        return cipherText;
    }

    public static byte[] decrypt(byte[] text, PrivateKey key) throws Exception {
        byte[] dectyptedText = null;
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, key);
        try {
            dectyptedText = cipher.doFinal(text);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dectyptedText;
    }
}

