/*
 * Decompiled with CFR 0.152.
 */
package org.system;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.logger.MyLogger;
import org.system.Elf;

public class ElfProgram {
    private long p_type;
    private int partnum;
    private ElfProgramType type;
    private long p_offset;
    private long p_vaddr;
    private long p_paddr;
    private long p_filesz;
    private long p_memsz;
    private long p_flags;
    private Set<ElfProgramFlag> flags = new HashSet<ElfProgramFlag>();
    private long p_align;
    private String ctype;
    private Elf object;

    public ElfProgram(Elf object, byte[] programHeaderData, int partnum) {
        this.object = object;
        this.partnum = partnum;
        this.parseHeader(programHeaderData);
    }

    private void parseHeader(byte[] data) {
        this.p_type = this.object.elf32_wordToLong(data, 0);
        this.type = ElfProgramType.valueToProgramType(this.p_type);
        this.p_offset = this.object.elf32_wordToLong(data, 4);
        this.p_vaddr = this.object.elf32_wordToLong(data, 8);
        this.p_paddr = this.object.elf32_wordToLong(data, 12);
        this.p_filesz = this.object.elf32_wordToLong(data, 16);
        this.p_memsz = this.object.elf32_wordToLong(data, 20);
        this.p_flags = this.object.elf32_wordToLong(data, 24);
        this.interpretFlags();
        this.p_align = this.object.elf32_wordToLong(data, 28);
    }

    private void interpretFlags() {
        ElfProgramFlag[] elfProgramFlagArray = ElfProgramFlag.values();
        int n = elfProgramFlagArray.length;
        int n2 = 0;
        while (n2 < n) {
            ElfProgramFlag f = elfProgramFlagArray[n2];
            if ((this.p_flags & f.getValue()) == f.getValue()) {
                this.flags.add(f);
            }
            ++n2;
        }
    }

    public void setContentType(String ctype) {
        this.ctype = ctype.length() > 0 ? ctype : Integer.toString(this.partnum);
        this.printInfo();
    }

    public void printInfo() {
        String pname = "Program Name : " + this.ctype;
        String result = "";
        result = pname.length() >= 25 ? String.format(String.valueOf(pname) + "\tsize : 0x%08x\tLoad address: 0x%08x", this.p_filesz, this.p_vaddr) : String.format(String.valueOf(pname) + "\t\tsize : 0x%08x\tLoad address: 0x%08x", this.p_filesz, this.p_vaddr);
        MyLogger.getLogger().info((Object)result);
    }

    public ElfProgramType getType() {
        return this.type;
    }

    public long getProgramSize() {
        return this.p_memsz;
    }

    public long getOffset() {
        return this.p_offset;
    }

    public String getFileName() {
        return String.valueOf(this.object.getFileName()) + "." + this.ctype;
    }

    public String getName() {
        return String.valueOf(this.object.getName()) + "." + this.ctype;
    }

    public static enum ElfProgramFlag {
        PF_X(1L){

            @Override
            public String toString() {
                return "x";
            }
        }
        ,
        PF_W(2L){

            @Override
            public String toString() {
                return "w";
            }
        }
        ,
        PF_R(4L){

            @Override
            public String toString() {
                return "r";
            }
        };

        private long value;
        private static Map<Long, ElfProgramFlag> longToElfProgramFlag;

        static {
            longToElfProgramFlag = new HashMap<Long, ElfProgramFlag>();
            ElfProgramFlag[] elfProgramFlagArray = ElfProgramFlag.values();
            int n = elfProgramFlagArray.length;
            int n2 = 0;
            while (n2 < n) {
                ElfProgramFlag f = elfProgramFlagArray[n2];
                longToElfProgramFlag.put(f.getValue(), f);
                ++n2;
            }
        }

        private ElfProgramFlag(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        public abstract String toString();

        public static ElfProgramFlag valueToProgramFlag(long value) {
            return longToElfProgramFlag.get(value);
        }
    }

    public static enum ElfProgramType {
        PT_NULL(0L),
        PT_LOAD(1L),
        PT_DYNAMIC(2L),
        PT_INTERP(3L),
        PT_NOTE(4L),
        PT_SHLIB(5L),
        PT_PHDR(6L),
        PT_CERT(558778707L);

        private long value;
        private static Map<Long, ElfProgramType> longToElfProgramType;

        static {
            longToElfProgramType = new HashMap<Long, ElfProgramType>();
            ElfProgramType[] elfProgramTypeArray = ElfProgramType.values();
            int n = elfProgramTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ElfProgramType f = elfProgramTypeArray[n2];
                longToElfProgramType.put(f.getValue(), f);
                ++n2;
            }
        }

        private ElfProgramType(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        public static ElfProgramType valueToProgramType(long value) {
            return longToElfProgramType.get(value);
        }
    }
}

