/*
 * Decompiled with CFR 0.152.
 */
package org.system;

import flashsystem.HexDump;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.logger.MyLogger;
import org.system.ElfProgram;

public class Elf {
    private static final int headerSize = 52;
    private ByteOrder order;
    private ElfClass elfClass;
    private ElfType elfType;
    private int e_type;
    private int e_machine;
    private long e_version;
    private long e_entry;
    private long e_phoff;
    private long e_shoff;
    private long e_flags;
    private int e_ehsize;
    private int e_phentsize;
    private int e_phnum;
    private int e_shentsize;
    private int e_shnum;
    private int e_shstrndx;
    private ElfProgram[] phEntries;
    private boolean valid = false;
    private File theFile;

    public Elf(File file) throws FileNotFoundException, IOException {
        this.theFile = file;
        byte[] data = new byte[52];
        FileInputStream fin = new FileInputStream(this.theFile);
        fin.read(data, 0, data.length);
        fin.close();
        this.readHeaderData(data);
    }

    private boolean readHeaderData(byte[] data) throws IOException, FileNotFoundException {
        if ((data[0] != 127 || data[1] != 69) && data[1] != 76 && data[2] != 70) {
            return false;
        }
        this.valid = true;
        this.elfClass = ElfClass.valueToClass(data[4]);
        if (this.elfClass == ElfClass.invalid) {
            this.valid = false;
            return false;
        }
        switch (data[5]) {
            case 1: {
                this.order = ByteOrder.LITTLE_ENDIAN;
                break;
            }
            case 2: {
                this.order = ByteOrder.BIG_ENDIAN;
                break;
            }
            default: {
                this.valid = false;
                return false;
            }
        }
        this.e_type = this.elf32_halfToInteger(data, 16);
        this.e_machine = this.elf32_halfToInteger(data, 18);
        this.e_version = this.elf32_wordToLong(data, 20);
        this.e_entry = this.elf32_wordToLong(data, 24);
        this.e_phoff = this.elf32_wordToLong(data, 28);
        this.e_shoff = this.elf32_wordToLong(data, 32);
        this.e_flags = this.elf32_wordToLong(data, 36);
        this.e_flags = this.elf32_halfToInteger(data, 40);
        this.e_phentsize = this.elf32_halfToInteger(data, 42);
        this.e_phnum = this.elf32_halfToInteger(data, 44);
        this.e_shentsize = this.elf32_halfToInteger(data, 46);
        this.e_shnum = this.elf32_halfToInteger(data, 48);
        this.e_shstrndx = this.elf32_halfToInteger(data, 50);
        int offset = (int)this.e_shoff + this.e_shentsize;
        RandomAccessFile fin = new RandomAccessFile(this.theFile, "r");
        offset = (int)this.e_phoff;
        this.phEntries = new ElfProgram[this.e_phnum];
        byte[] programHeaderData = new byte[this.e_phentsize];
        int i = 0;
        while (i < this.phEntries.length) {
            fin.seek(offset);
            fin.read(programHeaderData, 0, this.e_phentsize);
            this.phEntries[i] = new ElfProgram(this, programHeaderData, i + 1);
            fin.seek(this.phEntries[i].getOffset());
            byte[] ident = new byte[this.phEntries[i].getProgramSize() < 352L ? (int)this.phEntries[i].getProgramSize() : 352];
            fin.read(ident);
            String identHex = HexDump.toHex(ident);
            if (identHex.contains("[1F, 8B")) {
                this.phEntries[i].setContentType("ramdisk.gz");
            } else if (identHex.contains("[00, 00, A0, E1")) {
                this.phEntries[i].setContentType("Image");
            } else if (identHex.contains("53, 31, 5F, 52, 50, 4D")) {
                this.phEntries[i].setContentType("rpm.bin");
            } else if (new String(ident).contains("S1_Root") || new String(ident).contains("S1_SW_Root")) {
                this.phEntries[i].setContentType("cert");
            } else if (ident.length < 200) {
                this.phEntries[i].setContentType("bootcmd");
            } else {
                this.phEntries[i].setContentType("");
            }
            offset += this.e_phentsize;
            ++i;
        }
        fin.close();
        return true;
    }

    public int elf32_halfToInteger(byte[] buffer, int offset) {
        byte[] newbytes = new byte[4];
        Arrays.fill(newbytes, (byte)0);
        System.arraycopy(buffer, offset, newbytes, this.order == ByteOrder.LITTLE_ENDIAN ? 0 : 2, 2);
        ByteBuffer buf = ByteBuffer.wrap(newbytes).order(this.order);
        return buf.getInt();
    }

    public long elf32_wordToLong(byte[] buffer, int offset) {
        byte[] newbytes = new byte[8];
        Arrays.fill(newbytes, (byte)0);
        System.arraycopy(buffer, offset, newbytes, this.order == ByteOrder.LITTLE_ENDIAN ? 0 : 4, 4);
        ByteBuffer buf = ByteBuffer.wrap(newbytes).order(this.order);
        return buf.getLong();
    }

    public boolean isValid() {
        return this.valid;
    }

    public ElfProgram getLoadProgramEntry() {
        ElfProgram[] elfProgramArray = this.phEntries;
        int n = this.phEntries.length;
        int n2 = 0;
        while (n2 < n) {
            ElfProgram p = elfProgramArray[n2];
            if (p.getType() == ElfProgram.ElfProgramType.PT_LOAD) {
                return p;
            }
            ++n2;
        }
        return null;
    }

    public int getNumPrograms() {
        return this.phEntries.length;
    }

    public void close() {
        this.phEntries = null;
    }

    public int getEntryPoint() {
        return (int)this.e_entry;
    }

    public void unpack() throws FileNotFoundException, IOException {
        RandomAccessFile fin = new RandomAccessFile(this.theFile, "r");
        int i = 0;
        while (i < this.getNumPrograms()) {
            fin.seek(this.phEntries[i].getOffset());
            byte[] image = new byte[(int)this.phEntries[i].getProgramSize()];
            fin.read(image);
            MyLogger.getLogger().info((Object)("Extracting part " + this.phEntries[i].getName() + " to " + this.phEntries[i].getFileName()));
            File f = new File(this.phEntries[i].getFileName());
            FileOutputStream fout = new FileOutputStream(f);
            fout.write(image);
            image = null;
            fout.flush();
            fout.close();
            ++i;
        }
        fin.close();
        MyLogger.getLogger().info((Object)"ELF Extraction finished");
    }

    public String getFileName() {
        return this.theFile.getAbsolutePath();
    }

    public String getName() {
        return this.theFile.getName();
    }

    private static enum ElfClass {
        invalid(0),
        class32(1),
        class64(2);

        private int value;
        private static Map<Integer, ElfClass> intToElfClass;

        static {
            intToElfClass = new HashMap<Integer, ElfClass>();
            ElfClass[] elfClassArray = ElfClass.values();
            int n = elfClassArray.length;
            int n2 = 0;
            while (n2 < n) {
                ElfClass c = elfClassArray[n2];
                intToElfClass.put(c.getValue(), c);
                ++n2;
            }
        }

        private ElfClass(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ElfClass valueToClass(int value) {
            return intToElfClass.get(value);
        }
    }

    private static enum ElfType {
        ET_NONE(0),
        ET_REL(1),
        ET_EXEC(2),
        ET_DYN(3),
        ET_CORE(4);

        private int value;
        private static Map<Integer, ElfType> intToElfType;

        static {
            intToElfType = new HashMap<Integer, ElfType>();
            ElfType[] elfTypeArray = ElfType.values();
            int n = elfTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ElfType c = elfTypeArray[n2];
                intToElfType.put(c.getValue(), c);
                ++n2;
            }
        }

        private ElfType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ElfType valueToType(int value) {
            return intToElfType.get(value);
        }
    }
}

