/*
 * Decompiled with CFR 0.152.
 */
package org.system;

import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.adb.AdbUtility;
import org.adb.FastbootUtility;
import org.logger.MyLogger;
import org.system.Device;
import org.system.DeviceEntry;
import org.system.OS;
import org.system.PropertiesFile;

public class Devices {
    private static DeviceEntry _current = null;
    private static Properties props = null;
    private static boolean waitforreboot = false;

    public static boolean HasOneAdbConnected() {
        return AdbUtility.isConnected();
    }

    public static boolean HasOneFastbootConnected() {
        return FastbootUtility.getDevices().hasMoreElements();
    }

    public static Enumeration<Object> listDevices(boolean reload) {
        if (reload || props == null) {
            Devices.load();
        }
        return props.keys();
    }

    public static DeviceEntry getDevice(String device) {
        try {
            if (props.containsKey(device)) {
                return (DeviceEntry)props.get(device);
            }
            File f = new File(String.valueOf(OS.getWorkDir()) + File.separator + "devices" + File.separator + device + ".ftd");
            if (f.exists()) {
                DeviceEntry ent = null;
                JarFile jar = new JarFile(f);
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    JarEntry file = e.nextElement();
                    if (!file.getName().endsWith(String.valueOf(device) + ".properties")) continue;
                    InputStream is = jar.getInputStream(file);
                    PropertiesFile p = new PropertiesFile();
                    p.load(is);
                    ent = new DeviceEntry(p);
                }
                return ent;
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void setCurrent(String device) {
        AdbUtility.init();
        _current = (DeviceEntry)props.get(device);
        _current.queryAll();
    }

    public static DeviceEntry getCurrent() {
        return _current;
    }

    private static void load() {
        if (props == null) {
            props = new Properties();
        } else {
            props.clear();
        }
        File[] list = new File(String.valueOf(OS.getWorkDir()) + OS.getFileSeparator() + "devices").listFiles();
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.length) {
            if (list[i].isDirectory()) {
                PropertiesFile p = new PropertiesFile();
                String device = list[i].getPath().substring(list[i].getPath().lastIndexOf(OS.getFileSeparator()) + 1);
                try {
                    p.open("", new File(String.valueOf(list[i].getPath()) + OS.getFileSeparator() + device + ".properties").getAbsolutePath());
                    DeviceEntry entry = new DeviceEntry(p);
                    if (device.equals(entry.getId())) {
                        props.put(device, entry);
                    } else {
                        MyLogger.getLogger().error((Object)(String.valueOf(device) + " : this bundle is not valid"));
                    }
                }
                catch (Exception fne) {
                    MyLogger.getLogger().error((Object)(String.valueOf(device) + " : this bundle is not valid"));
                }
            }
            ++i;
        }
    }

    public static void waitForReboot(boolean tobeforced) {
        if (!tobeforced) {
            MyLogger.getLogger().info((Object)"Waiting for device");
        } else {
            MyLogger.getLogger().info((Object)"Waiting for device. After 60secs, stop waiting will be forced");
        }
        waitforreboot = true;
        int count = 0;
        while (waitforreboot) {
            Devices.sleep(20);
            if (!tobeforced) continue;
            if (Device.getLastConnected(false).getStatus().equals("adb") && ++count == 3000) {
                MyLogger.getLogger().info((Object)"Forced stop waiting.");
                waitforreboot = false;
                continue;
            }
            if (count != 3000) continue;
            count = 0;
        }
    }

    private static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void stopWaitForReboot() {
        waitforreboot = false;
    }

    public static void setWaitForReboot() {
        waitforreboot = true;
    }

    public static boolean isWaitingForReboot() {
        return waitforreboot;
    }
}

