/*
 * Decompiled with CFR 0.152.
 */
package org.system;

import java.util.Enumeration;
import java.util.Properties;
import org.system.GlobalState;

public class DeviceIdent {
    private String pid = "";
    private String vid = "";
    private String devicepath = "";
    private Properties devid;
    private int maxsize = 0;
    private String serial = "";

    public DeviceIdent() {
        this.pid = "";
        this.vid = "";
        this.devicepath = "";
        this.devid = new Properties();
    }

    public DeviceIdent(DeviceIdent id) {
        this.devid = new Properties();
        Enumeration<Object> e = id.getIds().keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.addDevId(key);
            this.devid.setProperty(key, id.getIds().getProperty(key));
        }
        this.addDevPath(id.getDevPath());
    }

    public void addDevPath(String path) {
        if (path.length() > 0) {
            this.devicepath = path;
        }
    }

    public String getDevPath() {
        return this.devicepath;
    }

    public void addDevId(String device) {
        if (device.length() > this.maxsize) {
            this.maxsize = device.length();
        }
        this.vid = device.substring(device.indexOf("VID_") + 4, device.indexOf("PID_") - 1);
        int begin = device.indexOf("PID_") + 4;
        this.pid = device.substring(begin, begin + 4);
        if (!device.contains("MI")) {
            this.serial = device.substring(begin + 5, device.length());
        }
        this.devid.setProperty(device, Boolean.toString(true));
    }

    public void addDevId(String vendor, String product, String ser) {
        this.vid = vendor;
        this.pid = product;
        this.serial = ser;
        this.devid.setProperty("VID_" + vendor + "&" + "PID_" + product + "\\", "true");
    }

    public void setDriverOk(String device, boolean status) {
        this.devid.setProperty(device, Boolean.toString(status));
    }

    public String getPid() {
        return this.pid;
    }

    public String getVid() {
        return this.vid;
    }

    public String getSerial() {
        return this.serial;
    }

    public boolean isDriverOk() {
        Enumeration<Object> e = this.devid.elements();
        while (e.hasMoreElements()) {
            String value = (String)e.nextElement();
            boolean b2 = Boolean.parseBoolean(value);
            if (b2) continue;
            return false;
        }
        return true;
    }

    public String getDeviceId() {
        Enumeration<Object> e = this.devid.keys();
        while (e.hasMoreElements()) {
            String value = (String)e.nextElement();
            if (value.contains("MI")) continue;
            return value;
        }
        return "none";
    }

    public String getStatus() {
        if (this.getPid().length() == 0) {
            return "none";
        }
        if (!this.isDriverOk()) {
            return "notinstalled";
        }
        return GlobalState.getState(this.getSerial(), this.getPid());
    }

    public Properties getIds() {
        return this.devid;
    }

    public int getMaxSize() {
        return this.maxsize;
    }
}

