/*
 * Decompiled with CFR 0.152.
 */
package org.system;

import gui.BusyBoxSelectGUI;
import gui.RecoveryBootSelectGUI;
import java.util.HashSet;
import org.adb.AdbUtility;
import org.logger.MyLogger;
import org.system.DeviceProperties;
import org.system.Devices;
import org.system.GlobalConfig;
import org.system.OS;
import org.system.ProcessBuilderWrapper;
import org.system.PropertiesFile;
import org.system.Shell;

public class DeviceEntry {
    PropertiesFile _entry;
    private static String fsep = OS.getFileSeparator();
    private Boolean hasBusybox = null;
    private boolean isRecoveryMode = false;

    public void queryAll() {
        this.setVersion();
        this.setKernelVersion();
        try {
            this.isRecoveryMode = !AdbUtility.isMounted("/system");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean hasRoot() {
        if (AdbUtility.hasRootNative(false)) {
            return AdbUtility.hasRootNative(false);
        }
        return AdbUtility.hasRootPerms();
    }

    public boolean isRecovery() {
        return this.isRecoveryMode;
    }

    public boolean hasSU() {
        try {
            return AdbUtility.hasSU();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void rebootSelectedRecovery() throws Exception {
        RecoveryBootSelectGUI rsel = new RecoveryBootSelectGUI();
        rsel.setTitle("Recovery selector");
        String current = rsel.getVersion();
        if (current.length() > 0) {
            MyLogger.getLogger().info((Object)"Rebooting into recovery mode");
            Shell shell = new Shell("rebootrecoveryt");
            shell.setProperty("RECOV_VERSION", current);
            shell.runRoot();
            MyLogger.getLogger().info((Object)"Phone will reboot into recovery mode");
        } else {
            MyLogger.getLogger().info((Object)"Canceled");
        }
    }

    public void setDefaultRecovery() throws Exception {
        RecoveryBootSelectGUI rsel = new RecoveryBootSelectGUI();
        String current = rsel.getVersion();
        if (current.length() > 0) {
            if (AdbUtility.Sysremountrw()) {
                MyLogger.getLogger().info((Object)"Setting default recovery");
                Shell shell = new Shell("setdefaultrecovery");
                shell.setProperty("RECOV_VERSION", current);
                shell.runRoot();
                MyLogger.getLogger().info((Object)"Done");
            }
        } else {
            MyLogger.getLogger().info((Object)"Canceled");
        }
    }

    private void setKernelVersion() {
        this._entry.setProperty("kernel.version", AdbUtility.getKernelVersion(this.isBusyboxInstalled(false)));
    }

    public String getKernelVersion() {
        return this._entry.getProperty("kernel.version");
    }

    public DeviceEntry(PropertiesFile entry) {
        this._entry = entry;
    }

    public String getId() {
        return this._entry.getProperty("internalname");
    }

    public String getName() {
        return this._entry.getProperty("realname");
    }

    public String getWorkDir() {
        return String.valueOf(OS.getWorkDir()) + fsep + "devices" + fsep + this.getId() + fsep + "work";
    }

    public String getDeviceDir() {
        return String.valueOf(OS.getWorkDir()) + fsep + "devices" + fsep + this.getId();
    }

    public String getBuildProp() {
        return this._entry.getProperty("buildprop");
    }

    public String getLoaderMD5() {
        return this._entry.getProperty("loader").toUpperCase();
    }

    public String getLoaderUnlockedMD5() {
        return this._entry.getProperty("loader_unlocked").toUpperCase();
    }

    public boolean hasUnlockedLoader() {
        return this._entry.getProperties().containsKey("loader_unlocked");
    }

    public String getBusyBoxInstallPath() {
        return this._entry.getProperty("busyboxinstallpath");
    }

    public String getInstalledBusyboxVersion(boolean force) {
        if (Devices.getCurrent().isBusyboxInstalled(force)) {
            return AdbUtility.getBusyboxVersion(this.getBusyBoxInstallPath());
        }
        this.hasBusybox = false;
        return "N/A";
    }

    public HashSet<String> getRecognitionList() {
        String[] result = this._entry.getProperty("recognition").split(",");
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < result.length) {
            set.add(result[i]);
            ++i;
        }
        return set;
    }

    public String getRecognition() {
        return this._entry.getProperty("recognition");
    }

    public void addRecognitionToList(String recog) {
        String current = this._entry.getProperty("recognition");
        current = String.valueOf(current) + "," + recog;
        this._entry.setProperty("recognition", current);
        this._entry.write("ISO-8859-1");
    }

    public String getLoader() {
        return "./devices/" + this._entry.getProperty("internalname") + "/loader.sin";
    }

    public String getLoaderUnlocked() {
        return "./devices/" + this._entry.getProperty("internalname") + "/loader_unlocked.sin";
    }

    private void setVersion() {
        this._entry.setProperty("android.release", DeviceProperties.getProperty("ro.build.version.release"));
        this._entry.setProperty("android.build", DeviceProperties.getProperty("ro.build.id"));
    }

    public String getVersion() {
        return this._entry.getProperty("android.release");
    }

    public String getBuildId() {
        return this._entry.getProperty("android.build");
    }

    public boolean canFlash() {
        return this._entry.getProperty("canflash").equals("true");
    }

    public boolean canKernel() {
        return this._entry.getProperty("cankernel").equals("true");
    }

    public boolean canRecovery() {
        return this._entry.getProperty("canrecovery").equals("true");
    }

    public boolean canFastboot() {
        return this._entry.getProperty("canfastboot").equals("true");
    }

    public String getBusybox(boolean select) {
        String version;
        if (!select) {
            version = this._entry.getProperty("busyboxhelper");
        } else {
            BusyBoxSelectGUI sel = new BusyBoxSelectGUI(this.getId());
            version = sel.getVersion();
        }
        if (version.length() == 0) {
            return "";
        }
        return "." + fsep + "devices" + fsep + this._entry.getProperty("internalname") + fsep + "busybox" + fsep + version + fsep + "busybox";
    }

    public String getOptimize() {
        return "./devices/" + this._entry.getProperty("internalname") + "/optimize.tar";
    }

    public String getBuildMerge() {
        return "./devices/" + this._entry.getProperty("internalname") + "/build.prop";
    }

    public String getCharger() {
        return "./devices/" + this._entry.getProperty("internalname") + "/charger";
    }

    public boolean isBusyboxInstalled(boolean force) {
        if (this.hasBusybox == null || force) {
            this.hasBusybox = AdbUtility.getBusyboxVersion(this.getBusyBoxInstallPath()).length() > 0;
        }
        return this.hasBusybox;
    }

    public void doBusyboxHelper() throws Exception {
        if (!this.isBusyboxInstalled(false)) {
            AdbUtility.push(this.getBusybox(false), String.valueOf(GlobalConfig.getProperty("deviceworkdir")) + "/busybox");
            Shell shell = new Shell("busyhelper");
            shell.run(true);
        }
    }

    public void reboot() throws Exception {
        if (this.hasRoot()) {
            Shell s = new Shell("reboot");
            s.runRoot(false);
        } else {
            ProcessBuilderWrapper processBuilderWrapper = new ProcessBuilderWrapper(new String[]{OS.getAdbPath(), "reboot"}, false);
        }
    }
}

