/*
 * Decompiled with CFR 0.152.
 */
package org.system;

import com.sun.jna.platform.win32.SetupApi;
import com.sun.jna.platform.win32.WinBase;
import java.util.Enumeration;
import linuxlib.JUsb;
import org.adb.AdbUtility;
import org.adb.FastbootUtility;
import org.logger.MyLogger;
import org.system.DeviceIdent;
import org.system.OS;
import win32lib.JsetupAPi;
import win32lib.SetupApi;

public class Device {
    static DeviceIdent lastid = new DeviceIdent();
    static String laststatus = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeviceIdent getLastConnected(boolean force) {
        if (force) {
            return Device.getConnectedDevice();
        }
        DeviceIdent id = null;
        DeviceIdent deviceIdent = lastid;
        synchronized (deviceIdent) {
            id = new DeviceIdent(lastid);
        }
        return id;
    }

    public static synchronized DeviceIdent getConnectedDevice() {
        DeviceIdent id = OS.getName().equals("windows") ? Device.getConnectedDeviceWin32() : Device.getConnectedDeviceLinux();
        int count = 0;
        while (!id.isDriverOk()) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            id = OS.getName().equals("windows") ? Device.getConnectedDeviceWin32() : Device.getConnectedDeviceLinux();
            if (++count == 5) break;
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeviceIdent getConnectedDeviceWin32() {
        String devid;
        SetupApi.SP_DEVINFO_DATA DeviceInfoData;
        int index;
        DeviceIdent id = new DeviceIdent();
        SetupApi.HDEVINFO hDevInfo = JsetupAPi.getHandleForConnectedInterfaces();
        if (hDevInfo.equals(WinBase.INVALID_HANDLE_VALUE)) {
            MyLogger.getLogger().error((Object)"Cannot have device list");
        } else {
            index = 0;
            do {
                if ((devid = JsetupAPi.getDevId(hDevInfo, DeviceInfoData = JsetupAPi.enumDevInfo(hDevInfo, index))).contains("VID_0FCE")) {
                    id.addDevPath(JsetupAPi.getDevicePath(hDevInfo, DeviceInfoData));
                    id.addDevId(devid);
                    if (!JsetupAPi.isInstalled(hDevInfo, DeviceInfoData)) {
                        id.setDriverOk(devid, false);
                    } else {
                        id.setDriverOk(devid, true);
                    }
                }
                ++index;
            } while (DeviceInfoData != null);
            JsetupAPi.destroyHandle(hDevInfo);
        }
        hDevInfo = JsetupAPi.getHandleForConnectedDevices();
        if (hDevInfo.equals(WinBase.INVALID_HANDLE_VALUE)) {
            MyLogger.getLogger().error((Object)"Cannot have device list");
        } else {
            index = 0;
            do {
                if ((devid = JsetupAPi.getDevId(hDevInfo, DeviceInfoData = JsetupAPi.enumDevInfo(hDevInfo, index))).contains("VID_0FCE")) {
                    id.addDevId(devid);
                    if (!JsetupAPi.isInstalled(hDevInfo, DeviceInfoData)) {
                        id.setDriverOk(devid, false);
                    } else {
                        id.setDriverOk(devid, true);
                    }
                }
                ++index;
            } while (DeviceInfoData != null);
            JsetupAPi.destroyHandle(hDevInfo);
        }
        DeviceIdent deviceIdent = lastid;
        synchronized (deviceIdent) {
            lastid = id;
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeviceIdent getConnectedDeviceLinux() {
        DeviceIdent id = new DeviceIdent();
        try {
            JUsb.fillDevice(true);
            if (JUsb.getVendorId().equals("0FCE")) {
                id.addDevId(JUsb.getVendorId(), JUsb.getProductId(), JUsb.getSerial());
            }
            DeviceIdent deviceIdent = lastid;
            synchronized (deviceIdent) {
                lastid = id;
            }
        }
        catch (UnsatisfiedLinkError e) {
            MyLogger.getLogger().error((Object)"libusb-1.0 is not installed");
            MyLogger.getLogger().error((Object)e.getMessage());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return id;
    }

    public static void CheckAdbDrivers() {
        MyLogger.getLogger().info((Object)"List of connected devices (Device Id) :");
        DeviceIdent id = Device.getLastConnected(false);
        int maxsize = id.getMaxSize();
        Enumeration<Object> e = id.getIds().keys();
        while (e.hasMoreElements()) {
            String dev = (String)e.nextElement();
            String driver = id.getIds().getProperty(dev);
            MyLogger.getLogger().info((Object)("      - " + String.format("%1$-" + maxsize + "s", dev) + "\tDriver installed : " + driver));
        }
        MyLogger.getLogger().info((Object)"List of ADB devices :");
        Enumeration<String> e1 = AdbUtility.getDevices();
        if (e1.hasMoreElements()) {
            while (e1.hasMoreElements()) {
                MyLogger.getLogger().info((Object)("      - " + e1.nextElement()));
            }
        } else {
            MyLogger.getLogger().info((Object)"      - none");
        }
        MyLogger.getLogger().info((Object)"List of fastboot devices :");
        Enumeration<String> e2 = FastbootUtility.getDevices();
        if (e1.hasMoreElements()) {
            while (e2.hasMoreElements()) {
                MyLogger.getLogger().info((Object)("      - " + e2.nextElement()));
            }
        } else {
            MyLogger.getLogger().info((Object)"      - none");
        }
    }

    public static void clean() {
        if (!OS.getName().equals("windows")) {
            try {
                JUsb.cleanup();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

