/*
 * Decompiled with CFR 0.152.
 */
package org.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;

public class CommentedPropertiesFile
extends Properties {
    private static final long serialVersionUID = 1L;
    private LinkedList<String> lines = new LinkedList();
    private Properties commented = new Properties();

    public void load(File f) throws IOException {
        FileInputStream fin = new FileInputStream(f);
        this.load(fin);
        fin.close();
        FileReader fread = new FileReader(f);
        Scanner sc = new Scanner(fread);
        while (sc.hasNextLine()) {
            String line = sc.nextLine();
            if (line.trim().startsWith("#") || line.trim().length() == 0) {
                if (!line.trim().startsWith("##") && line.trim().contains("=")) {
                    this.setCommentedProperty(line.trim().split("=")[0].substring(1).trim(), line.trim().split("=")[1].trim());
                    continue;
                }
                this.lines.add(line);
                continue;
            }
            this.lines.add(line.trim().split("=")[0].trim());
        }
        fread.close();
    }

    @Override
    public void store(OutputStream out, String header) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, "ISO-8859-1"));
        for (String line : this.lines) {
            if (this.containsKey(line)) {
                writer.println(String.valueOf(line) + "=" + this.getProperty(line));
                continue;
            }
            if (this.commented.containsKey(line)) {
                writer.println("#" + line.substring(2) + "=" + this.commented.getProperty(line));
                continue;
            }
            writer.println(line);
        }
        writer.flush();
        writer.close();
        out.flush();
        out.close();
    }

    public void updateWith(File f) throws IOException {
        CommentedPropertiesFile p = new CommentedPropertiesFile();
        p.load(f);
        for (String string : p.keySet()) {
            this.unComment(string);
            this.setProperty(string, p.getProperty(string));
        }
        Iterator iterator = p.commentedKeySet().iterator();
        while (iterator.hasNext()) {
            String key = ((String)iterator.next()).substring(2);
            this.comment(key);
            this.setCommentedProperty(key, p.getCommentedProperty(key));
        }
    }

    public String getCommentedProperty(String key) {
        return this.commented.getProperty("_c" + key);
    }

    public Set commentedKeySet() {
        return this.commented.keySet();
    }

    public void updateProperty(String key, String value) {
        if (this.isCommented(key) && !this.isNotCommented(key)) {
            this.unComment(key);
        }
        this.setProperty(key, value);
    }

    public void updateCommentedProperty(String key, String value) {
        if (this.isNotCommented(key) && !this.isCommented(key)) {
            this.comment(key);
        }
        this.setCommentedProperty(key, value);
    }

    public void setCommentedProperty(String key, String value) {
        this.commented.setProperty("_c" + key, value);
        if (this.lines.indexOf("_c" + key) < 0) {
            this.lines.add("_c" + key);
        }
    }

    @Override
    public Object setProperty(String key, String value) {
        if (this.lines.indexOf(key) < 0) {
            this.lines.add(key);
        }
        return super.setProperty(key, value);
    }

    public boolean isCommented(String key) {
        return this.commented.containsKey("_c" + key);
    }

    public boolean isNotCommented(String key) {
        return this.containsKey(key);
    }

    public void removeCommented(String key) {
        this.commented.remove("_c" + key);
    }

    public void remove(String key) {
        super.remove(key);
    }

    public void unComment(String key) {
        if (this.getCommentedProperty(key) != null) {
            this.setProperty(key, this.getCommentedProperty(key));
            this.removeCommented(key);
            int index = this.lines.indexOf("_c" + key);
            this.lines.set(index, key);
        }
    }

    public void comment(String key) {
        if (this.getProperty(key) != null) {
            this.commented.setProperty("_c" + key, this.getProperty(key));
            this.remove(key);
            int index = this.lines.indexOf(key);
            this.lines.set(index, "_c" + key);
        }
    }

    public void addComment(String line) {
        this.lines.add(line);
    }
}

