/*
 * Decompiled with CFR 0.152.
 */
package org.system;

import java.io.InputStream;
import java.util.Scanner;
import javax.swing.event.EventListenerList;
import org.adb.AdbUtility;
import org.logger.MyLogger;
import org.system.Device;
import org.system.DeviceChangedListener;
import org.system.DeviceIdent;
import org.system.DeviceProperties;
import org.system.GlobalState;
import org.system.OS;
import org.system.StatusEvent;
import org.system.StatusListener;

public class AdbPhoneThread
extends Thread {
    String currentPid = "none";
    boolean done = false;
    private ProcessBuilder builder;
    private Process adb;
    private InputStream processInput;
    private Scanner sc;
    private final EventListenerList listeners = new EventListenerList();
    private StatusListener listener;
    boolean first = true;

    public void done() {
        this.done = true;
    }

    @Override
    public void run() {
        try {
            this.builder = new ProcessBuilder(OS.getAdbPath(), "status-window");
            this.adb = this.builder.start();
            Thread t = new Thread(){

                @Override
                public void run() {
                    AdbPhoneThread.this.processInput = AdbPhoneThread.this.adb.getInputStream();
                    boolean adbok = false;
                    AdbPhoneThread.this.sc = new Scanner(AdbPhoneThread.this.processInput);
                    DeviceIdent id = null;
                    DeviceIdent newid = null;
                    while (AdbPhoneThread.this.sc.hasNextLine()) {
                        adbok = true;
                        String line = AdbPhoneThread.this.sc.nextLine();
                        if (!line.contains("State")) continue;
                        if (line.contains("device")) {
                            DeviceProperties.reload();
                            id = Device.getLastConnected(AdbPhoneThread.this.first);
                            newid = Device.getLastConnected(AdbPhoneThread.this.first);
                            if (!GlobalState.getState(newid.getSerial(), newid.getPid()).equals("adb")) {
                                int count = 0;
                                if (AdbPhoneThread.this.first) {
                                    count = 19;
                                }
                                while (newid.getPid().equals(id.getPid())) {
                                    AdbPhoneThread.this.Sleep(100);
                                    newid = Device.getLastConnected(AdbPhoneThread.this.first);
                                    if (++count == 20) break;
                                }
                                GlobalState.setState(newid.getSerial(), newid.getPid(), "adb");
                            }
                            AdbPhoneThread.this.fireStatusChanged(new StatusEvent(GlobalState.getState(newid.getSerial(), newid.getPid()), true));
                        }
                        if (!AdbPhoneThread.this.first) continue;
                        DeviceChangedListener.start();
                        DeviceChangedListener.addStatusListener(AdbPhoneThread.this.listener);
                        AdbPhoneThread.this.first = false;
                    }
                    if (!adbok) {
                        Scanner scerr = new Scanner(AdbPhoneThread.this.adb.getErrorStream());
                        while (scerr.hasNextLine()) {
                            MyLogger.getLogger().error((Object)scerr.nextLine());
                        }
                    }
                }
            };
            t.start();
            while (!this.done) {
                int count = 1;
                while (count < 2001 && !this.done) {
                    AdbPhoneThread.sleep(1L);
                    ++count;
                }
            }
            this.adb.destroy();
            try {
                AdbUtility.killServer();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            MyLogger.getLogger().error((Object)e.getMessage());
        }
    }

    private void Sleep(int ms) {
        try {
            AdbPhoneThread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addStatusListener(StatusListener plistener) {
        this.listeners.add(StatusListener.class, plistener);
        this.listener = plistener;
    }

    public void removeStatusListener(StatusListener listener) {
        this.listeners.remove(StatusListener.class, listener);
    }

    public StatusListener[] getStatusListeners() {
        return (StatusListener[])this.listeners.getListeners(StatusListener.class);
    }

    protected void fireStatusChanged(StatusEvent e) {
        StatusListener[] statusListenerArray = this.getStatusListeners();
        int n = statusListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            StatusListener listener = statusListenerArray[n2];
            listener.statusChanged(e);
            ++n2;
        }
    }

    public void doSleep(int time) {
        try {
            AdbPhoneThread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

