/*
 * Decompiled with CFR 0.152.
 */
package org.plugins;

import java.io.File;
import org.adb.AdbUtility;
import org.logger.MyLogger;
import org.system.GlobalConfig;
import org.system.OS;

public class PluginFiles {
    String _filedir;

    public PluginFiles(String filedir) {
        this._filedir = filedir;
    }

    public boolean push(String file) {
        try {
            AdbUtility.push(String.valueOf(this._filedir) + OS.getFileSeparator() + file, GlobalConfig.getProperty("deviceworkdir"));
            return true;
        }
        catch (Exception e) {
            MyLogger.getLogger().error((Object)("Error sending " + file + " to device"));
            return false;
        }
    }

    public boolean push(String folder, String file) {
        try {
            AdbUtility.push(String.valueOf(this._filedir) + OS.getFileSeparator() + folder + OS.getFileSeparator() + file, GlobalConfig.getProperty("deviceworkdir"));
            return true;
        }
        catch (Exception e) {
            MyLogger.getLogger().error((Object)("Error sending " + folder + OS.getFileSeparator() + file + " to device"));
            return false;
        }
    }

    public boolean pull(String file) {
        try {
            AdbUtility.pull(file, String.valueOf(this._filedir) + OS.getFileSeparator() + ".");
            return true;
        }
        catch (Exception e) {
            MyLogger.getLogger().error((Object)("Error sending " + file + " to device"));
            return false;
        }
    }

    public boolean pullWithRename(String file, String newname) {
        try {
            AdbUtility.pull(file, String.valueOf(this._filedir) + OS.getFileSeparator() + newname);
            return true;
        }
        catch (Exception e) {
            MyLogger.getLogger().error((Object)("Error sending " + file + " to device"));
            return false;
        }
    }

    public String getFileDir() {
        return this._filedir;
    }

    public String getFile(String file) {
        return String.valueOf(this._filedir) + OS.getFileSeparator() + file;
    }

    public String getFile(String folder, String file) {
        return String.valueOf(this._filedir) + OS.getFileSeparator() + folder + OS.getFileSeparator() + file;
    }

    public void delete(String file) {
        File f = new File(String.valueOf(this._filedir) + OS.getFileSeparator() + file);
        f.delete();
    }
}

