/*
 * Decompiled with CFR 0.152.
 */
package org.plugins;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenu;
import org.plugins.FeatureShellFactory;
import org.plugins.PluginFiles;
import org.system.OS;
import org.system.PropertiesFile;

public class PluginDefaults {
    protected static String fsep = OS.getFileSeparator();
    protected String _workdir;
    protected PropertiesFile featureProperties;
    protected FeatureShellFactory sfactory;
    protected PluginFiles files;
    protected JMenu menu;

    public void setWorkdir(String workdir) {
        this._workdir = workdir;
        this.sfactory = new FeatureShellFactory(String.valueOf(workdir) + fsep + "shells");
        this.files = new PluginFiles(String.valueOf(workdir) + fsep + "files");
    }

    public Enumeration<String> getCompatibleAndroidVersions() {
        Vector<String> v = new Vector<String>();
        String[] list = this.getProperty("androidversions").split(",");
        int i = 0;
        while (i < list.length) {
            v.add(list[i]);
            ++i;
        }
        return v.elements();
    }

    public Enumeration<String> getCompatibleKernelVersions() {
        Vector<String> v = new Vector<String>();
        String[] list = this.getProperty("kernelversions").split(",");
        int i = 0;
        while (i < list.length) {
            v.add(list[i]);
            ++i;
        }
        return v.elements();
    }

    public Enumeration<String> getCompatibleDevices() {
        Vector<String> v = new Vector<String>();
        String[] list = this.getProperty("compatibledevices").split(",");
        int i = 0;
        while (i < list.length) {
            v.add(list[i]);
            ++i;
        }
        return v.elements();
    }

    public boolean isRootNeeded() {
        return this.getProperty("needroot").equals("true");
    }

    public String getProperty(String property) {
        if (this.featureProperties == null) {
            this.featureProperties = new PropertiesFile("", String.valueOf(this._workdir) + fsep + "feature.properties");
        }
        return this.featureProperties.getProperty(property);
    }

    public void setMenu(JMenu pmenu) {
        this.menu = pmenu;
    }
}

