/*
 * Decompiled with CFR 0.152.
 */
package org.logger;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.log4j.Level;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.logger.MyLogger;
import org.system.OS;

public class TextAreaAppender
extends WriterAppender {
    private static JTextPane jTextArea = null;
    private static StringBuilder builder = new StringBuilder();
    static Font font = new Font("Serif", 0, 12);
    public static String timestamp = TextAreaAppender.getTimeStamp();

    public static String getTimeStamp() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        df.setTimeZone(TimeZone.getTimeZone("PST"));
        String date = df.format(new Date());
        SimpleDateFormat df1 = new SimpleDateFormat("hh-mm-ss");
        df1.setTimeZone(TimeZone.getDefault());
        String time = df1.format(new Date());
        return String.valueOf(date) + "_" + time;
    }

    public static void writeFile() {
        block12: {
            String logname = String.valueOf(OS.getWorkDir()) + OS.getFileSeparator() + "flashtool_" + timestamp + ".log";
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(new File(logname));
                    writer.write(builder.toString());
                }
                catch (IOException iOException) {
                    if (writer == null) break block12;
                    try {
                        MyLogger.getLogger().info((Object)("Log written to " + logname));
                        writer.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (writer != null) {
                    try {
                        MyLogger.getLogger().info((Object)("Log written to " + logname));
                        writer.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static void setTextArea(JTextPane jTextArea) {
        TextAreaAppender.jTextArea = jTextArea;
        TextAreaAppender.jTextArea.setEditorKit(new HTMLEditorKit());
        TextAreaAppender.jTextArea.setEditable(false);
    }

    public void append(LoggingEvent loggingEvent) {
        final String message = this.layout.format(loggingEvent);
        final Level level = loggingEvent.getLevel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                builder.append(message);
                if (level == Level.ERROR) {
                    TextAreaAppender.append(Color.red, message);
                } else if (level == Level.WARN) {
                    TextAreaAppender.append(Color.blue, message);
                } else {
                    TextAreaAppender.append(Color.black, message);
                }
            }
        });
    }

    public static void append(Color c, String message) {
        MutableAttributeSet attrs = jTextArea.getInputAttributes();
        StyleConstants.setFontFamily(attrs, font.getFamily());
        StyleConstants.setFontSize(attrs, font.getSize());
        StyleConstants.setItalic(attrs, (font.getStyle() & 2) != 0);
        StyleConstants.setBold(attrs, (font.getStyle() & 1) != 0);
        StyleConstants.setForeground(attrs, c);
        StyledDocument doc = jTextArea.getStyledDocument();
        try {
            doc.insertString(doc.getLength(), message, attrs);
            jTextArea.scrollRectToVisible(jTextArea.modelToView(doc.getLength()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getString() {
        return builder.toString();
    }
}

