/*
 * Decompiled with CFR 0.152.
 */
package org.logger;

import gui.FlasherGUI;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.logger.ConsoleAppender;
import org.logger.TextAreaAppender;

public class MyLogger {
    static Logger logger = Logger.getLogger(MyLogger.class);
    static boolean isinit = false;
    static JProgressBar _bar = null;
    static boolean hasTextArea = true;
    static long maxstepsconsole = 0L;
    static long currentstepconsole = 0L;
    static String lastaction = "";

    public static void registerProgressBar(JProgressBar bar) {
        _bar = bar;
    }

    public static void writeFile() {
        if (FlasherGUI.guimode) {
            TextAreaAppender.writeFile();
        } else {
            ConsoleAppender.writeFile();
        }
    }

    public static JProgressBar getProgressBar() {
        return _bar;
    }

    public static void initProgress(long max) {
        if (FlasherGUI.guimode) {
            if (max > 0L) {
                _bar.setStringPainted(true);
            } else {
                _bar.setStringPainted(false);
            }
            _bar.setValue(0);
            _bar.setMaximum((int)max);
        } else {
            maxstepsconsole = max;
            currentstepconsole = 0L;
        }
    }

    public static void initProgress(int max) {
        if (FlasherGUI.guimode) {
            if (max > 0) {
                _bar.setStringPainted(true);
            } else {
                _bar.setStringPainted(false);
            }
            _bar.setValue(0);
            _bar.setMaximum(max);
        } else {
            maxstepsconsole = max;
            currentstepconsole = 0L;
        }
    }

    public static void updateProgress() {
        if (FlasherGUI.guimode) {
            _bar.setValue(_bar.getValue() + 1);
        } else {
            double result = (double)(++currentstepconsole) / (double)maxstepsconsole * 100.0;
            MyLogger.printProgBar((int)result);
        }
        lastaction = "progress";
    }

    public static void setLevel(String level) {
        try {
            isinit = true;
            InputStream in = MyLogger.class.getClassLoader().getResourceAsStream("org/logger/config/" + level.toLowerCase() + ".properties");
            if (in != null) {
                Properties pl = new Properties();
                pl.load(in);
                if (!hasTextArea) {
                    pl.setProperty("log4j.rootLogger", String.valueOf(level) + ", console");
                } else {
                    pl.setProperty("log4j.rootLogger", String.valueOf(level) + ", textarea");
                }
                PropertyConfigurator.configure((Properties)pl);
            } else {
                System.err.println("Error loading log4j properties file");
                System.exit(31);
            }
            if (level.toLowerCase().equals("err")) {
                logger.error((Object)"<- This level is successfully initialized");
            }
            if (level.toLowerCase().equals("warn")) {
                logger.warn((Object)"<- This level is successfully initialized");
            }
            if (level.toLowerCase().equals("debug")) {
                logger.debug((Object)"<- This level is successfully initialized");
            }
            if (level.toLowerCase().equals("info")) {
                logger.info((Object)"<- This level is successfully initialized");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void appendTextArea(JTextPane textArea) {
        TextAreaAppender.setTextArea(textArea);
    }

    public static void disableTextArea() {
        hasTextArea = false;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void printProgBar(long percent) {
        if (percent <= 100L) {
            StringBuilder bar = new StringBuilder("[");
            int i = 0;
            while (i < 50) {
                if ((long)i < percent / 2L) {
                    bar.append("=");
                } else if ((long)i == percent / 2L) {
                    bar.append(">");
                } else {
                    bar.append(" ");
                }
                ++i;
            }
            bar.append("]   " + percent + "%     ");
            System.out.print("\r" + bar.toString());
        }
    }
}

