/*
 * Decompiled with CFR 0.152.
 */
package libusb;

import com.sun.jna.Pointer;
import libusb.UsbDevList;
import libusb.UsbDevice;
import libusb.jna.LibUsbLibrary;
import libusb.jna.libusb_version;

public class UsbSystem {
    Pointer context = null;
    byte endpoint_in;
    byte endpoint_out;

    public UsbSystem() {
        this.initSystem();
    }

    public void initSystem() {
        Pointer[] p = new Pointer[1];
        try {
            int result = LibUsbLibrary.libUsb.libusb_init(p);
            UsbSystem.checkError("init", result);
            this.context = p[0];
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("Libusb not found. Minimum libusb version is 1.0.14");
            System.out.println("It can be downloaded on http://www.libusbx.org");
            System.exit(1);
        }
        try {
            libusb_version v = LibUsbLibrary.libUsb.libusb_get_version();
            if (v.major != 1 || v.minor != 0 || v.micro < 14) {
                System.out.println("Minimum libusb version is 1.0.14. Found " + v.major + "." + v.minor + "." + v.micro);
                System.out.println("It can be downloaded on http://www.libusbx.org");
                System.exit(1);
            }
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("A libusb was found but not with the right version. Minimum libusb version is 1.0.14");
            System.out.println("It can be downloaded on http://www.libusbx.org");
            System.exit(1);
        }
    }

    public UsbDevList getDevices(String vendorid) {
        UsbDevList list = new UsbDevList();
        Pointer[] devs = new Pointer[1];
        int result = LibUsbLibrary.libUsb.libusb_get_device_list(null, devs);
        UsbSystem.checkError("libusb_get_device_list", result);
        Pointer[] devices = devs[0].getPointerArray(0L);
        UsbDevice device = null;
        Pointer[] pointerArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            Pointer usb_device = pointerArray[n2];
            if (usb_device != null && (device = new UsbDevice(usb_device)).getVendor().equals(vendorid)) {
                list.addDevice(device);
            }
            ++n2;
        }
        LibUsbLibrary.libUsb.libusb_free_device_list(devs[0], 1);
        return list;
    }

    public void endSystem() {
        LibUsbLibrary.libUsb.libusb_exit(this.context);
    }

    public static void checkError(String action, int error) {
        switch (error) {
            case -1: {
                System.err.println(String.valueOf(action) + " : I/O Errors");
                break;
            }
            case -2: {
                System.err.println(String.valueOf(action) + " : Invalid parameters");
                break;
            }
            case -3: {
                System.err.println(String.valueOf(action) + " : Access error. No permission on device");
                break;
            }
            case -4: {
                System.err.println(String.valueOf(action) + " : No device");
                break;
            }
            case -5: {
                System.err.println(String.valueOf(action) + " : Device Not found");
                break;
            }
            case -6: {
                System.err.println(String.valueOf(action) + " : Device busy");
                break;
            }
            case -7: {
                System.err.println(String.valueOf(action) + " : Timeout");
                break;
            }
            case -8: {
                System.err.println(String.valueOf(action) + " : Overflow");
                break;
            }
            case -9: {
                System.err.println(String.valueOf(action) + " : Pipe error");
                break;
            }
            case -10: {
                System.err.println(String.valueOf(action) + " : Interrupted by user");
                break;
            }
            case -11: {
                System.err.println(String.valueOf(action) + " : No memory");
                break;
            }
            case -12: {
                System.err.println(String.valueOf(action) + " : Not supported");
                break;
            }
            case -99: {
                System.err.println(String.valueOf(action) + " : Other");
            }
        }
    }
}

