/*
 * Decompiled with CFR 0.152.
 */
package libusb;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.util.Vector;
import libusb.UsbConfiguration;
import libusb.UsbEndpointDescriptor;
import libusb.UsbInterface;
import libusb.UsbInterfaceDescriptor;
import libusb.UsbSystem;
import libusb.jna.LibUsbLibrary;
import libusb.jna.libusb_config_descriptor;
import libusb.jna.libusb_device_descriptor;

public class UsbDevice {
    private Pointer usb_device = null;
    private Pointer handle = null;
    private String vendorid = "";
    private String productid = "";
    private byte iSerialNumber;
    private byte iManufacturer;
    private Vector<UsbConfiguration> confs = new Vector();
    private int iface_detached = -1;
    private int iface_claimed = -1;
    private int refcount = 1;
    private byte default_endpoint_in = 0;
    private byte default_endpoint_out = 0;
    private int nbconfig = 0;

    public UsbDevice(Pointer device) {
        this.usb_device = device;
        libusb_device_descriptor[] arr = new libusb_device_descriptor[1];
        int result = LibUsbLibrary.libUsb.libusb_get_device_descriptor(this.usb_device, arr);
        UsbSystem.checkError("get_device_descriptor", result);
        this.vendorid = String.format("%4s", Integer.toHexString(arr[0].idVendor & 0xFFFF)).replace(' ', '0');
        this.productid = String.format("%4s", Integer.toHexString(arr[0].idProduct & 0xFFFF)).replace(' ', '0');
        this.iSerialNumber = arr[0].iSerialNumber;
        this.iManufacturer = arr[0].iManufacturer;
        this.nbconfig = arr[0].bNumConfigurations;
    }

    public String getVendor() {
        return this.vendorid;
    }

    public String getProduct() {
        return this.productid;
    }

    public int getNbConfig() {
        return this.confs.size();
    }

    public void unref() {
        LibUsbLibrary.libUsb.libusb_unref_device(this.usb_device);
        --this.refcount;
    }

    public void ref() {
        LibUsbLibrary.libUsb.libusb_ref_device(this.usb_device);
        ++this.refcount;
    }

    public void close() {
        if (this.handle != null) {
            this.releaseInterface();
            LibUsbLibrary.libUsb.libusb_close(this.handle);
            this.handle = null;
            --this.refcount;
        }
    }

    public void open() throws Exception {
        Pointer[] dev_handle = new Pointer[1];
        int result = LibUsbLibrary.libUsb.libusb_open(this.usb_device, dev_handle);
        int retries = 0;
        int maxretries = 5;
        if (result == -4 || result == -5 || result == -99) {
            throw new Exception("Error while querying the device");
        }
        if (result < 0) {
            while (retries < maxretries) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                result = LibUsbLibrary.libUsb.libusb_open(this.usb_device, dev_handle);
                if (result == -4 || result == -5 || result == -99) {
                    throw new Exception("Error while querying the device");
                }
                if (result == 0) {
                    retries = maxretries;
                }
                ++retries;
            }
        }
        UsbSystem.checkError("Open", result);
        if (result == 0) {
            this.handle = dev_handle[0];
            ++this.refcount;
        } else {
            this.handle = null;
        }
    }

    public void openAndClaim(int iface) throws Exception {
        this.open();
        this.claimInterface(iface);
    }

    public void releaseAndClose() {
        this.releaseInterface();
        this.close();
    }

    public String getSerial() {
        byte[] buffer = new byte[256];
        int result = LibUsbLibrary.libUsb.libusb_get_string_descriptor_ascii(this.handle, this.iSerialNumber, buffer, buffer.length);
        if (result == -2) {
            return "";
        }
        UsbSystem.checkError("libusb_get_string_descriptor_ascii", result);
        return new String(buffer);
    }

    public String getManufacturer() {
        byte[] buffer = new byte[256];
        int result = LibUsbLibrary.libUsb.libusb_get_string_descriptor_ascii(this.handle, this.iManufacturer, buffer, buffer.length);
        UsbSystem.checkError("libusb_get_string_descriptor_ascii", result);
        return new String(buffer);
    }

    public void setConfiguration() {
        libusb_config_descriptor[] cdescs;
        PointerByReference configRef = new PointerByReference();
        int result = LibUsbLibrary.libUsb.libusb_get_config_descriptor(this.usb_device, 0, configRef);
        int retries = 0;
        int maxretries = 5;
        if (result < 0) {
            while (retries < maxretries) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                result = LibUsbLibrary.libUsb.libusb_get_config_descriptor(this.usb_device, 0, configRef);
                if (result == 0) {
                    retries = maxretries;
                }
                ++retries;
            }
        }
        UsbSystem.checkError("get_config", result);
        libusb_config_descriptor cd = new libusb_config_descriptor(configRef.getValue());
        libusb_config_descriptor[] libusb_config_descriptorArray = cdescs = cd.toArray(this.nbconfig);
        int n = cdescs.length;
        int n2 = 0;
        while (n2 < n) {
            libusb_config_descriptor cdesc = libusb_config_descriptorArray[n2];
            this.confs.add(new UsbConfiguration(cdesc));
            ++n2;
        }
        LibUsbLibrary.libUsb.libusb_free_config_descriptor(configRef.getValue());
        for (UsbConfiguration c : this.getConfigurations()) {
            for (UsbInterface iface : c.getInterfaces()) {
                for (UsbInterfaceDescriptor ifdesc : iface.getInterfaceDescriptors()) {
                    for (UsbEndpointDescriptor endpoint : ifdesc.getEndpointDescriptors()) {
                        if (endpoint.isIn()) {
                            this.default_endpoint_in = endpoint.getEndpoint();
                            continue;
                        }
                        this.default_endpoint_out = endpoint.getEndpoint();
                    }
                }
            }
        }
    }

    public Vector<UsbConfiguration> getConfigurations() {
        return this.confs;
    }

    public void claimInterface(int ifacenum) {
        if (this.handle != null) {
            int result = LibUsbLibrary.libUsb.libusb_claim_interface(this.handle, ifacenum);
            UsbSystem.checkError("claim_interface", result);
            if (result != 0) {
                result = LibUsbLibrary.libUsb.libusb_detach_kernel_driver(this.handle, ifacenum);
                UsbSystem.checkError("detach kernel", result);
                this.iface_detached = ifacenum;
                result = LibUsbLibrary.libUsb.libusb_claim_interface(this.handle, ifacenum);
                UsbSystem.checkError("claim_interface", result);
            }
            this.iface_claimed = ifacenum;
        }
    }

    public void releaseInterface() {
        if (this.handle != null && this.iface_claimed >= 0) {
            int result = LibUsbLibrary.libUsb.libusb_release_interface(this.handle, this.iface_claimed);
            UsbSystem.checkError("release_interface", result);
            if (result == 0) {
                this.iface_claimed = -1;
            }
            if (this.iface_detached >= 0) {
                result = LibUsbLibrary.libUsb.libusb_attach_kernel_driver(this.handle, this.iface_detached);
                UsbSystem.checkError("attach kernel", result);
            }
        }
    }

    public byte[] bulkRead() {
        if (this.handle != null) {
            byte[] data = new byte[4096];
            int[] actual_length = new int[1];
            int result = LibUsbLibrary.libUsb.libusb_bulk_transfer(this.handle, this.default_endpoint_in, data, data.length, actual_length, 0);
            int retries = 0;
            if (result < 0) {
                while (retries < 2) {
                    result = LibUsbLibrary.libUsb.libusb_bulk_transfer(this.handle, this.default_endpoint_in, data, data.length, actual_length, 0);
                    if (result == 0) {
                        retries = 3;
                    }
                    ++retries;
                }
            }
            UsbSystem.checkError("libusb_bulk_transfer (read)", result);
            if (result >= 0) {
                return this.getReply(data, actual_length[0]);
            }
            return null;
        }
        return null;
    }

    public void bulkWrite(byte[] data) {
        if (this.handle != null) {
            int[] actual_length = new int[1];
            int result = LibUsbLibrary.libUsb.libusb_bulk_transfer(this.handle, this.default_endpoint_out, data, data.length, actual_length, 0);
            UsbSystem.checkError("libusb_bulk_transfer (write)", result);
            if (data.length != actual_length[0]) {
                System.err.println("Error : did not write all data");
            }
        }
    }

    public byte[] getReply(byte[] reply, int nbread) {
        if (reply.length == nbread) {
            return reply;
        }
        byte[] newreply = null;
        if (nbread > 0) {
            newreply = new byte[nbread];
            System.arraycopy(reply, 0, newreply, 0, nbread);
        }
        return newreply;
    }

    public void destroy() {
        this.close();
        if (this.refcount > 0) {
            while (this.refcount > 0) {
                this.unref();
            }
        }
    }
}

