/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import flashsystem.Bundle;
import gui.ExcludeActionListener;
import gui.FtfFilter;
import gui.WipeActionListener;
import gui.XTableColumnModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarFile;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import org.lang.Language;
import org.logger.MyLogger;
import org.system.OS;

public class firmSelect
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static String fsep = OS.getFileSeparator();
    private final JPanel contentPanel = new JPanel();
    private JTable tableFirm;
    private DefaultTableModel modelFirm;
    private DefaultTableModel model_1;
    private Bundle selected = null;
    private String result;
    private boolean retcode = false;
    JButton okButton;
    private JTable tablesin;
    private JTextField folderSource;
    private String filename = "";
    private Properties hasCmd25 = new Properties();
    private JPanel panelWipe;
    private JPanel panelExclude;
    private JPanel panelMisc;

    private void dirlist() throws Exception {
        boolean hasElements = false;
        this.hasCmd25.clear();
        this.modelFirm = new DefaultTableModel();
        this.modelFirm.addColumn("File");
        this.modelFirm.addColumn("Device");
        this.modelFirm.addColumn("Version");
        this.modelFirm.addColumn("Branding");
        this.tableFirm.setModel(this.modelFirm);
        this.tableFirm.getRowSorter().toggleSortOrder(1);
        this.tableFirm.setColumnModel(new XTableColumnModel());
        this.tableFirm.createDefaultColumnsFromModel();
        ((XTableColumnModel)this.tableFirm.getColumnModel()).setColumnVisible(((XTableColumnModel)this.tableFirm.getColumnModel()).getColumnByModelIndex(0), false);
        File dir = new File(this.folderSource.getText());
        File[] chld = dir.listFiles(new FtfFilter(this.filename));
        int i = 0;
        while (i < chld.length) {
            try {
                hasElements = true;
                JarFile jf = new JarFile(chld[i]);
                this.modelFirm.addRow(new String[]{chld[i].getName(), jf.getManifest().getMainAttributes().getValue("device"), jf.getManifest().getMainAttributes().getValue("version"), jf.getManifest().getMainAttributes().getValue("branding")});
                String cmd25 = jf.getManifest().getMainAttributes().getValue("cmd25");
                if (cmd25 == null) {
                    cmd25 = "false";
                }
                this.hasCmd25.setProperty(chld[i].getName(), cmd25);
                MyLogger.getLogger().debug((Object)("Adding " + chld[i].getName() + " to list of firmwares"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        if (!hasElements) {
            this.okButton.setEnabled(false);
            this.result = null;
        } else {
            this.tableFirm.setRowSelectionInterval(0, 0);
            this.result = (String)this.modelFirm.getValueAt(this.getSelectedRow(this.tableFirm), 0);
            this.okButton.setEnabled(true);
        }
    }

    public void filelist() throws Exception {
        if (this.result != null) {
            this.selected = new Bundle(String.valueOf(this.folderSource.getText()) + fsep + this.result, 1);
            this.selected.setDevice((String)this.modelFirm.getValueAt(this.getSelectedRow(this.tableFirm), 1));
            this.selected.setVersion((String)this.modelFirm.getValueAt(this.getSelectedRow(this.tableFirm), 2));
            this.selected.setBranding((String)this.modelFirm.getValueAt(this.getSelectedRow(this.tableFirm), 3));
            this.selected.setCmd25(this.hasCmd25.getProperty((String)this.modelFirm.getValueAt(this.getSelectedRow(this.tableFirm), 0)));
        }
        this.refreshContent();
    }

    public void refreshContent() {
        this.model_1 = new DefaultTableModel();
        this.model_1.addColumn("File");
        this.tablesin.setModel(this.model_1);
        this.tablesin.getRowSorter().toggleSortOrder(0);
        if (this.result != null) {
            Enumeration<String> e = this.selected.getMeta().getAllEntries(true);
            while (e.hasMoreElements()) {
                String elem = e.nextElement();
                this.model_1.addRow(new String[]{elem});
                MyLogger.getLogger().debug((Object)("Adding " + elem + " to the content of " + this.result));
            }
            if (this.model_1.getRowCount() > 0) {
                this.tablesin.setRowSelectionInterval(0, 0);
            }
        }
    }

    public firmSelect(String path, String file) {
        this.filename = file;
        this.setName("firmSelect");
        this.setTitle("Firmware Selection");
        this.setModal(true);
        this.setBounds(100, 100, 838, 498);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"left:205dlu"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"left:102dlu"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"left:max(117dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"left:15dlu:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"29dlu"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.GLUE_ROWSPEC}));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                firmSelect.this.retcode = false;
                firmSelect.this.dispose();
            }
        });
        this.model_1 = new DefaultTableModel();
        this.model_1.addColumn("File");
        JPanel panelFolder = new JPanel();
        this.contentPanel.add((Component)panelFolder, "2, 2, 7, 1, fill, fill");
        panelFolder.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"min:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.MIN_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblSelectSourceFolder = new JLabel("Select Source Folder :");
        lblSelectSourceFolder.setName("lblSelectSourceFolder");
        panelFolder.add((Component)lblSelectSourceFolder, "2, 1, fill, fill");
        this.folderSource = new JTextField();
        this.folderSource.setEditable(false);
        if (path.length() == 0) {
            this.folderSource.setText(String.valueOf(OS.getWorkDir()) + fsep + "firmwares");
        } else {
            this.folderSource.setText(path);
        }
        panelFolder.add((Component)this.folderSource, "1, 3, 2, 1, fill, fill");
        this.folderSource.setColumns(10);
        JButton btnNewButton = new JButton("...");
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                firmSelect.this.doChoose();
            }
        });
        panelFolder.add((Component)btnNewButton, "4, 3, left, default");
        JLabel lblSelectFirmware = new JLabel("Select Firmware");
        lblSelectFirmware.setName(String.valueOf(this.getName()) + "_" + "lblSelectFirmware");
        this.contentPanel.add((Component)lblSelectFirmware, "2, 4, left, fill");
        JLabel lblFilesInThis = new JLabel("Firmware Content :");
        lblFilesInThis.setName(String.valueOf(this.getName()) + "_" + "lblFilesInThis");
        this.contentPanel.add((Component)lblFilesInThis, "4, 4, left, fill");
        JScrollPane scrollPaneFolderContent = new JScrollPane();
        this.contentPanel.add((Component)scrollPaneFolderContent, "2, 6, 1, 11, left, fill");
        this.tableFirm = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return false;
            }
        };
        this.tableFirm.setSelectionMode(0);
        this.tableFirm.setAutoCreateRowSorter(true);
        scrollPaneFolderContent.setViewportView(this.tableFirm);
        this.tableFirm.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                firmSelect.this.result = (String)firmSelect.this.modelFirm.getValueAt(firmSelect.this.getSelectedRow(firmSelect.this.tableFirm), 0);
                try {
                    firmSelect.this.filelist();
                    firmSelect.this.addCheckBoxesWipe();
                    firmSelect.this.addCheckBoxesExclupde();
                    firmSelect.this.initMiscCheckBoxes();
                    firmSelect.this.addCheckBoxesMisc("No final verification", firmSelect.this.selected.hasCmd25(), new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            firmSelect.this.selected.setCmd25(firmSelect.this.selected.hasCmd25() ? "false" : "true");
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.tableFirm.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                firmSelect.this.result = (String)firmSelect.this.modelFirm.getValueAt(firmSelect.this.getSelectedRow(firmSelect.this.tableFirm), 0);
                try {
                    firmSelect.this.filelist();
                    firmSelect.this.addCheckBoxesWipe();
                    firmSelect.this.addCheckBoxesExclupde();
                    firmSelect.this.initMiscCheckBoxes();
                    firmSelect.this.addCheckBoxesMisc("No final verification", firmSelect.this.selected.hasCmd25(), new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            firmSelect.this.selected.setCmd25(firmSelect.this.selected.hasCmd25() ? "false" : "true");
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        JScrollPane scrollPaneFirmwareContent = new JScrollPane();
        this.contentPanel.add((Component)scrollPaneFirmwareContent, "4, 6, 1, 11, fill, fill");
        this.tablesin = new JTable(this.model_1);
        this.tablesin.setAutoCreateRowSorter(true);
        scrollPaneFirmwareContent.setViewportView(this.tablesin);
        JPanel panel = new JPanel();
        this.contentPanel.add((Component)panel, "6, 6, 3, 11, fill, fill");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"73dlu:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"top:47dlu"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(71dlu;default)"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblNewLabel = new JLabel("Wipe :");
        panel.add((Component)lblNewLabel, "2, 2, left, center");
        JScrollPane scrollPaneWipe = new JScrollPane();
        panel.add((Component)scrollPaneWipe, "2, 4, fill, fill");
        this.panelWipe = new JPanel();
        scrollPaneWipe.setViewportView(this.panelWipe);
        JLabel lblNewLabel_1 = new JLabel("Exclude :");
        panel.add((Component)lblNewLabel_1, "2, 6");
        JScrollPane scrollPaneExclude = new JScrollPane();
        panel.add((Component)scrollPaneExclude, "2, 8, fill, fill");
        this.panelExclude = new JPanel();
        scrollPaneExclude.setViewportView(this.panelExclude);
        JLabel lblNewLabel_2 = new JLabel("Misc :");
        panel.add((Component)lblNewLabel_2, "2, 10");
        JScrollPane scrollPaneMisc = new JScrollPane();
        panel.add((Component)scrollPaneMisc, "2, 12, fill, fill");
        this.panelMisc = new JPanel();
        scrollPaneMisc.setViewportView(this.panelMisc);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                firmSelect.this.retcode = true;
                firmSelect.this.dispose();
            }
        });
        this.okButton.setActionCommand("OK");
        buttonPane.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setName("cancelButton");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                firmSelect.this.retcode = false;
                firmSelect.this.dispose();
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        this.doRefreshTables();
        this.setLanguage();
    }

    public Bundle getBundle() throws IOException {
        this.setVisible(true);
        if (this.retcode) {
            MyLogger.getLogger().debug((Object)("Choosed bundle " + this.result));
            MyLogger.getLogger().info((Object)("Selected " + this.result));
            return this.selected;
        }
        return null;
    }

    public void setLanguage() {
        Language.translate(this);
    }

    public void doChoose() {
        JFileChooser chooser = new JFileChooser();
        if (this.folderSource.getText().length() == 0) {
            chooser.setCurrentDirectory(new File("."));
        } else {
            chooser.setCurrentDirectory(new File(this.folderSource.getText()));
        }
        chooser.setDialogTitle("Choose a folder");
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(this) == 0) {
            this.folderSource.setText(chooser.getSelectedFile().getAbsolutePath());
            this.doRefreshTables();
        }
    }

    public void doRefreshTables() {
        try {
            this.dirlist();
            this.filelist();
            if (this.modelFirm.getRowCount() > 0) {
                this.addCheckBoxesWipe();
                this.addCheckBoxesExclupde();
                this.initMiscCheckBoxes();
                this.addCheckBoxesMisc("No final verification", this.selected.hasCmd25(), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        firmSelect.this.selected.setCmd25(firmSelect.this.selected.hasCmd25() ? "false" : "true");
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCategEnabled(String categ, boolean enabled) {
        this.selected.getMeta().setCategEnabled(categ, enabled);
        this.refreshContent();
    }

    public void addCheckBoxesWipe() {
        this.panelWipe.removeAll();
        FormLayout layout = new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC});
        this.panelWipe.setLayout((LayoutManager)layout);
        Enumeration<String> wipe = this.selected.getMeta().getWipe();
        while (wipe.hasMoreElements()) {
            String categ = wipe.nextElement();
            JCheckBox box = new JCheckBox(this.selected.getMeta().getWipeLabel(categ));
            box.setSelected(true);
            box.addActionListener(new WipeActionListener(this, box, categ));
            layout.appendRow(FormFactory.DEFAULT_ROWSPEC);
            layout.appendRow(FormFactory.RELATED_GAP_ROWSPEC);
            this.panelWipe.add((Component)box, "2, " + Integer.toString(layout.getRowCount() - 1) + ", fill, fill");
        }
        this.panelWipe.repaint();
        this.panelWipe.revalidate();
    }

    public void addCheckBoxesExclupde() {
        this.panelExclude.removeAll();
        FormLayout layout = new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC});
        this.panelExclude.setLayout((LayoutManager)layout);
        Enumeration<String> exclude = this.selected.getMeta().getExclude();
        while (exclude.hasMoreElements()) {
            String categ = exclude.nextElement();
            JCheckBox box = new JCheckBox(this.selected.getMeta().getExcludeLabel(categ));
            box.addActionListener(new ExcludeActionListener(this, box, categ));
            layout.appendRow(FormFactory.DEFAULT_ROWSPEC);
            layout.appendRow(FormFactory.RELATED_GAP_ROWSPEC);
            this.panelExclude.add((Component)box, "2, " + Integer.toString(layout.getRowCount() - 1) + ", fill, fill");
        }
        this.panelExclude.repaint();
        this.panelExclude.revalidate();
    }

    public void initMiscCheckBoxes() {
        this.panelMisc.removeAll();
        FormLayout layout = new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC});
        this.panelMisc.setLayout((LayoutManager)layout);
    }

    public void addCheckBoxesMisc(String label, boolean isSelected, ActionListener al) {
        FormLayout layout = (FormLayout)this.panelMisc.getLayout();
        JCheckBox box = new JCheckBox(label);
        box.setSelected(isSelected);
        box.addActionListener(al);
        layout.appendRow(FormFactory.DEFAULT_ROWSPEC);
        layout.appendRow(FormFactory.RELATED_GAP_ROWSPEC);
        this.panelMisc.add((Component)box, "2, " + Integer.toString(layout.getRowCount() - 1) + ", fill, fill");
        this.panelMisc.repaint();
        this.panelMisc.revalidate();
    }

    private int getSelectedRow(JTable table) {
        return table.getRowSorter().convertRowIndexToModel(table.getSelectedRow());
    }
}

