/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import flashsystem.Bundle;
import gui.LoaderSelectGUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import org.lang.Language;
import org.logger.MyLogger;
import org.system.DeviceEntry;
import org.system.Devices;

public class deviceSelectGui
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private String result = "";
    private Bundle _bundle;
    private JTable tableDevices;
    private DefaultTableModel modelDevices;

    public void fillTable() {
        this.modelDevices = new DefaultTableModel();
        this.modelDevices.addColumn("Id");
        this.modelDevices.addColumn("Name");
        this.tableDevices.setModel(this.modelDevices);
        this.tableDevices.setAutoResizeMode(0);
        this.tableDevices.getColumn("Id").setPreferredWidth(50);
        this.tableDevices.getColumn("Name").setPreferredWidth(170);
        Enumeration<Object> e = Devices.listDevices(false);
        while (e.hasMoreElements()) {
            DeviceEntry entry = Devices.getDevice((String)e.nextElement());
            this.modelDevices.addRow(new String[]{entry.getId(), entry.getName()});
            this.tableDevices.setRowSelectionInterval(0, 0);
        }
        this.tableDevices.getRowSorter().toggleSortOrder(0);
    }

    public void fillTable(Properties list) {
        this.modelDevices = new DefaultTableModel();
        this.modelDevices.addColumn("Id");
        this.modelDevices.addColumn("Name");
        this.tableDevices.setModel(this.modelDevices);
        this.tableDevices.setAutoResizeMode(0);
        this.tableDevices.getColumn("Id").setPreferredWidth(50);
        this.tableDevices.getColumn("Name").setPreferredWidth(170);
        Enumeration<Object> e = list.keys();
        while (e.hasMoreElements()) {
            DeviceEntry entry = Devices.getDevice((String)e.nextElement());
            this.modelDevices.addRow(new String[]{entry.getId(), entry.getName()});
            this.tableDevices.setRowSelectionInterval(0, 0);
        }
        this.tableDevices.getRowSorter().toggleSortOrder(0);
    }

    public deviceSelectGui(Bundle bundle) {
        this._bundle = bundle;
        this.setName("deviceSelectGui");
        this.setModal(true);
        this.setTitle("Device Selection");
        this.setBounds(100, 100, 240, 322);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"max(131dlu;default):grow")}, new RowSpec[]{RowSpec.decode((String)"default:grow")}));
        JScrollPane scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "1, 1, fill, fill");
        this.tableDevices = new JTable(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return this.getPreferredSize().width < this.getParent().getWidth();
            }
        };
        this.tableDevices.setAutoResizeMode(0);
        this.tableDevices.setSelectionMode(0);
        this.tableDevices.setAutoCreateRowSorter(true);
        scrollPane.setViewportView(this.tableDevices);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                deviceSelectGui.this.result = "";
                deviceSelectGui.this.dispose();
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                deviceSelectGui.this.result = (String)deviceSelectGui.this.modelDevices.getValueAt(deviceSelectGui.this.getSelectedRow(deviceSelectGui.this.tableDevices), 0);
                deviceSelectGui.this.dispose();
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setName("cancelButton");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                deviceSelectGui.this.result = "";
                deviceSelectGui.this.dispose();
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        this.setLanguage();
    }

    public boolean isSelected() {
        this.fillTable();
        this.setVisible(!this._bundle.hasLoader());
        if (!this._bundle.hasLoader() && this.result.length() > 0) {
            MyLogger.getLogger().debug((Object)("Choosed loader from device selection :" + this.result));
            if (Devices.getDevice(this.result).hasUnlockedLoader()) {
                LoaderSelectGUI sel = new LoaderSelectGUI();
                String resultL = sel.getResult();
                if (resultL.equals("L")) {
                    this._bundle.setLoader(new File(Devices.getDevice(this.result).getLoader()));
                } else {
                    this._bundle.setLoader(new File(Devices.getDevice(this.result).getLoaderUnlocked()));
                }
            } else {
                this._bundle.setLoader(new File(Devices.getDevice(this.result).getLoader()));
            }
        }
        return this.result.length() > 0 || this._bundle.hasLoader();
    }

    public String getDevice() {
        this.fillTable();
        this.setVisible(true);
        return this.result;
    }

    public String getDevice(Properties list) {
        if (list.size() > 1) {
            this.fillTable(list);
            MyLogger.getLogger().warn((Object)"Your device has been matched with more than one device");
        } else {
            this.fillTable();
        }
        this.setVisible(true);
        return this.result;
    }

    public String getDeviceFromList(Properties list) {
        if (list == null) {
            this.fillTable();
        } else if (list.size() > 0) {
            this.fillTable(list);
        } else {
            this.fillTable();
        }
        this.setVisible(true);
        return this.result;
    }

    public void setLanguage() {
        Language.translate(this);
    }

    private int getSelectedRow(JTable table) {
        return table.getRowSorter().convertRowIndexToModel(table.getSelectedRow());
    }
}

