/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import gui.AppListManager;
import gui.CustomAppList;
import gui.ListItem;
import gui.MyCellRenderer;
import gui.ProfileImport;
import gui.ProfileSaveAs;
import gui.SortedNameListModel;
import gui.X10Apps;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.lang.Language;
import org.logger.MyLogger;
import org.system.Devices;
import org.system.OS;
import org.system.Profile;
import org.system.TextFile;

public class apkClean
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private static String fsep = OS.getFileSeparator();
    JList listInstalled;
    JList listToRemove;
    JList listRemoved;
    JList listToInstall;
    JComboBox comboProfile;
    DefaultListModel listInstalledModel = new DefaultListModel();
    DefaultListModel listRemovedModel = new DefaultListModel();
    DefaultListModel listToRemoveModel = new DefaultListModel();
    DefaultListModel listToInstallModel = new DefaultListModel();
    SortedNameListModel sortedInstalledModel = new SortedNameListModel(this.listInstalledModel);
    SortedNameListModel sortedRemovedModel = new SortedNameListModel(this.listRemovedModel);
    SortedNameListModel sortedToRemoveModel = new SortedNameListModel(this.listToRemoveModel);
    SortedNameListModel sortedToInstallModel = new SortedNameListModel(this.listToInstallModel);
    TextFile appsremove = new TextFile("." + fsep + "custom" + fsep + "clean" + fsep + "listappsremove", "ASCII");
    TextFile appsadd = new TextFile("." + fsep + "custom" + fsep + "clean" + fsep + "listappsadd", "ASCII");
    X10Apps apps;
    ItemListener profileChange;
    JMenuItem mntmSave;
    JMenuItem mntmExport;

    public void dumpToRemoveToFile() throws IOException {
        if (this.sortedToRemoveModel.getSize() > 0) {
            this.appsremove.open(false);
            boolean first = true;
            int i = 0;
            while (i < this.sortedToRemoveModel.getSize()) {
                ListItem li = (ListItem)this.sortedToRemoveModel.getElementAt(i);
                if (first) {
                    this.appsremove.write(li.getFile());
                    first = false;
                } else {
                    this.appsremove.writeln("");
                    this.appsremove.write(li.getFile());
                }
                ++i;
            }
            this.appsremove.close();
        }
    }

    public void dumpToAddToFile() throws IOException {
        if (this.sortedToInstallModel.getSize() > 0) {
            this.appsadd.open(false);
            boolean first = true;
            int i = 0;
            while (i < this.sortedToInstallModel.getSize()) {
                ListItem li = (ListItem)this.sortedToInstallModel.getElementAt(i);
                if (first) {
                    this.appsadd.write(li.getFile());
                    first = false;
                } else {
                    this.appsadd.writeln("");
                    this.appsadd.write(li.getFile());
                }
                ++i;
            }
            this.appsadd.close();
        }
    }

    public apkClean() {
        this.setName("apkClean");
        this.setTitle("SE ROM Cleaner");
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 580, 532);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu mnEdit = new JMenu("Edit");
        mnEdit.setName(String.valueOf(this.getName()) + "_mnEdit");
        menuBar.add(mnEdit);
        JMenuItem mntmApplicationListManager = new JMenuItem("Application List Manager");
        mntmApplicationListManager.setName("mntmApplicationListManager");
        mntmApplicationListManager.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AppListManager manager = new AppListManager(apkClean.this.apps);
                manager.setVisible(true);
                apkClean.this.fillLists();
            }
        });
        mnEdit.add(mntmApplicationListManager);
        JMenu mnProfiles = new JMenu("Profiles");
        mnEdit.add(mnProfiles);
        this.mntmSave = new JMenuItem("Save");
        mnProfiles.add(this.mntmSave);
        this.mntmSave.setName(String.valueOf(this.getName()) + "_mntmSave");
        this.mntmSave.setEnabled(false);
        JMenuItem mntmSaveAs = new JMenuItem("Save As");
        mnProfiles.add(mntmSaveAs);
        mntmSaveAs.setName(String.valueOf(this.getName()) + "_mntmSaveAs");
        this.mntmExport = new JMenuItem("Export");
        this.mntmExport.setEnabled(false);
        this.mntmExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Profile.save(apkClean.this.apps);
            }
        });
        mnProfiles.add(this.mntmExport);
        JMenuItem mntmImport = new JMenuItem("Import");
        mntmImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ProfileImport imp = new ProfileImport("./custom/clean" + File.separator + Devices.getCurrent().getId());
                String profile = imp.getProfile();
                if (profile.length() > 0) {
                    try {
                        BufferedOutputStream out;
                        String outname;
                        InputStream in;
                        JarEntry entry;
                        JarFile j = new JarFile(profile);
                        Enumeration<JarEntry> e = j.entries();
                        while (e.hasMoreElements()) {
                            int len;
                            entry = e.nextElement();
                            if (!entry.getName().toLowerCase().endsWith("apk")) continue;
                            in = j.getInputStream(entry);
                            outname = "." + OS.getFileSeparator() + "custom" + OS.getFileSeparator() + "apps_saved" + File.separator + Devices.getCurrent().getId() + File.separator + OS.getFileSeparator() + entry.getName();
                            MyLogger.getLogger().debug((Object)("Writing Entry to " + outname));
                            out = new BufferedOutputStream(new FileOutputStream(outname));
                            byte[] byArray = new byte[1024];
                            while ((len = in.read(byArray)) >= 0) {
                                ((OutputStream)out).write(byArray, 0, len);
                            }
                            in.close();
                            ((OutputStream)out).close();
                        }
                        e = j.entries();
                        while (e.hasMoreElements()) {
                            entry = e.nextElement();
                            if (entry.getName().toLowerCase().startsWith("safelist")) {
                                int len;
                                in = j.getInputStream(entry);
                                outname = "." + OS.getFileSeparator() + "custom" + OS.getFileSeparator() + "clean" + File.separator + Devices.getCurrent().getId() + File.separator + OS.getFileSeparator() + entry.getName();
                                MyLogger.getLogger().debug((Object)("Writing Entry to " + outname));
                                out = new BufferedOutputStream(new FileOutputStream(outname));
                                byte[] byArray = new byte[1024];
                                while ((len = in.read(byArray)) >= 0) {
                                    ((OutputStream)out).write(byArray, 0, len);
                                }
                                in.close();
                                ((OutputStream)out).close();
                            }
                            if (!entry.getName().toLowerCase().startsWith("custom")) continue;
                            in = j.getInputStream(entry);
                            Properties p = new Properties();
                            p.load(in);
                            for (String string : p.keySet()) {
                                String desc = p.getProperty(string);
                                apkClean.this.apps.addApk(new File("./custom/apps_saved/" + fsep + Devices.getCurrent().getId() + File.separator + string), desc);
                            }
                            in.close();
                        }
                        apkClean.this.comboProfile.addItem(j.getManifest().getMainAttributes().getValue("profileName"));
                        apkClean.this.fillLists();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        mnProfiles.add(mntmImport);
        mntmSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ProfileSaveAs ps = new ProfileSaveAs();
                if (ps.SaveAs(apkClean.this.apps)) {
                    apkClean.this.comboProfile.removeItemListener(apkClean.this.profileChange);
                    apkClean.this.comboProfile.removeAllItems();
                    Iterator<String> itprofiles = apkClean.this.apps.getProfiles().iterator();
                    while (itprofiles.hasNext()) {
                        apkClean.this.comboProfile.addItem(itprofiles.next());
                    }
                    apkClean.this.comboProfile.setSelectedItem(apkClean.this.apps.getCurrentProfile());
                    apkClean.this.mntmSave.setEnabled(true);
                    apkClean.this.mntmExport.setEnabled(true);
                    apkClean.this.comboProfile.addItemListener(apkClean.this.profileChange);
                }
            }
        });
        this.mntmSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                apkClean.this.apps.saveProfile();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(134dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"51px"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(16dlu;default)"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(53dlu;default)"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(13dlu;default):grow"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(13dlu;default)"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(13dlu;default)"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(13dlu;default):grow")}));
        JPanel panel = new JPanel();
        this.contentPanel.add((Component)panel, "2, 2, 7, 1, fill, fill");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblProfile = new JLabel("Profile :");
        panel.add((Component)lblProfile, "2, 2");
        this.comboProfile = new JComboBox();
        this.profileChange = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (arg0.getStateChange() == 1 && !apkClean.this.apps.getCurrentProfile().equals((String)apkClean.this.comboProfile.getSelectedItem())) {
                    if (((String)apkClean.this.comboProfile.getSelectedItem()).equals("default")) {
                        apkClean.this.mntmSave.setEnabled(false);
                        apkClean.this.mntmExport.setEnabled(false);
                    } else {
                        apkClean.this.mntmSave.setEnabled(true);
                        apkClean.this.mntmExport.setEnabled(true);
                    }
                    apkClean.this.apps.setProfile((String)apkClean.this.comboProfile.getSelectedItem());
                    apkClean.this.fillLists();
                }
            }
        };
        panel.add((Component)this.comboProfile, "4, 2");
        JLabel lblInstalled = new JLabel("Installed on device :");
        lblInstalled.setName("lblInstalled");
        this.contentPanel.add((Component)lblInstalled, "2, 4");
        JLabel lblToBeRemoved = new JLabel("To be removed :");
        lblToBeRemoved.setName("lblToBeRemoved");
        this.contentPanel.add((Component)lblToBeRemoved, "6, 4");
        JScrollPane scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "2, 6, 1, 7, fill, fill");
        this.listInstalled = new JList();
        this.listInstalled.setCellRenderer(new MyCellRenderer());
        this.listInstalled.setModel(this.sortedInstalledModel);
        scrollPane.setViewportView(this.listInstalled);
        scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "6, 6, 3, 7, fill, fill");
        this.listToRemove = new JList();
        this.listToRemove.setModel(this.sortedToRemoveModel);
        this.listToRemove.setCellRenderer(new MyCellRenderer());
        scrollPane.setViewportView(this.listToRemove);
        JButton button = new JButton("->");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] values = apkClean.this.listInstalled.getSelectedValues();
                int i = 0;
                while (i < values.length) {
                    apkClean.this.listToRemoveModel.addElement(values[i]);
                    apkClean.this.apps.setSafe(((ListItem)values[i]).getFile());
                    apkClean.this.listInstalledModel.removeElement(values[i]);
                    ++i;
                }
            }
        });
        this.contentPanel.add((Component)button, "4, 8");
        button = new JButton("<-");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] values = apkClean.this.listToRemove.getSelectedValues();
                int i = 0;
                while (i < values.length) {
                    apkClean.this.listToRemoveModel.removeElement(values[i]);
                    apkClean.this.apps.setUnsafe(((ListItem)values[i]).getFile());
                    apkClean.this.listInstalledModel.addElement(values[i]);
                    ++i;
                }
            }
        });
        this.contentPanel.add((Component)button, "4, 10");
        JLabel lblRemovedFromDevice = new JLabel("Available for installation :");
        lblRemovedFromDevice.setName("lblRemovedFromDevice");
        this.contentPanel.add((Component)lblRemovedFromDevice, "2, 14");
        JLabel lblToBeInstalled = new JLabel("To be installed :");
        lblToBeInstalled.setName("lblToBeInstalled");
        this.contentPanel.add((Component)lblToBeInstalled, "6, 14");
        scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "2, 16, 1, 7, fill, fill");
        this.listRemoved = new JList();
        this.listRemoved.setModel(this.sortedRemovedModel);
        this.listRemoved.setCellRenderer(new MyCellRenderer());
        scrollPane.setViewportView(this.listRemoved);
        scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "6, 16, 3, 7, fill, fill");
        this.listToInstall = new JList();
        this.listToInstall.setModel(this.sortedToInstallModel);
        this.listToInstall.setCellRenderer(new MyCellRenderer());
        scrollPane.setViewportView(this.listToInstall);
        button = new JButton("->");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Object[] values = apkClean.this.listRemoved.getSelectedValues();
                int i = 0;
                while (i < values.length) {
                    apkClean.this.listToInstallModel.addElement(values[i]);
                    apkClean.this.apps.setUnsafe(((ListItem)values[i]).getFile());
                    apkClean.this.listRemovedModel.removeElement(values[i]);
                    ++i;
                }
            }
        });
        this.contentPanel.add((Component)button, "4, 18");
        button = new JButton("<-");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Object[] values = apkClean.this.listToInstall.getSelectedValues();
                int i = 0;
                while (i < values.length) {
                    apkClean.this.listRemovedModel.addElement(values[i]);
                    apkClean.this.apps.setSafe(((ListItem)values[i]).getFile());
                    apkClean.this.listToInstallModel.removeElement(values[i]);
                    ++i;
                }
            }
        });
        this.contentPanel.add((Component)button, "4, 20");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    apkClean.this.dumpToRemoveToFile();
                    apkClean.this.dumpToAddToFile();
                }
                catch (IOException ioe) {
                    apkClean.this.appsremove.delete();
                }
                apkClean.this.dispose();
            }
        });
        okButton.setActionCommand("OK");
        okButton.setName("okButton");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setName("cancelButton");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                apkClean.this.appsremove.delete();
                apkClean.this.appsadd.delete();
                apkClean.this.dispose();
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        try {
            this.apps = new X10Apps();
            Iterator<String> itprofiles = this.apps.getProfiles().iterator();
            while (itprofiles.hasNext()) {
                this.comboProfile.addItem(itprofiles.next());
            }
            this.apps.setProfile("default");
            this.comboProfile.setSelectedItem("default");
            this.comboProfile.addItemListener(this.profileChange);
            this.fillLists();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.listInstalled.setSelectedIndex(0);
        this.listRemoved.setSelectedIndex(0);
        JPopupMenu popupMenu = new JPopupMenu();
        apkClean.addPopup(this.listRemoved, popupMenu);
        JMenuItem mntmAdd = new JMenuItem("Add");
        mntmAdd.setName("mntmAdd");
        mntmAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CustomAppList list = new CustomAppList(apkClean.this.apps);
                String result = list.getApp();
                if (result.length() > 0) {
                    apkClean.this.apps.setSafe(result);
                    apkClean.this.fillLists();
                }
            }
        });
        popupMenu.add(mntmAdd);
        this.setLanguage();
    }

    public void fillLists() {
        this.listInstalledModel.removeAllElements();
        this.listToRemoveModel.removeAllElements();
        this.listToInstallModel.removeAllElements();
        this.listRemovedModel.removeAllElements();
        Enumeration<String> e1 = this.apps.getInstalled();
        while (e1.hasMoreElements()) {
            String elem = e1.nextElement();
            ListItem li = new ListItem(elem, this.apps.getRealName(elem), Color.black, Color.white);
            this.listInstalledModel.addElement(li);
        }
        Enumeration<String> e2 = this.apps.getToBeRemoved();
        while (e2.hasMoreElements()) {
            String elem = e2.nextElement();
            ListItem li = new ListItem(elem, this.apps.getRealName(elem), Color.black, Color.white);
            this.listToRemoveModel.addElement(li);
        }
        Enumeration<String> e3 = this.apps.getToBeInstalled();
        while (e3.hasMoreElements()) {
            String elem = e3.nextElement();
            ListItem li = new ListItem(elem, this.apps.getRealName(elem), Color.black, Color.white);
            this.listToInstallModel.addElement(li);
        }
        Enumeration<String> e4 = this.apps.getRemoved();
        while (e4.hasMoreElements()) {
            String elem = e4.nextElement();
            ListItem li = new ListItem(elem, this.apps.getRealName(elem), Color.black, Color.white);
            this.listRemovedModel.addElement(li);
        }
    }

    public void setLanguage() {
        Language.translate(this);
    }

    private static void addPopup(Component component, final JPopupMenu popup) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }
}

