/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.adb.AdbUtility;
import org.system.Devices;
import org.system.OS;
import org.system.PropertiesFile;

public class X10Apps {
    private static String fsep = OS.getFileSeparator();
    private PropertiesFile deviceList = new PropertiesFile("", "." + fsep + "custom" + fsep + "clean" + fsep + Devices.getCurrent().getId() + fsep + Devices.getCurrent().getId() + "list.properties");
    private PropertiesFile customList = new PropertiesFile("", "." + fsep + "custom" + fsep + "clean" + fsep + Devices.getCurrent().getId() + fsep + Devices.getCurrent().getId() + "customlist.properties");
    private PropertiesFile safeList;
    private HashSet<String> currentList;
    private String currentProfile = "";
    private Properties realnames = new Properties();
    private HashMap<String, PropertiesFile> Allsafelist = new HashMap();

    private void copyToAppsSaved(File src) throws IOException {
        File dst = new File("./custom/apps_saved/" + Devices.getCurrent().getId() + fsep + src.getName());
        if (!dst.exists()) {
            int len;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public Properties deviceList() {
        return this.deviceList.getProperties();
    }

    public Properties customList() {
        return this.customList.getProperties();
    }

    public void addApk(File apk, String desc) {
        try {
            this.copyToAppsSaved(apk);
            this.customList.setProperty(apk.getName(), desc);
            this.customList.write("UTF-8");
            this.realnames.setProperty(desc, apk.getName());
            this.rescan();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void modApk(String apkname, String desc) {
        if (this.customList.getProperties().containsKey(apkname)) {
            this.customList.setProperty(apkname, desc);
            this.customList.write("UTF-8");
        }
        if (this.deviceList.getProperties().containsKey(apkname)) {
            this.deviceList.setProperty(apkname, desc);
            this.deviceList.write("UTF-8");
        }
        this.realnames.setProperty(desc, apkname);
        this.rescan();
    }

    private void rescan() {
        File[] dirlist = new File("." + fsep + "custom" + fsep + "clean" + fsep + Devices.getCurrent().getId()).listFiles();
        int i = 0;
        while (i < dirlist.length) {
            if (dirlist[i].getName().contains("safelist")) {
                String key = dirlist[i].getName().replace("safelist", "");
                if (!this.Allsafelist.containsKey((key = key.replace(".properties", "")).toLowerCase())) {
                    this.Allsafelist.put(key.toLowerCase(), new PropertiesFile("", dirlist[i].getPath()));
                }
            }
            ++i;
        }
    }

    public String getCurrentProfile() {
        return this.currentProfile;
    }

    public X10Apps() {
        try {
            this.currentList = AdbUtility.listSysApps();
            for (String next : this.currentList) {
                if (this.deviceList.getProperties().containsKey(next)) continue;
                this.deviceList.setProperty(next, next);
            }
            this.deviceList.write("UTF-8");
            this.safeList = new PropertiesFile();
            for (String string : this.deviceList.getProperties().keySet()) {
                this.safeList.setProperty(string, "unsafe");
            }
            this.currentProfile = "default";
            this.Allsafelist.put("default", this.safeList);
            if (!new File("." + fsep + "custom" + fsep + "clean" + fsep + Devices.getCurrent().getId() + fsep + "safelist" + this.currentProfile + ".properties").exists()) {
                this.saveProfile(this.currentProfile);
            }
            for (String string : this.customList.getProperties().keySet()) {
            }
            this.rescan();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setProfile(String profile) {
        this.currentProfile = profile;
        this.safeList = this.Allsafelist.get(profile);
        this.fillSet();
        this.deviceList.write("UTF-8");
        this.customList.write("UTF-8");
    }

    public void saveProfile() {
        this.Allsafelist.get(this.currentProfile).write("UTF-8");
    }

    public void saveProfile(String name) {
        this.Allsafelist.get(this.currentProfile).write("." + fsep + "custom" + fsep + "clean" + fsep + Devices.getCurrent().getId() + fsep + "safelist" + name + ".properties", "UTF-8");
        this.rescan();
        this.setProfile(name.toLowerCase());
    }

    private void fillSet() {
        try {
            for (String apk : this.currentList) {
                if (this.safeList.getProperty(apk) != null) continue;
                this.safeList.setProperty(apk, "unsafe");
            }
            Enumeration<Object> e = this.safeList.getProperties().keys();
            while (e.hasMoreElements()) {
                String string = (String)e.nextElement();
            }
            for (String string : this.deviceList.keySet()) {
                this.realnames.setProperty(this.deviceList.getProperty(string), string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Set<String> getProfiles() {
        return this.Allsafelist.keySet();
    }

    public HashSet<String> getCurrent() {
        return this.currentList;
    }

    public String getRealName(String apk) {
        return this.deviceList.getProperty(apk);
    }

    public String getApkName(String realName) {
        return this.realnames.getProperty(realName);
    }

    public void setSafe(String apkName) {
        this.safeList.setProperty(apkName, "safe");
    }

    public void setUnsafe(String apkName) {
        this.safeList.setProperty(apkName, "unsafe");
    }

    public Enumeration<String> getToBeRemoved() {
        Vector<String> v = new Vector<String>();
        for (String apk : this.currentList) {
            if (!this.safeList.getProperty(apk).equals("safe")) continue;
            v.add(apk);
        }
        return v.elements();
    }

    public Enumeration<String> getRemoved() {
        Vector<String> v = new Vector<String>();
        for (String string : this.safeList.keySet()) {
            if (this.currentList.contains(string) || !this.safeList.getProperty(string).equals("safe")) continue;
            v.add(string);
        }
        return v.elements();
    }

    public Enumeration<String> getToBeInstalled() {
        Vector<String> v = new Vector<String>();
        for (String string : this.safeList.keySet()) {
            if (this.currentList.contains(string) || !this.safeList.getProperty(string).equals("unsafe")) continue;
            v.add(string);
        }
        return v.elements();
    }

    public Enumeration<String> getInstalled() {
        Vector<String> v = new Vector<String>();
        for (String apk : this.currentList) {
            if (!this.safeList.getProperty(apk).equals("unsafe")) continue;
            v.add(apk);
        }
        return v.elements();
    }
}

