/*
 * Decompiled with CFR 0.152.
 */
package gui;

import at.HexLib.library.HexLib;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import flashsystem.BytesUtil;
import flashsystem.TaEntry;
import flashsystem.TaFile;
import flashsystem.X10flash;
import gui.AskBox;
import gui.ResizeSelectGUI;
import gui.TaSelectGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import org.logger.MyLogger;
import org.logger.TextAreaAppender;
import org.system.OS;
import org.system.TextFile;

public class TaEditor
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    HashMap content = new HashMap();
    TaEntry ta = null;
    private JTable tablePartition;
    private DefaultTableModel modelPartition;
    private HexLib hex = new HexLib();
    private JPopupMenu popupMenu = new JPopupMenu();
    private X10flash _flash;

    public TaEditor(X10flash flash, Vector<TaEntry> v) {
        this._flash = flash;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("TA Editor");
        this.setBounds(100, 100, 715, 450);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(63dlu;min)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JScrollPane scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "2, 2, 1, 7, fill, fill");
        this.tablePartition = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return false;
            }
        };
        this.tablePartition.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                TaEditor.this.reloadUnit();
            }
        });
        this.tablePartition.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                String result = (String)TaEditor.this.modelPartition.getValueAt(TaEditor.this.tablePartition.getSelectedRow(), 0);
                try {
                    if (TaEditor.this.ta != null) {
                        TaEditor.this.ta.setData(TaEditor.this.hex.getByteContent());
                    }
                    TaEditor.this.ta = (TaEntry)TaEditor.this.content.get(result);
                    TaEditor.this.hex.setByteContent(TaEditor.this.ta.getDataString().getBytes());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JMenuItem mntmResize = new JMenuItem("Resize Unit");
        mntmResize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ResizeSelectGUI resize = new ResizeSelectGUI();
                String newsize = resize.getUnitSize();
                if (newsize.length() > 0) {
                    TaEditor.this.ta.resize(Integer.parseInt(newsize));
                    TaEditor.this.hex.setByteContent(TaEditor.this.ta.getDataString().getBytes());
                }
            }
        });
        this.popupMenu.add(mntmResize);
        JMenuItem mntmLoad = new JMenuItem("Load from file");
        mntmLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TaSelectGUI tasel = new TaSelectGUI(".bin", String.valueOf(TaEditor.this._flash.getPhoneProperty("MSN")) + "_" + (String)TaEditor.this.modelPartition.getValueAt(TaEditor.this.tablePartition.getSelectedRow(), 0));
                String result = tasel.getTa();
                if (result.length() > 0) {
                    String path = String.valueOf(OS.getWorkDir()) + "/custom/ta/" + result;
                    try {
                        byte[] array = BytesUtil.getBytesFromFile(new File(path));
                        TaEditor.this.ta.setData(array);
                        TaEditor.this.hex.setByteContent(array);
                    }
                    catch (Exception e) {
                        MyLogger.getLogger().error((Object)e.getMessage());
                    }
                }
            }
        });
        this.popupMenu.add(mntmLoad);
        JMenuItem mntmWriteFile = new JMenuItem("Write to file");
        mntmWriteFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String rootpath = String.valueOf(OS.getWorkDir()) + "/custom/ta/";
                String path = String.valueOf(TaEditor.this._flash.getPhoneProperty("MSN")) + "_" + (String)TaEditor.this.modelPartition.getValueAt(TaEditor.this.tablePartition.getSelectedRow(), 0) + "-" + TextAreaAppender.timestamp + ".bin";
                File f = new File(String.valueOf(rootpath) + path);
                try {
                    FileOutputStream fos = new FileOutputStream(f);
                    fos.write(TaEditor.this.hex.getByteContent());
                    fos.flush();
                    fos.close();
                    AskBox.showOKbox("Unit saved to \n" + path);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.popupMenu.add(mntmWriteFile);
        JMenuItem mntmWrite = new JMenuItem("Write to phone");
        mntmWrite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TaEditor.this.reloadUnit();
                try {
                    TaEditor.this._flash.sendTAUnit(TaEditor.this.ta);
                }
                catch (Exception e) {
                    MyLogger.getLogger().error((Object)e.getMessage());
                }
            }
        });
        this.popupMenu.add(mntmWrite);
        PopupListener popupListener = new PopupListener();
        this.tablePartition.addMouseListener(popupListener);
        this.tablePartition.setSelectionMode(0);
        scrollPane.setViewportView(this.tablePartition);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Close");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TaEditor.this.dispose();
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        this.contentPanel.add((Component)this.hex, "4, 2, 1, 7");
        this.hex.setColorBorderBackGround(Color.LIGHT_GRAY);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu("File");
        menuBar.add(mnFile);
        JMenuItem mntmLoad_1 = new JMenuItem("Load");
        mntmLoad_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TaSelectGUI tasel = new TaSelectGUI(".ta", TaEditor.this._flash.getPhoneProperty("MSN"));
                String result = tasel.getTa();
                if (result.length() > 0) {
                    String tafile = String.valueOf(OS.getWorkDir()) + "/custom/ta/" + result;
                    try {
                        TaFile ta = new TaFile(new FileInputStream(new File(tafile)));
                        Vector<TaEntry> entries = ta.entries();
                        TaEditor.this.fill(entries);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        mnFile.add(mntmLoad_1);
        JMenuItem mntmSave = new JMenuItem("Save");
        mntmSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    String rootpath = String.valueOf(OS.getWorkDir()) + "/custom/ta/";
                    String path = String.valueOf(TaEditor.this._flash.getPhoneProperty("MSN")) + "-" + TextAreaAppender.timestamp + ".ta";
                    TextFile tazone = new TextFile(String.valueOf(rootpath) + path, "ISO8859-1");
                    tazone.open(false);
                    Iterator i = TaEditor.this.content.values().iterator();
                    while (i.hasNext()) {
                        tazone.writeln(i.next().toString());
                    }
                    tazone.close();
                    AskBox.showOKbox("TA saved to \n" + path);
                }
                catch (Exception e) {
                    MyLogger.getLogger().error((Object)e.getMessage());
                }
            }
        });
        mnFile.add(mntmSave);
        this.fill(v);
    }

    private void fill(Vector<TaEntry> v) {
        Enumeration<TaEntry> e = v.elements();
        this.modelPartition = new DefaultTableModel();
        this.modelPartition.addColumn("Unit");
        this.tablePartition.setModel(this.modelPartition);
        while (e.hasMoreElements()) {
            TaEntry ta = e.nextElement();
            this.content.put(ta.getPartition(), ta);
            this.modelPartition.addRow(new String[]{ta.getPartition()});
        }
        this.tablePartition.setRowSelectionInterval(0, 0);
        this.reloadUnit();
    }

    private static void addPopup(Component component, final JPopupMenu popup) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }

    private void reloadUnit() {
        String result = (String)this.modelPartition.getValueAt(this.tablePartition.getSelectedRow(), 0);
        if (this.ta != null) {
            this.ta.setData(this.hex.getByteContent());
        }
        this.ta = (TaEntry)this.content.get(result);
        this.hex.setByteContent(this.ta.getDataString().getBytes());
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        private void showPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                TaEditor.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

