/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.EncDecGUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SortedSizeListModel
extends AbstractListModel {
    private static final long serialVersionUID = 1L;
    private List<SortedListEntry> sortedModel;
    private ListModel unsortedModel;
    private Comparator comparator;
    private SortOrder sortOrder;

    public SortedSizeListModel(ListModel model) {
        this(model, SortOrder.ASCENDING, null);
    }

    public SortedSizeListModel(ListModel model, SortOrder sortOrder) {
        this(model, sortOrder, null);
    }

    public SortedSizeListModel(ListModel model, SortOrder sortOrder, Comparator comp) {
        this.unsortedModel = model;
        this.unsortedModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                SortedSizeListModel.this.unsortedIntervalAdded(e);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                SortedSizeListModel.this.unsortedIntervalRemoved(e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                SortedSizeListModel.this.unsortedContentsChanged(e);
            }
        });
        this.sortOrder = sortOrder;
        this.comparator = comp != null ? comp : new MyComparator();
        int size = model.getSize();
        this.sortedModel = new ArrayList<SortedListEntry>(size);
        int x = 0;
        while (x < size) {
            SortedListEntry entry = new SortedListEntry(x);
            int insertionPoint = this.findInsertionPoint(entry);
            this.sortedModel.add(insertionPoint, entry);
            ++x;
        }
    }

    @Override
    public Object getElementAt(int index) throws IndexOutOfBoundsException {
        int modelIndex = this.toUnsortedModelIndex(index);
        Object element = this.unsortedModel.getElementAt(modelIndex);
        return element;
    }

    @Override
    public int getSize() {
        int size = this.sortedModel.size();
        return size;
    }

    public int toUnsortedModelIndex(int index) throws IndexOutOfBoundsException {
        int modelIndex = -1;
        SortedListEntry entry = this.sortedModel.get(index);
        modelIndex = entry.getIndex();
        return modelIndex;
    }

    public int[] toUnsortedModelIndices(int[] sortedSelectedIndices) {
        int[] unsortedSelectedIndices = new int[sortedSelectedIndices.length];
        int x = 0;
        int[] nArray = sortedSelectedIndices;
        int n = sortedSelectedIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int sortedIndex = nArray[n2];
            unsortedSelectedIndices[x++] = this.toUnsortedModelIndex(sortedIndex);
            ++n2;
        }
        Arrays.sort(unsortedSelectedIndices);
        return unsortedSelectedIndices;
    }

    public int toSortedModelIndex(int unsortedIndex) {
        int sortedIndex = -1;
        int x = -1;
        for (SortedListEntry entry : this.sortedModel) {
            ++x;
            if (entry.getIndex() != unsortedIndex) continue;
            sortedIndex = x;
            break;
        }
        return sortedIndex;
    }

    public int[] toSortedModelIndices(int[] unsortedModelIndices) {
        int[] sortedModelIndices = new int[unsortedModelIndices.length];
        int x = 0;
        int[] nArray = unsortedModelIndices;
        int n = unsortedModelIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int unsortedIndex = nArray[n2];
            sortedModelIndices[x++] = this.toSortedModelIndex(unsortedIndex);
            ++n2;
        }
        Arrays.sort(sortedModelIndices);
        return sortedModelIndices;
    }

    private void resetModelData() {
        int index = 0;
        for (SortedListEntry entry : this.sortedModel) {
            entry.setIndex(index++);
        }
    }

    public void setComparator(Comparator comp) {
        if (comp == null) {
            this.sortOrder = SortOrder.UNORDERED;
            this.comparator = new MyComparator();
            this.resetModelData();
        } else {
            this.comparator = comp;
            Collections.sort(this.sortedModel);
        }
        this.fireContentsChanged(0, 0, this.sortedModel.size() - 1);
    }

    public void setSortOrder(SortOrder sortOrder) {
        if (this.sortOrder != sortOrder) {
            this.sortOrder = sortOrder;
            if (sortOrder == SortOrder.UNORDERED) {
                this.resetModelData();
            } else {
                Collections.sort(this.sortedModel);
            }
            this.fireContentsChanged(0, 0, this.sortedModel.size() - 1);
        }
    }

    private void unsortedIntervalAdded(ListDataEvent e) {
        int begin = e.getIndex0();
        int end = e.getIndex1();
        int nElementsAdded = end - begin + 1;
        for (SortedListEntry entry : this.sortedModel) {
            int index = entry.getIndex();
            if (index < begin) continue;
            entry.setIndex(index + nElementsAdded);
        }
        int x = begin;
        while (x <= end) {
            SortedListEntry newEntry = new SortedListEntry(x);
            int insertionPoint = this.findInsertionPoint(newEntry);
            this.sortedModel.add(insertionPoint, newEntry);
            this.fireIntervalAdded(1, insertionPoint, insertionPoint);
            ++x;
        }
    }

    private void unsortedIntervalRemoved(ListDataEvent e) {
        int begin = e.getIndex0();
        int end = e.getIndex1();
        int nElementsRemoved = end - begin + 1;
        int sortedSize = this.sortedModel.size();
        boolean[] bElementRemoved = new boolean[sortedSize];
        int x = sortedSize - 1;
        while (x >= 0) {
            SortedListEntry entry = this.sortedModel.get(x);
            int index = entry.getIndex();
            if (index > end) {
                entry.setIndex(index - nElementsRemoved);
            } else if (index >= begin) {
                this.sortedModel.remove(x);
                bElementRemoved[x] = true;
            }
            --x;
        }
        x = bElementRemoved.length - 1;
        while (x >= 0) {
            if (bElementRemoved[x]) {
                this.fireIntervalRemoved(2, x, x);
            }
            --x;
        }
    }

    private void unsortedContentsChanged(ListDataEvent e) {
        Collections.sort(this.sortedModel);
        this.fireContentsChanged(0, 0, this.sortedModel.size() - 1);
    }

    private int findInsertionPoint(SortedListEntry entry) {
        int insertionPoint = this.sortedModel.size();
        if (this.sortOrder != SortOrder.UNORDERED && (insertionPoint = Collections.binarySearch(this.sortedModel, entry)) < 0) {
            insertionPoint = -(insertionPoint + 1);
        }
        return insertionPoint;
    }

    public class MyComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            long result = ((EncDecGUI.MyFile)o2).length() - ((EncDecGUI.MyFile)o1).length();
            if (result > 0L) {
                return 1;
            }
            if (result < 0L) {
                return -1;
            }
            return 0;
        }
    }

    public static enum SortOrder {
        UNORDERED,
        ASCENDING,
        DESCENDING;

    }

    class SortedListEntry
    implements Comparable {
        private int index;

        private SortedListEntry() {
        }

        public SortedListEntry(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int compareTo(Object o) {
            Object thisElement = SortedSizeListModel.this.unsortedModel.getElementAt(this.index);
            SortedListEntry thatEntry = (SortedListEntry)o;
            Object thatElement = SortedSizeListModel.this.unsortedModel.getElementAt(thatEntry.getIndex());
            int comparison = SortedSizeListModel.this.comparator.compare(thisElement, thatElement);
            if (SortedSizeListModel.this.sortOrder == SortOrder.DESCENDING) {
                comparison = -comparison;
            }
            return comparison;
        }
    }
}

