/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import flashsystem.HexDump;
import flashsystem.SinFile;
import foxtrot.Job;
import foxtrot.Worker;
import gui.SinCreatorUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import org.logger.MyLogger;

public class SinEditorUI
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private JTextField textSin;
    private JTextField textPartition;
    private JTextField textSpare;
    private SinFile sin;
    private JTextField textCtype;
    private JButton btnUnpack;
    private JButton btnDumpData;
    private JButton btnDumpHeader;
    private JButton btnCreateSin;
    private JButton okButton;
    private JDialog _sinui;
    private JLabel lblProcessing;

    public SinEditorUI() {
        this.setResizable(false);
        this._sinui = this;
        this.setModal(true);
        this.setTitle("Sin Editor");
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 450, 372);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblSinFil = new JLabel("Sin File :");
        this.contentPanel.add((Component)lblSinFil, "2, 2, 5, 1");
        this.textSin = new JTextField();
        this.textSin.setEditable(false);
        this.contentPanel.add((Component)this.textSin, "2, 4, 5, 1, fill, default");
        this.textSin.setColumns(10);
        JButton button = new JButton("...");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String file = SinEditorUI.this.chooseSin();
                if (!file.equals("ERROR")) {
                    try {
                        SinEditorUI.this.sin = new SinFile(file);
                        SinEditorUI.this.textSin.setText(file);
                        String p = HexDump.toHex(SinEditorUI.this.sin.getPartitionInfoBytes()).replaceAll(", ", "");
                        SinEditorUI.this.textPartition.setText(p.substring(1, p.length() - 1));
                        SinEditorUI.this.textSpare.setText(HexDump.toHex(SinEditorUI.this.sin.getSpareBytes()));
                        SinEditorUI.this.textCtype.setText(SinEditorUI.this.sin.getDataType());
                        SinEditorUI.this.btnDumpData.setEnabled(true);
                        SinEditorUI.this.btnDumpHeader.setEnabled(true);
                        SinEditorUI.this.btnCreateSin.setEnabled(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.contentPanel.add((Component)button, "8, 4");
        JLabel lblPartitionInfo = new JLabel("Partition Info :");
        this.contentPanel.add((Component)lblPartitionInfo, "2, 6, 5, 1");
        this.textPartition = new JTextField();
        this.textPartition.setEditable(false);
        this.contentPanel.add((Component)this.textPartition, "2, 8, 5, 1, fill, default");
        this.textPartition.setColumns(10);
        JLabel lblSpareInfo = new JLabel("Spare Info :");
        this.contentPanel.add((Component)lblSpareInfo, "2, 10, 5, 1");
        this.textSpare = new JTextField();
        this.textSpare.setEditable(false);
        this.contentPanel.add((Component)this.textSpare, "2, 12, 5, 1, fill, default");
        this.textSpare.setColumns(10);
        this.btnDumpData = new JButton("Dump data");
        this.btnDumpData.setEnabled(false);
        this.btnDumpData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Worker.post((Job)new Job(){

                    public Object run() {
                        try {
                            SinEditorUI.this.okButton.setEnabled(false);
                            SinEditorUI.this.btnDumpData.setEnabled(false);
                            SinEditorUI.this.btnDumpHeader.setEnabled(false);
                            SinEditorUI.this.btnCreateSin.setEnabled(false);
                            SinEditorUI.this.lblProcessing.setText("Processing action. Please wait");
                            SinEditorUI.this._sinui.setDefaultCloseOperation(0);
                            SinEditorUI.this.sin.dumpImage();
                            SinEditorUI.this.okButton.setEnabled(true);
                            SinEditorUI.this.btnDumpData.setEnabled(true);
                            SinEditorUI.this.btnDumpHeader.setEnabled(true);
                            SinEditorUI.this.btnCreateSin.setEnabled(true);
                            SinEditorUI.this.lblProcessing.setText("");
                            SinEditorUI.this._sinui.setDefaultCloseOperation(2);
                        }
                        catch (Exception e) {
                            MyLogger.getLogger().error((Object)e.getMessage());
                        }
                        return null;
                    }
                });
            }
        });
        JLabel lblContentType = new JLabel("Content type :");
        this.contentPanel.add((Component)lblContentType, "2, 14");
        this.textCtype = new JTextField();
        this.textCtype.setEditable(false);
        this.contentPanel.add((Component)this.textCtype, "2, 16, 5, 1, fill, default");
        this.textCtype.setColumns(10);
        this.contentPanel.add((Component)this.btnDumpData, "2, 18, center, center");
        this.btnDumpHeader = new JButton("Dump header");
        this.btnDumpHeader.setEnabled(false);
        this.btnDumpHeader.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SinEditorUI.this.sin.dumpHeader();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.contentPanel.add((Component)this.btnDumpHeader, "4, 18");
        this.btnUnpack = new JButton("Unpack data");
        this.contentPanel.add((Component)this.btnUnpack, "6, 18, center, default");
        this.btnUnpack.setEnabled(false);
        this.btnCreateSin = new JButton("Create Sin As");
        this.btnCreateSin.setEnabled(false);
        this.btnCreateSin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SinCreatorUI cui = new SinCreatorUI(SinEditorUI.this.sin.getLongFileName(), SinEditorUI.this.textPartition.getText(), SinEditorUI.this.textSpare.getText());
                cui.setVisible(true);
            }
        });
        this.contentPanel.add((Component)this.btnCreateSin, "4, 20");
        this.lblProcessing = new JLabel("");
        this.contentPanel.add((Component)this.lblProcessing, "2, 22, 7, 1, center, center");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.okButton = new JButton("Close");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SinEditorUI.this.dispose();
            }
        });
        this.okButton.setActionCommand("OK");
        buttonPane.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
    }

    public String chooseSin() {
        JFileChooser chooser = new JFileChooser(new File("."));
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".sin");
            }

            @Override
            public String getDescription() {
                return "*.sin";
            }
        };
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ff);
        chooser.setDialogTitle("Choose sin file)");
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return "ERROR";
    }
}

