/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import org.logger.MyLogger;
import org.system.OS;
import org.system.ProcessBuilderWrapper;

public class SinCreatorUI
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    private JTextField textSin;
    private JTextField textPartition;
    private JTextField textSpare;
    private JTextField textData;
    private JButton btnCreateSin;

    public SinCreatorUI(String sinfile, String part, String spare) {
        this.setModal(true);
        this.setTitle("Sin Creator");
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 450, 318);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblSinFil = new JLabel("Sin FileName :");
        this.contentPanel.add((Component)lblSinFil, "2, 2, 5, 1");
        this.textSin = new JTextField();
        this.textSin.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                if (SinCreatorUI.this.textSin.getText().length() == 0) {
                    SinCreatorUI.this.btnCreateSin.setEnabled(false);
                } else if (SinCreatorUI.this.textData.getText().length() > 0) {
                    SinCreatorUI.this.btnCreateSin.setEnabled(true);
                }
            }
        });
        this.contentPanel.add((Component)this.textSin, "2, 4, 5, 1, fill, default");
        this.textSin.setColumns(10);
        JLabel lblPartitionInfo = new JLabel("Partition Info :");
        this.contentPanel.add((Component)lblPartitionInfo, "2, 6, 5, 1");
        this.textPartition = new JTextField();
        this.textPartition.setEditable(false);
        this.contentPanel.add((Component)this.textPartition, "2, 8, 5, 1, fill, default");
        this.textPartition.setColumns(10);
        JLabel lblSpareInfo = new JLabel("Spare Info :");
        this.contentPanel.add((Component)lblSpareInfo, "2, 10, 5, 1");
        this.textSpare = new JTextField();
        this.textSpare.setEditable(false);
        this.contentPanel.add((Component)this.textSpare, "2, 12, 5, 1, fill, default");
        this.textSpare.setColumns(10);
        this.btnCreateSin = new JButton("Create sin");
        this.btnCreateSin.setEnabled(false);
        this.btnCreateSin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    ProcessBuilderWrapper processBuilderWrapper = SinCreatorUI.this.textSpare.getText().equals("09") ? new ProcessBuilderWrapper(new String[]{OS.getBin2SinPath(), SinCreatorUI.this.textData.getText(), SinCreatorUI.this.textPartition.getText(), "0x" + SinCreatorUI.this.textSpare.getText(), "0x20000"}, false) : new ProcessBuilderWrapper(new String[]{OS.getBin2SinPath(), SinCreatorUI.this.textData.getText(), SinCreatorUI.this.textPartition.getText(), "0x" + SinCreatorUI.this.textSpare.getText(), "0x20000", "0x1000"}, false);
                    File result = new File(String.valueOf(SinCreatorUI.this.textData.getText()) + ".sin");
                    result.renameTo(new File(String.valueOf(OS.getWorkDir()) + "/custom/sin/" + SinCreatorUI.this.textSin.getText()));
                }
                catch (Exception e) {
                    MyLogger.getLogger().error((Object)e.getMessage());
                }
            }
        });
        JLabel lblContentType = new JLabel("Data File");
        this.contentPanel.add((Component)lblContentType, "2, 14");
        this.textData = new JTextField();
        this.textData.setEditable(false);
        this.contentPanel.add((Component)this.textData, "2, 16, 5, 1, fill, default");
        this.textData.setColumns(10);
        JButton button = new JButton("...");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String file = SinCreatorUI.this.chooseData();
                if (!file.equals("ERROR")) {
                    SinCreatorUI.this.textData.setText(file);
                    if (SinCreatorUI.this.textSin.getText().length() == 0) {
                        SinCreatorUI.this.btnCreateSin.setEnabled(false);
                    } else {
                        SinCreatorUI.this.btnCreateSin.setEnabled(true);
                    }
                }
            }
        });
        this.contentPanel.add((Component)button, "8, 16");
        this.contentPanel.add((Component)this.btnCreateSin, "2, 18, center, center");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("Close");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SinCreatorUI.this.dispose();
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.textSin.setText(sinfile);
        this.textPartition.setText(part);
        this.textSpare.setText(spare);
    }

    public String chooseData() {
        JFileChooser chooser = new JFileChooser(new File("."));
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                if (f.getName().endsWith(".yaffs2")) {
                    return true;
                }
                if (f.getName().endsWith(".ext4")) {
                    return true;
                }
                if (f.getName().endsWith(".elf")) {
                    return true;
                }
                return f.getName().endsWith(".img");
            }

            @Override
            public String getDescription() {
                return "*.yaffs, *.ext4, *.elf, *.img";
            }
        };
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ff);
        chooser.setDialogTitle("Choose sin file)");
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return "ERROR";
    }
}

