/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import org.adb.AdbUtility;
import org.logger.MyLogger;

public class RecoveryBootSelectGUI
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private JTable table;
    private String result = "";
    private DefaultTableModel modelVersion;
    private JButton okButton;
    private JButton cancelButton;

    public RecoveryBootSelectGUI() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RecoveryBootSelectGUI.this.result = "";
                RecoveryBootSelectGUI.this.dispose();
            }
        });
        this.setResizable(false);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Recovery Selector");
        this.setBounds(100, 100, 200, 300);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JScrollPane scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "2, 2, fill, fill");
        this.table = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return false;
            }
        };
        this.table.setSelectionMode(0);
        scrollPane.setViewportView(this.table);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RecoveryBootSelectGUI.this.result = (String)RecoveryBootSelectGUI.this.modelVersion.getValueAt(RecoveryBootSelectGUI.this.table.getSelectedRow(), 0);
                RecoveryBootSelectGUI.this.dispose();
            }
        });
        this.okButton.setActionCommand("OK");
        buttonPane.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecoveryBootSelectGUI.this.result = "";
                RecoveryBootSelectGUI.this.dispose();
            }
        });
        this.cancelButton.setActionCommand("Cancel");
        buttonPane.add(this.cancelButton);
        try {
            this.recovlist();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getVersion() {
        this.setVisible(true);
        return this.result;
    }

    private void recovlist() throws Exception {
        boolean hasElements = false;
        this.result = "";
        this.modelVersion = new DefaultTableModel();
        this.modelVersion.addColumn("Version");
        this.table.setModel(this.modelVersion);
        try {
            HashSet<String> set = AdbUtility.listRecoveries();
            for (String recovery : set) {
                hasElements = true;
                this.modelVersion.addRow(new String[]{recovery});
                MyLogger.getLogger().debug((Object)("Adding " + recovery + " to list of recovery versions"));
            }
            if (hasElements) {
                this.table.setRowSelectionInterval(0, 0);
                this.result = (String)this.modelVersion.getValueAt(this.table.getSelectedRow(), 0);
            }
            this.okButton.setEnabled(hasElements);
        }
        catch (Exception e) {
            this.okButton.setEnabled(false);
        }
    }
}

