/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import org.logger.MyLogger;

public class KernelSelectGUI
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private JTable table;
    private String result = "";
    private DefaultTableModel modelVersion;
    private JButton okButton;
    private JButton cancelButton;

    public KernelSelectGUI(String root) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                KernelSelectGUI.this.result = "";
                KernelSelectGUI.this.dispose();
            }
        });
        this.setResizable(false);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Kernel Selector");
        this.setBounds(100, 100, 232, 300);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JScrollPane scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "2, 2, fill, fill");
        this.table = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return false;
            }
        };
        this.table.setSelectionMode(0);
        scrollPane.setViewportView(this.table);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                KernelSelectGUI.this.result = (String)KernelSelectGUI.this.modelVersion.getValueAt(KernelSelectGUI.this.table.getSelectedRow(), 0);
                KernelSelectGUI.this.dispose();
            }
        });
        this.okButton.setActionCommand("OK");
        buttonPane.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KernelSelectGUI.this.result = "";
                KernelSelectGUI.this.dispose();
            }
        });
        this.cancelButton.setActionCommand("Cancel");
        buttonPane.add(this.cancelButton);
        try {
            this.dirlist(root);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getVersion() {
        this.setVisible(true);
        return this.result;
    }

    private void dirlist(String root) throws Exception {
        boolean hasElements = false;
        this.modelVersion = new DefaultTableModel();
        this.modelVersion.addColumn("Version");
        this.table.setModel(this.modelVersion);
        File dir = new File("./devices/" + root + "/kernel");
        File[] chld = dir.listFiles();
        int i = 0;
        while (i < chld.length) {
            if (chld[i].isDirectory()) {
                hasElements = true;
                this.modelVersion.addRow(new String[]{chld[i].getName()});
                MyLogger.getLogger().debug((Object)("Adding " + chld[i].getName() + " to list of firmwares"));
            }
            ++i;
        }
        if (!hasElements) {
            this.okButton.setEnabled(false);
            this.result = "";
        } else {
            this.table.setRowSelectionInterval(0, 0);
            this.result = (String)this.modelVersion.getValueAt(this.table.getSelectedRow(), 0);
            this.okButton.setEnabled(true);
        }
    }
}

