/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import flashsystem.Bundle;
import flashsystem.BundleException;
import flashsystem.FlasherConsole;
import flashsystem.SeusSinTool;
import flashsystem.TaEntry;
import flashsystem.X10flash;
import foxtrot.Job;
import foxtrot.Worker;
import gui.About;
import gui.ApkInstallGUI;
import gui.AskBox;
import gui.BootModeSelectGUI;
import gui.BuildPropGUI;
import gui.BundleGUI;
import gui.CustomFlashUI;
import gui.DeviceEditorUI;
import gui.ElfUnpacker;
import gui.EncDecGUI;
import gui.FastBootToolboxGUI;
import gui.KernelBootSelectGUI;
import gui.KernelSelectGUI;
import gui.LangActionListener;
import gui.RecoverySelectGUI;
import gui.RootPackageSelect;
import gui.SinEditorUI;
import gui.TaEditor;
import gui.TaModeSelectGUI;
import gui.TaSelectGUI;
import gui.WaitDeviceFlashmodeGUI;
import gui.X10Apps;
import gui.apkClean;
import gui.deviceSelectGui;
import gui.firmSelect;
import gui.rebrandGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import linuxlib.JUsb;
import org.adb.APKUtility;
import org.adb.AdbUtility;
import org.lang.Language;
import org.logger.MyLogger;
import org.plugins.PluginActionListener;
import org.plugins.PluginActionListenerAbout;
import org.plugins.PluginInterface;
import org.system.AdbPhoneThread;
import org.system.ClassPath;
import org.system.CommentedPropertiesFile;
import org.system.Device;
import org.system.DeviceChangedListener;
import org.system.DeviceEntry;
import org.system.DeviceProperties;
import org.system.Devices;
import org.system.FileDrop;
import org.system.GlobalConfig;
import org.system.OS;
import org.system.ProcessBuilderWrapper;
import org.system.PropertiesFile;
import org.system.RunStack;
import org.system.Shell;
import org.system.StatusEvent;
import org.system.StatusListener;
import org.system.TextFile;
import org.system.VersionChecker;

public class FlasherGUI
extends JFrame {
    public static FlasherGUI _root;
    public static boolean guimode;
    private static String fsep;
    private static final long serialVersionUID = 1L;
    private static JToolBar toolBar;
    private static JTextPane textArea;
    private static AdbPhoneThread phoneWatchdog;
    private JPanel contentPane;
    private Bundle bundle;
    private ButtonGroup buttonGroupLog = new ButtonGroup();
    private ButtonGroup buttonGroupLang = new ButtonGroup();
    private JButton flashBtn;
    private JButton btnRoot;
    private JButton btnAskRootPerms;
    private JButton btnCleanroot;
    private JButton custBtn;
    private JButton btnXrecovery;
    private JButton btnKernel;
    private JMenuItem mntmSwitchPro;
    private JMenuItem mntmInstallBusybox;
    private JMenuItem mntmDumpProperties;
    private JMenuItem mntmClearCache;
    private JMenuItem mntmBuildpropEditor;
    private JMenuItem mntmBuildpropRebrand;
    private JMenuItem mntmSetDefaultRecovery;
    private JMenuItem mntmRebootDefaultRecovery;
    private JMenuItem mntmRebootIntoRecoveryT;
    private JMenuItem mntmSetDefaultKernel;
    private JMenuItem mntmRebootCustomKernel;
    private JMenuItem mntmRebootDefaultKernel;
    private JMenuItem mntmRootPsneuter;
    private JMenuItem mntmRootzergRush;
    private JMenuItem mntmRootEmulator;
    private JMenuItem mntmRootAdbRestore;
    private JMenuItem mntmUnRoot;
    private JMenuItem mntmBackupSystemApps;
    private JMenuItem mntmRawIO;
    private JMenuItem mntmSinEdit;
    private JMenuItem mntmElfUnpack;
    private JMenuItem mntmYaffs2Unpack;
    private JMenuItem mntmDevicesAdd;
    private JMenuItem mntmDevicesRemove;
    private JMenuItem mntmDevicesEdit;
    private JMenuItem mntmDevicesExport;
    private JMenuItem mntmDevicesImport;
    private JMenu mnPlugins;
    private String lang;
    private String ftfpath = "";
    private String ftfname = "";
    private JMenu mnDev;

    static {
        guimode = true;
        fsep = OS.getFileSeparator();
        textArea = new JTextPane();
    }

    private static void setSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initLogger() throws FileNotFoundException {
        MyLogger.appendTextArea(textArea);
        MyLogger.setLevel(GlobalConfig.getProperty("loglevel").toUpperCase());
    }

    public static void runAdb() throws Exception {
        if (!OS.getName().equals("windows")) {
            ProcessBuilderWrapper giveRights = new ProcessBuilderWrapper(new String[]{"chmod", "755", OS.getAdbPath()}, false);
            ProcessBuilderWrapper processBuilderWrapper = new ProcessBuilderWrapper(new String[]{"chmod", "755", OS.getFastBootPath()}, false);
        }
        FlasherGUI.killAdbandFastboot();
    }

    public static void addToolbar(JButton button) {
        toolBar.add(button);
    }

    public static void main(String[] args) throws Exception {
        OptionSet options;
        try {
            if (OS.getName() != "windows") {
                JUsb.init();
            }
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            System.out.println("libusbx 1.0 not installed. 1.0.14 version mandatory");
            System.out.println("It can be downloaded on http://www.libusbx.org");
            System.exit(1);
        }
        OptionParser parser = new OptionParser();
        parser.accepts("console");
        try {
            options = parser.parse(args);
        }
        catch (Exception e) {
            parser.accepts("action").withRequiredArg().required();
            parser.accepts("file").withOptionalArg().defaultsTo((Object)"", (Object[])new String[0]);
            parser.accepts("method").withOptionalArg().defaultsTo((Object)"auto", (Object[])new String[0]);
            parser.accepts("wipedata").withOptionalArg().defaultsTo((Object)"yes", (Object[])new String[0]);
            parser.accepts("wipecache").withOptionalArg().defaultsTo((Object)"yes", (Object[])new String[0]);
            parser.accepts("baseband").withOptionalArg().defaultsTo((Object)"yes", (Object[])new String[0]);
            parser.accepts("system").withOptionalArg().defaultsTo((Object)"yes", (Object[])new String[0]);
            parser.accepts("kernel").withOptionalArg().defaultsTo((Object)"yes", (Object[])new String[0]);
            options = parser.parse(args);
        }
        Language.Init(GlobalConfig.getProperty("language").toLowerCase());
        if (options.has("console")) {
            String action = (String)options.valueOf("action");
            if (action.toLowerCase().equals("flash")) {
                FlasherConsole.init(false);
                FlasherConsole.doFlash((String)options.valueOf("file"), options.valueOf("wipedata").equals("yes"), options.valueOf("wipecache").equals("yes"), options.valueOf("baseband").equals("no"), options.valueOf("kernel").equals("no"), options.valueOf("system").equals("no"));
            }
            if (action.toLowerCase().equals("imei")) {
                FlasherConsole.init(false);
                FlasherConsole.doGetIMEI();
            }
            if (action.toLowerCase().equals("root")) {
                FlasherConsole.init(true);
                FlasherConsole.doRoot();
            }
            if (action.toLowerCase().equals("blunlock")) {
                FlasherConsole.init(true);
                FlasherConsole.doBLUnlock();
            }
            FlasherConsole.exit();
        } else {
            FlasherGUI.initLogger();
            FlasherGUI.setSystemLookAndFeel();
            FlasherGUI.runAdb();
            MyLogger.getLogger().info((Object)("Flashtool " + About.getVersion()));
            if (JUsb.version.length() > 0) {
                MyLogger.getLogger().info((Object)JUsb.version);
            }
            MyLogger.getLogger().info((Object)"You can drag and drop ftf files here to start flashing them");
            String userdir = System.getProperty("user.dir");
            String pathsep = System.getProperty("path.separator");
            System.setProperty("java.library.path", String.valueOf(OS.getWinDir()) + pathsep + OS.getSystem32Dir() + pathsep + userdir + fsep + "x10flasher_lib");
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        FlasherGUI frame = new FlasherGUI();
                        frame.setVisible(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public FlasherGUI() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(FlasherGUI.class.getResource("/gui/ressources/icons/flash_32.png")));
        _root = this;
        this.setName("FlasherGUI");
        this.setTitle("SonyEricsson X10 Flasher by Bin4ry & Androxyde");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 845, 480);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FlasherGUI.this.exitProgram();
            }
        });
        new FileDrop(null, textArea, new FileDrop.Listener(){

            @Override
            public void filesDropped(final File[] files) {
                if (files.length == 1) {
                    if (files[0].getAbsolutePath().toUpperCase().endsWith("FTF")) {
                        try {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        FlasherGUI.this.doFlashmode(files[0].getParentFile().getAbsolutePath(), files[0].getName());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            });
                        }
                        catch (Exception exception) {}
                    } else {
                        MyLogger.getLogger().error((Object)"You can only drop ftf files");
                    }
                } else {
                    MyLogger.getLogger().error((Object)"You dropped more than one file");
                }
            }
        });
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu("File");
        mnFile.setName("mnFile");
        menuBar.add(mnFile);
        this.mntmSwitchPro = new JMenuItem(GlobalConfig.getProperty("devfeatures").equals("yes") ? "Switch Simple" : "Switch Pro");
        mnFile.add(this.mntmSwitchPro);
        JMenuItem mntmExit = new JMenuItem("Exit");
        mntmExit.setName("mntmExit");
        mnFile.add(mntmExit);
        JMenu mnAdvanced = new JMenu("Tools");
        mnAdvanced.setName("mnAdvanced");
        menuBar.add(mnAdvanced);
        this.mnDev = new JMenu("Advanced");
        this.mnDev.setVisible(false);
        menuBar.add(this.mnDev);
        JMenu mnLang = new JMenu("Language");
        mnLang.setName("mnLang");
        menuBar.add(mnLang);
        Enumeration<String> listlang = Language.getLanguages();
        while (listlang.hasMoreElements()) {
            this.lang = listlang.nextElement();
            PropertiesFile plang = Language.getProperties(this.lang);
            JRadioButtonMenuItem menu = new JRadioButtonMenuItem(plang.getProperty("rdbtnmntm" + this.lang));
            menu.setName("rdbtnmntm" + this.lang);
            menu.setText(Language.getMenuItem("rdbtnmntm" + this.lang));
            this.buttonGroupLang.add(menu);
            mnLang.add(menu);
            menu.setSelected(GlobalConfig.getProperty("language").equals(this.lang));
            menu.addActionListener(new LangActionListener(this.lang, this.buttonGroupLang, _root));
        }
        JMenuItem mntmEncryptDecrypt = new JMenuItem("Decrypt Files");
        mntmEncryptDecrypt.setName("mntmEncryptDecrypt");
        mntmEncryptDecrypt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlasherGUI.this.doEncDec();
            }
        });
        this.mntmInstallBusybox = new JMenuItem("Install BusyBox");
        this.mntmInstallBusybox.setName("mntmInstallBusybox");
        this.mntmInstallBusybox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlasherGUI.this.doInstallBusyBox();
            }
        });
        this.mntmDumpProperties = new JMenuItem("TA Editor");
        this.mntmDumpProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FlasherGUI.this.doDumpProperties();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.mntmRawIO = new JMenuItem("Raw I/O Module");
        this.mntmRawIO.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FlasherGUI.this.doRawIO();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JMenuItem mntmTaBackupRestore = new JMenuItem("TA Backup & Restore");
        mntmTaBackupRestore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FlasherGUI.this.BackupRestore();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.mnDev.add(this.mntmDumpProperties);
        this.mnDev.add(mntmTaBackupRestore);
        this.mnDev.add(this.mntmRawIO);
        this.mntmSinEdit = new JMenuItem("SIN Editor");
        this.mntmSinEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FlasherGUI.this.doSinEdit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.mntmElfUnpack = new JMenuItem("ELF");
        this.mntmElfUnpack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FlasherGUI.this.doElfUnpack();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.mntmYaffs2Unpack = new JMenuItem("Yaffs2");
        this.mntmYaffs2Unpack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FlasherGUI.this.doYaffs2Unpack();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JMenu mnRoot = new JMenu("Root");
        mnAdvanced.add(mnRoot);
        this.mntmRootPsneuter = new JMenuItem("Force psneuter");
        this.mntmRootPsneuter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!Devices.getCurrent().hasRoot()) {
                    FlasherGUI.this.doRootpsneuter();
                } else {
                    JOptionPane.showMessageDialog(null, "Your device is already rooted");
                }
            }
        });
        this.mntmRootzergRush = new JMenuItem("Force zergRush");
        this.mntmRootzergRush.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!Devices.getCurrent().hasRoot()) {
                    FlasherGUI.this.doRootzergRush();
                } else {
                    JOptionPane.showMessageDialog(null, "Your device is already rooted");
                }
            }
        });
        this.mntmRootEmulator = new JMenuItem("Force Emulator");
        this.mntmRootEmulator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!Devices.getCurrent().hasRoot()) {
                    FlasherGUI.this.doRootEmulator();
                } else {
                    JOptionPane.showMessageDialog(null, "Your device is already rooted");
                }
            }
        });
        this.mntmRootAdbRestore = new JMenuItem("Force AdbRestore hack");
        this.mntmRootAdbRestore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!Devices.getCurrent().hasRoot()) {
                    try {
                        FlasherGUI.this.doRootAdbRestore();
                    }
                    catch (Exception e) {
                        MyLogger.getLogger().error((Object)e.getMessage());
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Your device is already rooted");
                }
            }
        });
        this.mntmUnRoot = new JMenuItem("Unroot device");
        this.mntmUnRoot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Devices.getCurrent().hasRoot()) {
                    try {
                        FlasherGUI.this.doUnroot();
                    }
                    catch (Exception e) {
                        MyLogger.getLogger().error((Object)e.getMessage());
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Your device is not rooted");
                }
            }
        });
        mnRoot.add(this.mntmRootPsneuter);
        mnRoot.add(this.mntmRootzergRush);
        mnRoot.add(this.mntmRootEmulator);
        mnRoot.add(this.mntmRootAdbRestore);
        mnRoot.add(this.mntmUnRoot);
        JMenu mnClean = new JMenu("Clean");
        mnClean.setName("mnClean");
        mnAdvanced.add(mnClean);
        this.mntmClearCache = new JMenuItem("Clear dalvik cache");
        mnClean.add(this.mntmClearCache);
        this.mntmClearCache.setName("mntmClearCache");
        this.mntmClearCache.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlasherGUI.this.doClearCache();
            }
        });
        this.mntmClearCache.setEnabled(false);
        JMenu mnXrecovery = new JMenu("Recovery");
        mnAdvanced.add(mnXrecovery);
        this.mntmSetDefaultRecovery = new JMenuItem("Set default recovery");
        this.mntmSetDefaultRecovery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlasherGUI.this.doSetDefaultRecovery();
            }
        });
        mnXrecovery.add(this.mntmSetDefaultRecovery);
        JMenu mnKernel = new JMenu("Kernel");
        mnAdvanced.add(mnKernel);
        this.mntmBackupSystemApps = new JMenuItem("Backup System Apps");
        this.mntmBackupSystemApps.setName("mntmBackupSystemApps");
        mnAdvanced.add(this.mntmBackupSystemApps);
        this.mntmBackupSystemApps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlasherGUI.this.doBackupSystem();
            }
        });
        this.mntmBackupSystemApps.setEnabled(false);
        mnAdvanced.add(this.mntmInstallBusybox);
        this.mntmBuildpropEditor = new JMenuItem("Build.prop Editor");
        this.mntmBuildpropEditor.setName("mntmBuildpropEditor");
        this.mntmBuildpropEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BuildPropGUI propsEdit = new BuildPropGUI();
                propsEdit.setVisible(true);
            }
        });
        mnAdvanced.add(this.mntmSinEdit);
        JMenu mnExtracts = new JMenu("Extractors");
        mnExtracts.add(this.mntmElfUnpack);
        mnExtracts.add(this.mntmYaffs2Unpack);
        mnAdvanced.add(mnExtracts);
        mnAdvanced.add(this.mntmBuildpropEditor);
        this.mntmBuildpropRebrand = new JMenuItem("Rebrand");
        this.mntmBuildpropRebrand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlasherGUI.this.doRebrand();
            }
        });
        mnAdvanced.add(this.mntmBuildpropRebrand);
        mnAdvanced.add(mntmEncryptDecrypt);
        JMenuItem mntmBundleCreation = new JMenuItem("Bundle Creation");
        mntmBundleCreation.setName("mntmBundleCreation");
        mntmBundleCreation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlasherGUI.this.doBundle();
            }
        });
        mnAdvanced.add(mntmBundleCreation);
        JMenu mnReboot = new JMenu("Reboot");
        mnAdvanced.add(mnReboot);
        JMenu mnRRecovery = new JMenu("Recovery");
        JMenu mnRKernel = new JMenu("Kernel");
        mnReboot.add(mnRRecovery);
        mnReboot.add(mnRKernel);
        this.mntmRebootDefaultRecovery = new JMenuItem("Reboot default version");
        this.mntmRebootDefaultRecovery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlasherGUI.this.doRebootRecovery();
            }
        });
        mnRRecovery.add(this.mntmRebootDefaultRecovery);
        this.mntmRebootIntoRecoveryT = new JMenuItem("Reboot specific version");
        this.mntmRebootIntoRecoveryT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlasherGUI.this.doRebootRecoveryT();
            }
        });
        mnRRecovery.add(this.mntmRebootIntoRecoveryT);
        this.mntmRebootIntoRecoveryT.setEnabled(false);
        this.mntmRebootDefaultRecovery.setEnabled(false);
        this.mntmSetDefaultRecovery.setEnabled(false);
        this.mntmSetDefaultKernel = new JMenuItem("Set default kernel");
        this.mntmSetDefaultKernel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlasherGUI.this.doSetDefaultKernel();
            }
        });
        mnKernel.add(this.mntmSetDefaultKernel);
        this.mntmSetDefaultKernel.setEnabled(false);
        this.mntmRebootDefaultKernel = new JMenuItem("Reboot default version");
        this.mntmRebootDefaultKernel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlasherGUI.this.doReboot();
            }
        });
        mnRKernel.add(this.mntmRebootDefaultKernel);
        this.mntmRebootDefaultKernel.setEnabled(false);
        this.mntmRebootCustomKernel = new JMenuItem("Reboot specific version");
        this.mntmRebootCustomKernel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlasherGUI.this.doRebootKexec();
            }
        });
        mnRKernel.add(this.mntmRebootCustomKernel);
        this.mntmRebootCustomKernel.setEnabled(false);
        JMenu mnHelp = new JMenu("Help");
        mnHelp.setName("mnHelp");
        this.mnPlugins = new JMenu("Plugins");
        JMenu mnDevices = new JMenu("Devices");
        this.mntmDevicesAdd = new JMenuItem("Add");
        this.mntmDevicesAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DeviceEditorUI edit = new DeviceEditorUI();
                edit.setVisible(true);
            }
        });
        this.mntmDevicesRemove = new JMenuItem("Remove");
        this.mntmDevicesRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Devices.listDevices(true);
                deviceSelectGui devsel = new deviceSelectGui(null);
                String devid = devsel.getDevice();
                if (devid.length() > 0) {
                    try {
                        FlasherGUI.doDeleteDevice(devid);
                        MyLogger.getLogger().info((Object)("Device " + devid + " deleted successfully"));
                    }
                    catch (Exception e) {
                        MyLogger.getLogger().error((Object)e.getMessage());
                    }
                }
            }
        });
        this.mntmDevicesEdit = new JMenuItem("Edit");
        this.mntmDevicesEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Devices.listDevices(true);
                deviceSelectGui devsel = new deviceSelectGui(null);
                String devid = devsel.getDevice();
                if (devid.length() > 0) {
                    DeviceEditorUI edit = new DeviceEditorUI();
                    edit.setEntry(Devices.getDevice(devid));
                    edit.setVisible(true);
                }
            }
        });
        this.mntmDevicesExport = new JMenuItem("Export");
        this.mntmDevicesExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Devices.listDevices(true);
                deviceSelectGui devsel = new deviceSelectGui(null);
                String devid = devsel.getDevice();
                if (devid.length() > 0) {
                    try {
                        FlasherGUI.doExportDevice(devid);
                        MyLogger.getLogger().info((Object)("Device " + devid + " Exported successfully"));
                    }
                    catch (Exception e) {
                        MyLogger.getLogger().error((Object)e.getMessage());
                    }
                }
            }
        });
        this.mntmDevicesImport = new JMenuItem("Import");
        this.mntmDevicesImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Worker.post((Job)new Job(){

                    public Object run() {
                        try {
                            Devices.listDevices(true);
                            deviceSelectGui devsel = new deviceSelectGui(null);
                            Properties list = new Properties();
                            File[] lfiles = new File(String.valueOf(OS.getWorkDir()) + File.separator + "devices").listFiles();
                            int i = 0;
                            while (i < lfiles.length) {
                                if (lfiles[i].getName().endsWith(".ftd")) {
                                    String name = lfiles[i].getName();
                                    name = name.substring(0, name.length() - 4);
                                    list.setProperty(name, "Device to import");
                                }
                                ++i;
                            }
                            String devid = devsel.getDeviceFromList(list);
                            if (devid.length() > 0) {
                                MyLogger.getLogger().info((Object)("Beginning import of " + devid));
                                FlasherGUI.doImportDevice(devid);
                                MyLogger.getLogger().info((Object)("Device " + devid + " imported successfully"));
                            }
                        }
                        catch (Exception e) {
                            MyLogger.getLogger().error((Object)e.getMessage());
                        }
                        return null;
                    }
                });
            }
        });
        mnDevices.add(this.mntmDevicesAdd);
        mnDevices.add(this.mntmDevicesEdit);
        mnDevices.add(this.mntmDevicesRemove);
        mnDevices.add(this.mntmDevicesExport);
        mnDevices.add(this.mntmDevicesImport);
        menuBar.add(this.mnPlugins);
        menuBar.add(mnDevices);
        menuBar.add(mnHelp);
        JMenu mnLoglevel = new JMenu("Loglevel");
        mnLoglevel.setName("mnLoglevel");
        mnHelp.add(mnLoglevel);
        JMenuItem mntmCheckDrivers = new JMenuItem("Check Drivers");
        mntmCheckDrivers.setName("mntmCheckDrivers");
        mntmCheckDrivers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Device.CheckAdbDrivers();
            }
        });
        mnHelp.add(mntmCheckDrivers);
        JMenuItem mntmAbout = new JMenuItem("About");
        mntmAbout.setName("mntmAbout");
        mnHelp.add(mntmAbout);
        JRadioButtonMenuItem rdbtnmntmError = new JRadioButtonMenuItem("errors");
        rdbtnmntmError.setName("mntmError");
        this.buttonGroupLog.add(rdbtnmntmError);
        mnLoglevel.add(rdbtnmntmError);
        rdbtnmntmError.setSelected(GlobalConfig.getProperty("loglevel").toUpperCase().equals("ERROR"));
        JRadioButtonMenuItem rdbtnmntmWarnings = new JRadioButtonMenuItem("warnings");
        rdbtnmntmWarnings.setName("mntmWarnings");
        this.buttonGroupLog.add(rdbtnmntmWarnings);
        mnLoglevel.add(rdbtnmntmWarnings);
        rdbtnmntmWarnings.setSelected(GlobalConfig.getProperty("loglevel").toUpperCase().equals("WARN"));
        JRadioButtonMenuItem rdbtnmntmInfos = new JRadioButtonMenuItem("infos");
        rdbtnmntmInfos.setName("mntmInfos");
        this.buttonGroupLog.add(rdbtnmntmInfos);
        mnLoglevel.add(rdbtnmntmInfos);
        rdbtnmntmInfos.setSelected(GlobalConfig.getProperty("loglevel").toUpperCase().equals("INFO"));
        JRadioButtonMenuItem rdbtnmntmDebug = new JRadioButtonMenuItem("debug");
        rdbtnmntmDebug.setName("mntmDebug");
        this.buttonGroupLog.add(rdbtnmntmDebug);
        mnLoglevel.add(rdbtnmntmDebug);
        rdbtnmntmDebug.setSelected(GlobalConfig.getProperty("loglevel").toUpperCase().equals("DEBUG"));
        rdbtnmntmError.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MyLogger.setLevel("ERROR");
                GlobalConfig.setProperty("loglevel", "error");
            }
        });
        rdbtnmntmWarnings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MyLogger.setLevel("WARN");
                GlobalConfig.setProperty("loglevel", "warn");
            }
        });
        rdbtnmntmInfos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MyLogger.setLevel("INFO");
                GlobalConfig.setProperty("loglevel", "info");
            }
        });
        rdbtnmntmDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MyLogger.setLevel("DEBUG");
                GlobalConfig.setProperty("loglevel", "debug");
            }
        });
        mntmExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RunStack.killAll();
                FlasherGUI.this.exitProgram();
            }
        });
        this.mntmSwitchPro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                boolean ispro = GlobalConfig.getProperty("devfeatures").equals("yes");
                FlasherGUI.this.mntmSwitchPro.setText(ispro ? "Switch Pro" : "Switch SImple");
                GlobalConfig.setProperty("devfeatures", ispro ? "no" : "yes");
                FlasherGUI.this.mnDev.setVisible(!ispro);
            }
        });
        mntmAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                About about = new About();
                about.setVisible(true);
            }
        });
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(50dlu;default):grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(78dlu;default)"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        toolBar = new JToolBar();
        toolBar.setFloatable(false);
        this.contentPane.add((Component)toolBar, "2, 2, left, fill");
        this.flashBtn = new JButton("");
        this.flashBtn.setToolTipText("Flash");
        this.flashBtn.setIcon(new ImageIcon(FlasherGUI.class.getResource("/gui/ressources/icons/flash_32.png")));
        toolBar.add(this.flashBtn);
        this.btnRoot = new JButton("");
        this.btnRoot.setToolTipText("Root");
        this.btnRoot.setIcon(new ImageIcon(FlasherGUI.class.getResource("/gui/ressources/icons/root_32.png")));
        toolBar.add(this.btnRoot);
        this.btnRoot.setEnabled(false);
        this.btnAskRootPerms = new JButton("");
        this.btnAskRootPerms.setIcon(new ImageIcon(FlasherGUI.class.getResource("/gui/ressources/icons/askroot_32.png")));
        this.btnAskRootPerms.setToolTipText("Ask Root Perms");
        toolBar.add(this.btnAskRootPerms);
        this.btnAskRootPerms.setBackground(SystemColor.control);
        this.btnAskRootPerms.setEnabled(false);
        this.btnCleanroot = new JButton("");
        this.btnCleanroot.setToolTipText("Clean (Root Needed)");
        this.btnCleanroot.setIcon(new ImageIcon(FlasherGUI.class.getResource("/gui/ressources/icons/clean_32.png")));
        toolBar.add(this.btnCleanroot);
        this.btnCleanroot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlasherGUI.this.doCleanRoot();
            }
        });
        this.btnCleanroot.setEnabled(false);
        this.custBtn = new JButton("");
        this.custBtn.setIcon(new ImageIcon(FlasherGUI.class.getResource("/gui/ressources/icons/customize_32.png")));
        this.custBtn.setToolTipText("APK Installer");
        toolBar.add(this.custBtn);
        this.custBtn.setEnabled(false);
        this.btnXrecovery = new JButton("");
        this.btnXrecovery.setToolTipText("Recovery Installer");
        this.btnXrecovery.setIcon(new ImageIcon(FlasherGUI.class.getResource("/gui/ressources/icons/recovery_32.png")));
        toolBar.add(this.btnXrecovery);
        this.btnXrecovery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlasherGUI.this.doInstallXRecovery();
            }
        });
        this.btnXrecovery.setEnabled(false);
        this.btnKernel = new JButton("");
        this.btnKernel.setToolTipText("Kernel Installer");
        this.btnKernel.setIcon(new ImageIcon(FlasherGUI.class.getResource("/gui/ressources/icons/kernel_32.png")));
        toolBar.add(this.btnKernel);
        this.btnKernel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlasherGUI.this.doInstallKernel();
            }
        });
        this.btnKernel.setEnabled(false);
        this.custBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlasherGUI.this.doCustomize();
            }
        });
        this.btnAskRootPerms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlasherGUI.this.doAskRoot();
            }
        });
        this.btnRoot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlasherGUI.this.doRoot();
            }
        });
        this.flashBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    FlasherGUI.this.doFlash();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JToolBar toolBar_1 = new JToolBar();
        toolBar_1.setFloatable(false);
        this.contentPane.add((Component)toolBar_1, "6, 2, right, center");
        JButton btnDonate = new JButton("");
        toolBar_1.add(btnDonate);
        btnDonate.setIcon(new ImageIcon(FlasherGUI.class.getResource("/gui/ressources/icons/paypal.png")));
        btnDonate.setToolTipText("Donate");
        btnDonate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FlasherGUI.this.doConnectPaypal();
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        this.contentPane.add((Component)scrollPane, "2, 8, 5, 1, fill, fill");
        scrollPane.setViewportView(textArea);
        JButton btnSaveLog = new JButton("Save log");
        btnSaveLog.setName("btnSaveLog");
        btnSaveLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyLogger.writeFile();
            }
        });
        this.contentPane.add((Component)btnSaveLog, "6, 10, right, center");
        UIManager.put("ProgressBar.background", Color.WHITE);
        UIManager.put("ProgressBar.foreground", Color.LIGHT_GRAY);
        UIManager.put("ProgressBar.selectionBackground", Color.BLACK);
        UIManager.put("ProgressBar.selectionForeground", Color.BLACK);
        JProgressBar progressBar = new JProgressBar();
        MyLogger.registerProgressBar(progressBar);
        this.contentPane.add((Component)progressBar, "2, 12, 5, 1");
        this.setLanguage();
        this.mntmInstallBusybox.setEnabled(false);
        this.mntmBuildpropEditor.setEnabled(false);
        this.mntmBuildpropRebrand.setEnabled(false);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.mnDev.setVisible(GlobalConfig.getProperty("devfeatures").equals("yes"));
        StatusListener phoneStatus = new StatusListener(){

            @Override
            public void statusChanged(StatusEvent e) {
                if (!e.isDriverOk()) {
                    MyLogger.getLogger().error((Object)"Drivers need to be installed for connected device.");
                    MyLogger.getLogger().error((Object)"You can find them in the drivers folder of Flashtool.");
                } else {
                    if (e.getNew().equals("adb")) {
                        MyLogger.getLogger().info((Object)"Device connected with USB debugging on");
                        MyLogger.getLogger().debug((Object)"Device connected, continuing with identification");
                        FlasherGUI.this.doIdent();
                    }
                    if (e.getNew().equals("none")) {
                        MyLogger.getLogger().info((Object)"Device disconnected");
                        FlasherGUI.this.doDisableIdent();
                    }
                    if (e.getNew().equals("flash")) {
                        MyLogger.getLogger().info((Object)"Device connected in flash mode");
                        FlasherGUI.this.doDisableIdent();
                    }
                    if (e.getNew().equals("fastboot")) {
                        MyLogger.getLogger().info((Object)"Device connected in fastboot mode");
                        FlasherGUI.this.doDisableIdent();
                    }
                    if (e.getNew().equals("normal")) {
                        MyLogger.getLogger().info((Object)"Device connected with USB debugging off");
                        MyLogger.getLogger().info((Object)"For 2011 devices line, be sure you are not in MTP mode");
                        FlasherGUI.this.doDisableIdent();
                    }
                }
            }
        };
        phoneWatchdog = new AdbPhoneThread();
        phoneWatchdog.start();
        phoneWatchdog.addStatusListener(phoneStatus);
        VersionChecker vcheck = new VersionChecker();
        vcheck.setMessageFrame(this);
        vcheck.start();
    }

    public void setLanguage() {
        Language.translate(this);
    }

    public void exitProgram() {
        try {
            MyLogger.getLogger().info((Object)"Stopping watchdogs and exiting ...");
            if (GlobalConfig.getProperty("killadbonexit").equals("yes")) {
                FlasherGUI.killAdbandFastboot();
            }
            System.exit(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void killAdbLinux() {
        try {
            ProcessBuilderWrapper processBuilderWrapper = new ProcessBuilderWrapper(new String[]{"/usr/bin/killall", "adb"}, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void killAdbWindows() {
        try {
            ProcessBuilderWrapper processBuilderWrapper = new ProcessBuilderWrapper(new String[]{"taskkill", "/F", "/T", "/IM", "adb*"}, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void stopPhoneWatchdog() {
        DeviceChangedListener.stop();
        if (phoneWatchdog != null) {
            phoneWatchdog.done();
            try {
                phoneWatchdog.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void killAdbandFastboot() {
        FlasherGUI.stopPhoneWatchdog();
    }

    public void doRawIO() {
        CustomFlashUI raw = new CustomFlashUI();
        raw.setVisible(true);
    }

    public void doSinEdit() {
        SinEditorUI sinui = new SinEditorUI();
        sinui.setVisible(true);
    }

    public void doElfUnpack() {
        ElfUnpacker unpack = new ElfUnpacker();
        unpack.setVisible(true);
    }

    public void doYaffs2Unpack() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    String file = FlasherGUI.this.chooseYaffs2();
                    if (!file.equals("ERROR")) {
                        int index = file.lastIndexOf(".yaffs2");
                        String folder = String.valueOf(file.substring(0, index)) + "_content";
                        MyLogger.getLogger().info((Object)("Extracting " + file + " to " + folder));
                        OS.unyaffs(file, folder);
                        MyLogger.getLogger().info((Object)"Extraction finished");
                    } else {
                        MyLogger.getLogger().info((Object)"Canceled");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void doCleanUninstall() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    PropertiesFile safeList = new PropertiesFile("org/adb/config/safelist.properties", "." + fsep + "custom" + fsep + "clean" + fsep + Devices.getCurrent().getId() + fsep + "safelist.properties");
                    HashSet<String> set = AdbUtility.listSysApps();
                    for (String string : safeList.keySet()) {
                        if (!safeList.getProperty(string).equals("safe") || set.contains(string)) continue;
                        MyLogger.getLogger().debug((Object)string);
                        if (!TextFile.exists("." + fsep + "custom" + fsep + "apps_saved" + File.separator + Devices.getCurrent().getId() + fsep + string)) continue;
                        String packageName = APKUtility.getPackageName("." + fsep + "custom" + fsep + "apps_saved" + File.separator + Devices.getCurrent().getId() + fsep + string);
                        MyLogger.getLogger().debug((Object)packageName);
                        AdbUtility.uninstall(packageName, false);
                    }
                    MyLogger.getLogger().info((Object)"Clean Finished");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void doDumpProperties() throws Exception {
        this.bundle = new Bundle();
        if (this.bundle != null) {
            Worker.post((Job)new Job(){

                public Object run() {
                    X10flash flash = null;
                    try {
                        FlasherGUI.this.bundle.setSimulate(GlobalConfig.getProperty("simulate").toLowerCase().equals("yes"));
                        flash = new X10flash(FlasherGUI.this.bundle);
                        MyLogger.getLogger().info((Object)"Please connect your device into flashmode.");
                        if (new WaitDeviceFlashmodeGUI(flash).deviceFound(_root)) {
                            flash.openDevice();
                            flash.sendLoader();
                            flash.openTA(2);
                            Vector<TaEntry> v = flash.dumpProperties();
                            if (v.size() > 0) {
                                TaEditor edit = new TaEditor(flash, v);
                                edit.setVisible(true);
                                flash.closeTA();
                                flash.closeDevice();
                            }
                        }
                    }
                    catch (Exception e) {
                        MyLogger.getLogger().error((Object)e.getMessage());
                    }
                    FlasherGUI.this.bundle.close();
                    return null;
                }
            });
        }
    }

    public void BackupRestore() throws Exception {
        TaModeSelectGUI tamode = new TaModeSelectGUI();
        String select = tamode.selectMode();
        if (select.equals("backup")) {
            this.doBackupTa();
        }
        if (select.equals("restore")) {
            this.doRestoreTa();
        }
    }

    public void doBackupTa() throws Exception {
        this.bundle = new Bundle();
        if (this.bundle != null) {
            Worker.post((Job)new Job(){

                public Object run() {
                    X10flash flash = null;
                    try {
                        FlasherGUI.this.bundle.setSimulate(GlobalConfig.getProperty("simulate").toLowerCase().equals("yes"));
                        flash = new X10flash(FlasherGUI.this.bundle);
                        MyLogger.getLogger().info((Object)"Please connect your device into flashmode.");
                        if (new WaitDeviceFlashmodeGUI(flash).deviceFound(_root)) {
                            flash.openDevice();
                            flash.sendLoader();
                            flash.BackupTA();
                            flash.closeDevice();
                            MyLogger.getLogger().info((Object)"Dumping TA finished.");
                        }
                    }
                    catch (Exception e) {
                        MyLogger.getLogger().error((Object)e.getMessage());
                    }
                    FlasherGUI.this.bundle.close();
                    return null;
                }
            });
        }
    }

    public void doRestoreTa() throws Exception {
        this.bundle = new Bundle();
        if (this.bundle != null) {
            Worker.post((Job)new Job(){

                public Object run() {
                    X10flash flash = null;
                    try {
                        FlasherGUI.this.bundle.setSimulate(GlobalConfig.getProperty("simulate").toLowerCase().equals("yes"));
                        flash = new X10flash(FlasherGUI.this.bundle);
                        MyLogger.getLogger().info((Object)"Please connect your device into flashmode.");
                        if (new WaitDeviceFlashmodeGUI(flash).deviceFound(_root)) {
                            flash.openDevice();
                            flash.sendLoader();
                            TaSelectGUI tasel = new TaSelectGUI(".ta", flash.getPhoneProperty("MSN"));
                            String result = tasel.getTa();
                            if (result.length() > 0) {
                                String tafile = String.valueOf(OS.getWorkDir()) + "/custom/ta/" + result;
                                flash.RestoreTA(tafile);
                                flash.closeDevice();
                                MyLogger.getLogger().info((Object)"TA Operation finished.");
                            } else {
                                MyLogger.getLogger().info((Object)"Action canceled");
                            }
                            flash.closeDevice();
                        }
                    }
                    catch (Exception e) {
                        MyLogger.getLogger().error((Object)e.getMessage());
                    }
                    FlasherGUI.this.bundle.close();
                    return null;
                }
            });
        }
    }

    public void doFlash() throws Exception {
        BootModeSelectGUI bootmode = new BootModeSelectGUI();
        String select = bootmode.selectMode();
        if (select.equals("flashmode")) {
            this.doFlashmode("", "");
        }
        if (select.equals("fastboot")) {
            this.doFastBoot();
        }
    }

    public void doFastBoot() throws Exception {
        FastBootToolboxGUI box = new FastBootToolboxGUI();
        box.setVisible(true);
    }

    public void doFlashmode(String pftfpath, String pftfname) throws Exception {
        this.ftfpath = pftfpath;
        this.ftfname = pftfname;
        Worker.post((Job)new Job(){

            public Object run() {
                firmSelect sel = new firmSelect(FlasherGUI.this.ftfpath, FlasherGUI.this.ftfname);
                try {
                    FlasherGUI.this.bundle = sel.getBundle();
                }
                catch (IOException ioe) {
                    FlasherGUI.this.bundle = null;
                }
                if (FlasherGUI.this.bundle != null) {
                    X10flash flash = null;
                    try {
                        MyLogger.getLogger().info((Object)"Preparing files for flashing");
                        FlasherGUI.this.bundle.open();
                        FlasherGUI.this.bundle.setSimulate(GlobalConfig.getProperty("simulate").toLowerCase().equals("yes"));
                        flash = new X10flash(FlasherGUI.this.bundle);
                        MyLogger.getLogger().info((Object)"Please connect your device into flashmode.");
                        if (new WaitDeviceFlashmodeGUI(flash).deviceFound(_root)) {
                            try {
                                flash.openDevice();
                                flash.flashDevice();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            MyLogger.getLogger().info((Object)"Flash canceled");
                        }
                    }
                    catch (BundleException ioe) {
                        MyLogger.getLogger().error((Object)"Error preparing files");
                    }
                    catch (Exception e) {
                        MyLogger.getLogger().error((Object)e.getMessage());
                    }
                    FlasherGUI.this.bundle.close();
                } else {
                    MyLogger.getLogger().info((Object)"Flash canceled");
                }
                return null;
            }
        });
    }

    public void doRoot() {
        if (Devices.getCurrent().getVersion().contains("2.3")) {
            this.doRootzergRush();
        } else if (!Devices.getCurrent().getVersion().contains("4.0") && !Devices.getCurrent().getVersion().contains("4.1")) {
            this.doRootpsneuter();
        } else if (Devices.getCurrent().getVersion().contains("4.0.3")) {
            this.doRootEmulator();
        } else if (Devices.getCurrent().getVersion().contains("4.0")) {
            this.doRootAdbRestore();
        } else {
            JOptionPane.showMessageDialog(null, "No root exploit for this version");
        }
    }

    public void doPushRootFiles(String rootpackage, boolean direct) throws Exception {
        if (!direct) {
            AdbUtility.push(Devices.getCurrent().getBusybox(false), String.valueOf(GlobalConfig.getProperty("deviceworkdir")) + "/busybox");
            AdbUtility.push(String.valueOf(OS.getWorkDir()) + File.separator + "custom" + File.separator + "root" + File.separator + "subin" + File.separator + rootpackage + File.separator + "su", String.valueOf(GlobalConfig.getProperty("deviceworkdir")) + "/su");
            AdbUtility.push(String.valueOf(OS.getWorkDir()) + File.separator + "custom" + File.separator + "root" + File.separator + "subin" + File.separator + rootpackage + File.separator + "Superuser.apk", String.valueOf(GlobalConfig.getProperty("deviceworkdir")) + "/Superuser.apk");
            AdbUtility.run("chown shell.shell " + GlobalConfig.getProperty("deviceworkdir") + "/busybox && chmod 755 " + GlobalConfig.getProperty("deviceworkdir") + "/busybox", true);
        } else {
            AdbUtility.push(Devices.getCurrent().getBusybox(false), "/system/xbin");
            AdbUtility.push(String.valueOf(OS.getWorkDir()) + File.separator + "custom" + File.separator + "root" + File.separator + "subin" + File.separator + rootpackage + File.separator + "su", "/system/xbin");
            AdbUtility.push(String.valueOf(OS.getWorkDir()) + File.separator + "custom" + File.separator + "root" + File.separator + "subin" + File.separator + rootpackage + File.separator + "Superuser.apk", "/system/app");
            AdbUtility.run("chown root.shell /system/xbin/su");
            AdbUtility.run("chmod 06755 /system/xbin/su");
            AdbUtility.run("chown root.shell /system/xbin/busybox");
            AdbUtility.run("chmod 755 /system/xbin/busybox");
        }
    }

    public void doInstallRootFiles() throws Exception {
        AdbUtility.run(String.valueOf(GlobalConfig.getProperty("deviceworkdir")) + "/busybox mount -o remount,rw /system && /data/local/tmp/busybox mv /data/local/tmp/su /system/xbin/su && /data/local/tmp/busybox mv /data/local/tmp/Superuser.apk /system/app/Superuser.apk && /data/local/tmp/busybox cp /data/local/tmp/busybox /system/xbin/busybox && chown root.root /system/xbin/su && chmod 06755 /system/xbin/su && chmod 655 /system/app/Superuser.apk && chmod 755 /system/xbin/busybox && rm /data/local.prop && reboot");
    }

    public void doRootAdbRestore() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    RootPackageSelect sel = new RootPackageSelect();
                    String pck = sel.getResult();
                    if (pck.length() > 0) {
                        FlasherGUI.this.doPushRootFiles(pck, false);
                        String backuppackage = AdbUtility.run("pm list package -f com.sonyericsson.backuprestore");
                        if (backuppackage.contains("backuprestore")) {
                            AdbUtility.push(String.valueOf(OS.getWorkDir()) + File.separator + "custom" + File.separator + "root" + File.separator + "AdbRestore" + File.separator + "RootMe.tar", String.valueOf(GlobalConfig.getProperty("deviceworkdir")) + "/RootMe.tar");
                            AdbUtility.run("mkdir /mnt/sdcard/.semc-fullbackup > /dev/null 2>&1");
                            AdbUtility.run("rm -r /mnt/sdcard/.semc-fullbackup/RootMe* > /dev/null 2>&1");
                            AdbUtility.run("cd /mnt/sdcard/.semc-fullbackup;/data/local/tmp/busybox tar xf /data/local/tmp/RootMe.tar");
                            AdbUtility.run("am start com.sonyericsson.vendor.backuprestore/.ui.BackupActivity");
                            MyLogger.getLogger().info((Object)"Now open your device and restore \"RootMe\" backup. Waiting ...");
                        } else {
                            AdbUtility.restore(String.valueOf(OS.getWorkDir()) + File.separator + "custom" + File.separator + "root" + File.separator + "AdbRestore" + File.separator + "fakebackup.ab");
                            MyLogger.getLogger().info((Object)"Please look at your device and click RESTORE!");
                        }
                        String delay = "60";
                        MyLogger.getLogger().info((Object)("You have " + delay + " seconds to follow the restore advice"));
                        Shell exploit = new Shell("adbrestoreexploit");
                        exploit.setProperty("DELAY", delay);
                        String result = exploit.run(false);
                        if (result.contains("Success")) {
                            MyLogger.getLogger().info((Object)"Restore worked fine. Rebooting device. Please wait ...");
                            Devices.getCurrent().reboot();
                            Devices.waitForReboot(false);
                            if (AdbUtility.hasRootNative(true)) {
                                MyLogger.getLogger().info((Object)"Root achieved. Installing root files. Device will reboot. Please wait.");
                                FlasherGUI.this.doInstallRootFiles();
                                Devices.waitForReboot(false);
                                MyLogger.getLogger().info((Object)"Cleaning hack files");
                                AdbUtility.run("rm /data/local/tmp/busybox;rm -r /mnt/sdcard/.semc-fullbackup/RootMe;rm /data/local/tmp/RootMe.tar;rm /data/local/tmp/su;rm /data/local/tmp/Superuser.apk;rm /data/local/tmp/adbrestoreexploit");
                                MyLogger.getLogger().info((Object)"Finished.");
                            } else {
                                MyLogger.getLogger().info((Object)"Root hack did not work.");
                                MyLogger.getLogger().info((Object)"Cleaning hack files");
                                AdbUtility.run("rm /data/local/tmp/busybox;rm -r /mnt/sdcard/.semc-fullbackup/RootMe;rm /data/local/tmp/RootMe.tar;rm /data/local/tmp/su;rm /data/local/tmp/Superuser.apk;rm /data/local/tmp/adbrestoreexploit");
                            }
                            MyLogger.getLogger().info((Object)"Rebooting device. Please wait.");
                            Devices.getCurrent().reboot();
                        } else {
                            MyLogger.getLogger().info((Object)"Root hack did not work. Cleaning hack files");
                            AdbUtility.run("rm /data/local/tmp/busybox;rm -r /mnt/sdcard/.semc-fullbackup/RootMe;rm /data/local/tmp/RootMe.tar;rm /data/local/tmp/su;rm /data/local/tmp/Superuser.apk;rm /data/local/tmp/adbrestoreexploit");
                        }
                    } else {
                        MyLogger.getLogger().info((Object)"Canceled");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void doUnroot() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    MyLogger.getLogger().info((Object)"Unrooting device. Once done, device will reboot");
                    AdbUtility.run("pm list packages -f>/data/local/tmp/listpackages");
                    AdbUtility.push(Devices.getCurrent().getBusybox(false), String.valueOf(GlobalConfig.getProperty("deviceworkdir")) + "/busybox");
                    AdbUtility.run("chown shell.shell " + GlobalConfig.getProperty("deviceworkdir") + "/busybox && chmod 755 " + GlobalConfig.getProperty("deviceworkdir") + "/busybox", true);
                    Shell unroot = new Shell("unroot");
                    unroot.runRoot();
                    String supersu = APKUtility.getPackageName(String.valueOf(OS.getWorkDir()) + File.separator + "custom" + File.separator + "root" + File.separator + "subin" + File.separator + "Supersu" + File.separator + "Superuser.apk");
                    String superuser = APKUtility.getPackageName(String.valueOf(OS.getWorkDir()) + File.separator + "custom" + File.separator + "root" + File.separator + "subin" + File.separator + "Superuser" + File.separator + "Superuser.apk");
                    AdbUtility.run("pm uninstall " + supersu);
                    AdbUtility.run("pm uninstall " + superuser);
                    AdbUtility.resetRoot();
                    Devices.getCurrent().reboot();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    public void doRootEmulator() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    RootPackageSelect sel = new RootPackageSelect();
                    String pck = sel.getResult();
                    if (pck.length() > 0) {
                        MyLogger.getLogger().info((Object)"Preparing first part of the hack");
                        AdbUtility.run("cd /data/local && mkdir tmp");
                        AdbUtility.run("cd /data/local/tmp/ && rm *");
                        AdbUtility.run("mv /data/local/tmp /data/local/tmp.bak");
                        AdbUtility.run("ln -s /data /data/local/tmp");
                        MyLogger.getLogger().info((Object)"Rebooting device. Please wait");
                        Devices.getCurrent().reboot();
                        Devices.waitForReboot(false);
                        MyLogger.getLogger().info((Object)"Preparing second part of the hack");
                        AdbUtility.run("rm /data/local.prop");
                        AdbUtility.run("echo \"ro.kernel.qemu=1\" > /data/local.prop");
                        MyLogger.getLogger().info((Object)"Rebooting device. Please wait");
                        Devices.getCurrent().reboot();
                        Devices.waitForReboot(false);
                        if (AdbUtility.hasRootNative(true)) {
                            MyLogger.getLogger().info((Object)"Now you have root");
                            MyLogger.getLogger().info((Object)"Remounting system r/w");
                            AdbUtility.run("mount -o remount,rw /system");
                            MyLogger.getLogger().info((Object)"Installing root package");
                            FlasherGUI.this.doPushRootFiles(pck, true);
                            MyLogger.getLogger().info((Object)"Cleaning hack");
                            AdbUtility.run("rm /data/local.prop");
                            AdbUtility.run("rm /data/local/tmp");
                            AdbUtility.run("mv /data/local/tmp.bak /data/local/tmp");
                            MyLogger.getLogger().info((Object)"Rebooting device. Please wait. Your device is now rooted");
                            Devices.getCurrent().reboot();
                        } else {
                            AdbUtility.run("rm /data/local.prop");
                            AdbUtility.run("rm /data/local/tmp");
                            AdbUtility.run("mv /data/local/tmp.bak /data/local/tmp");
                            MyLogger.getLogger().info((Object)"Hack did not work. Cleaning and rebooting");
                            Devices.getCurrent().reboot();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    public void doRootzergRush() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    RootPackageSelect sel = new RootPackageSelect();
                    String pck = sel.getResult();
                    if (pck.length() > 0) {
                        OS.decrypt(new File(String.valueOf(OS.getWorkDir()) + File.separator + "custom" + File.separator + "root" + File.separator + "ZergRush" + File.separator + "zergrush.tar.uue.enc"));
                        AdbUtility.push(String.valueOf(OS.getWorkDir()) + File.separator + "custom" + File.separator + "root" + File.separator + "ZergRush" + File.separator + "zergrush.tar.uue", GlobalConfig.getProperty("deviceworkdir"));
                        new File(String.valueOf(OS.getWorkDir()) + File.separator + "custom" + File.separator + "root" + File.separator + "ZergRush" + File.separator + "zergrush.tar.uue").delete();
                        FlasherGUI.this.doPushRootFiles(pck, false);
                        Shell shell = new Shell("rootit");
                        MyLogger.getLogger().info((Object)"Running part1 of Root Exploit, please wait");
                        shell.run(true);
                        Devices.waitForReboot(true);
                        if (AdbUtility.hasRootNative(true)) {
                            MyLogger.getLogger().info((Object)"Running part2 of Root Exploit");
                            shell = new Shell("rootit2");
                            shell.run(false);
                            MyLogger.getLogger().info((Object)"Finished!.");
                            MyLogger.getLogger().info((Object)"Root should be available after reboot!");
                        } else {
                            MyLogger.getLogger().error((Object)"The part1 exploit did not work");
                            MyLogger.getLogger().info((Object)"Cleaning files");
                            AdbUtility.run("rm /data/local/tmp/zergrush");
                            AdbUtility.run("rm /data/local/tmp/busybox");
                            AdbUtility.run("rm /data/local/tmp/Superuser.apk");
                            AdbUtility.run("rm /data/local/tmp/su");
                            AdbUtility.run("rm /data/local/tmp/rootit");
                            AdbUtility.run("rm /data/local/tmp/rootit2");
                        }
                    }
                }
                catch (Exception e) {
                    MyLogger.getLogger().error((Object)e.getMessage());
                }
                return null;
            }
        });
    }

    public void doRootpsneuter() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    RootPackageSelect sel = new RootPackageSelect();
                    String pck = sel.getResult();
                    if (pck.length() > 0) {
                        OS.decrypt(new File(String.valueOf(OS.getWorkDir()) + File.separator + "custom" + File.separator + "root" + File.separator + "PsNeuter" + File.separator + "psneuter.tar.uue.enc"));
                        AdbUtility.push(String.valueOf(OS.getWorkDir()) + File.separator + "custom" + File.separator + "root" + File.separator + "PsNeuter" + File.separator + "psneuter.tar.uue", GlobalConfig.getProperty("deviceworkdir"));
                        new File(String.valueOf(OS.getWorkDir()) + File.separator + "custom" + File.separator + "root" + File.separator + "PsNeuter" + File.separator + "psneuter.tar.uue").delete();
                        FlasherGUI.this.doPushRootFiles(pck, false);
                        Shell shell = new Shell("rootit");
                        MyLogger.getLogger().info((Object)"Running part1 of Root Exploit, please wait");
                        shell.run(false);
                        Devices.waitForReboot(true);
                        if (AdbUtility.hasRootNative(true)) {
                            MyLogger.getLogger().info((Object)"Running part2 of Root Exploit");
                            shell = new Shell("rootit2");
                            shell.run(false);
                            MyLogger.getLogger().info((Object)"Finished!.");
                            MyLogger.getLogger().info((Object)"Root should be available after reboot!");
                        } else {
                            MyLogger.getLogger().error((Object)"The part1 exploit did not work");
                            MyLogger.getLogger().info((Object)"Cleaning files");
                            AdbUtility.run("rm /data/local/tmp/psneuter");
                            AdbUtility.run("rm /data/local/tmp/busybox");
                            AdbUtility.run("rm /data/local/tmp/Superuser.apk");
                            AdbUtility.run("rm /data/local/tmp/su");
                            AdbUtility.run("rm /data/local/tmp/rootit");
                            AdbUtility.run("rm /data/local/tmp/rootit2");
                        }
                    }
                }
                catch (Exception e) {
                    MyLogger.getLogger().error((Object)e.getMessage());
                }
                return null;
            }
        });
    }

    public void doCustomize() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    ApkInstallGUI instgui = new ApkInstallGUI("." + fsep + "custom" + fsep + "apps");
                    String folder = instgui.getFolder();
                    if (folder.length() > 0) {
                        File files = new File(folder);
                        File[] chld = files.listFiles();
                        int i = 0;
                        while (i < chld.length) {
                            if (chld[i].getName().endsWith(".apk")) {
                                AdbUtility.install(chld[i].getPath());
                            }
                            ++i;
                        }
                        MyLogger.getLogger().info((Object)"APK Installation finished");
                    } else {
                        MyLogger.getLogger().info((Object)"APK Installation canceled");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void doRebrand() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    Devices.getCurrent().doBusyboxHelper();
                    if (AdbUtility.Sysremountrw()) {
                        AdbUtility.pull("/system/build.prop", String.valueOf(Devices.getCurrent().getWorkDir()) + fsep + "build.prop");
                        CommentedPropertiesFile build = new CommentedPropertiesFile();
                        build.load(new File(String.valueOf(Devices.getCurrent().getWorkDir()) + fsep + "build.prop"));
                        String current = build.getProperty("ro.semc.version.cust");
                        if (current != null) {
                            rebrandGUI gui = new rebrandGUI(current);
                            String newid = gui.getId();
                            if (newid.length() > 0) {
                                build.store(new FileOutputStream(new File(String.valueOf(Devices.getCurrent().getWorkDir()) + fsep + "buildnew.prop")), "");
                                TextFile tf = new TextFile(String.valueOf(Devices.getCurrent().getWorkDir()) + fsep + "buildnew.prop", "ISO-8859-1");
                                tf.setProperty(current, newid);
                                AdbUtility.push(String.valueOf(Devices.getCurrent().getWorkDir()) + fsep + "buildnew.prop", String.valueOf(GlobalConfig.getProperty("deviceworkdir")) + "/build.prop");
                                Shell shell = new Shell("rebrand");
                                shell.runRoot();
                                MyLogger.getLogger().info((Object)"Rebrand finished. Rebooting phone ...");
                            }
                        } else {
                            MyLogger.getLogger().error((Object)"You are not on a stock ROM");
                        }
                    } else {
                        MyLogger.getLogger().error((Object)"Error mounting /system rw");
                    }
                }
                catch (Exception e) {
                    MyLogger.getLogger().error((Object)e.getMessage());
                }
                return null;
            }
        });
    }

    public void doCleanRoot() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    Devices.getCurrent().doBusyboxHelper();
                    if (AdbUtility.Sysremountrw()) {
                        Iterator<String> i;
                        TextFile t;
                        apkClean sel = new apkClean();
                        sel.setVisible(true);
                        boolean somethingdone = false;
                        if (TextFile.exists(String.valueOf(OS.getWorkDir()) + fsep + "custom" + fsep + "clean" + fsep + "listappsadd")) {
                            t = new TextFile(String.valueOf(OS.getWorkDir()) + fsep + "custom" + fsep + "clean" + fsep + "listappsadd", "ASCII");
                            i = t.getLines().iterator();
                            while (i.hasNext()) {
                                if (TextFile.exists(String.valueOf(OS.getWorkDir()) + fsep + "custom" + fsep + "apps_saved" + File.separator + Devices.getCurrent().getId() + fsep + i.next())) continue;
                                t.close();
                                throw new Exception("File " + OS.getWorkDir() + fsep + "custom" + fsep + "apps_saved" + File.separator + Devices.getCurrent().getId() + fsep + i.next() + " does not exist");
                            }
                            t.close();
                            AdbUtility.push(String.valueOf(OS.getWorkDir()) + fsep + "custom" + fsep + "clean" + fsep + "listappsadd", GlobalConfig.getProperty("deviceworkdir"));
                            t = new TextFile(String.valueOf(OS.getWorkDir()) + fsep + "custom" + fsep + "clean" + fsep + "listappsadd", "ASCII");
                            i = t.getLines().iterator();
                            while (i.hasNext()) {
                                AdbUtility.push(String.valueOf(OS.getWorkDir()) + fsep + "custom" + fsep + "apps_saved" + File.separator + Devices.getCurrent().getId() + fsep + i.next(), GlobalConfig.getProperty("deviceworkdir"));
                            }
                            t.delete();
                            Devices.getCurrent().doBusyboxHelper();
                            Shell shell1 = new Shell("sysadd");
                            shell1.runRoot();
                            somethingdone = true;
                        }
                        if (TextFile.exists(String.valueOf(OS.getWorkDir()) + fsep + "custom" + fsep + "clean" + fsep + "listappsremove")) {
                            AdbUtility.push(String.valueOf(OS.getWorkDir()) + fsep + "custom" + fsep + "clean" + fsep + "listappsremove", GlobalConfig.getProperty("deviceworkdir"));
                            t = new TextFile(String.valueOf(OS.getWorkDir()) + fsep + "custom" + fsep + "clean" + fsep + "listappsremove", "ASCII");
                            i = t.getLines().iterator();
                            while (i.hasNext()) {
                                AdbUtility.pull("/system/app/" + i.next(), String.valueOf(OS.getWorkDir()) + fsep + "custom" + fsep + "apps_saved" + File.separator + Devices.getCurrent().getId());
                            }
                            Devices.getCurrent().doBusyboxHelper();
                            Shell shell2 = new Shell("sysremove");
                            shell2.runRoot();
                            for (String file : t.getLines()) {
                                if (!file.endsWith("apk")) continue;
                                String pckname = APKUtility.getPackageName(String.valueOf(OS.getWorkDir()) + fsep + "custom" + fsep + "apps_saved" + File.separator + Devices.getCurrent().getId() + File.separator + file);
                                MyLogger.getLogger().info((Object)("Removing " + pckname + " from device"));
                                AdbUtility.uninstall(pckname, true);
                            }
                            t.delete();
                            somethingdone = true;
                        }
                        if (somethingdone) {
                            AdbUtility.clearcache();
                            MyLogger.getLogger().info((Object)"Clean finished. Rebooting phone ...");
                        } else {
                            MyLogger.getLogger().info((Object)"Clean canceled");
                        }
                    } else {
                        MyLogger.getLogger().info((Object)"Error mounting /system rw");
                    }
                }
                catch (Exception e) {
                    MyLogger.getLogger().error((Object)e.getMessage());
                }
                return null;
            }
        });
    }

    public void doRebootRecoveryT() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    Devices.getCurrent().rebootSelectedRecovery();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void doSetDefaultRecovery() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    Devices.getCurrent().setDefaultRecovery();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void doSetDefaultKernel() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    KernelBootSelectGUI rsel = new KernelBootSelectGUI();
                    String current = rsel.getVersion();
                    if (current.length() > 0 && AdbUtility.Sysremountrw()) {
                        MyLogger.getLogger().info((Object)"Setting default kernel");
                        Shell shell = new Shell("setdefaultkernel");
                        shell.setProperty("KERNELTOBOOT", current);
                        shell.runRoot();
                        MyLogger.getLogger().info((Object)"Done");
                    }
                }
                catch (Exception e) {
                    MyLogger.getLogger().error((Object)e.getMessage());
                }
                return null;
            }
        });
    }

    public void doRebootRecovery() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    MyLogger.getLogger().info((Object)"Rebooting into recovery mode");
                    Shell shell = new Shell("rebootrecovery");
                    shell.runRoot();
                    MyLogger.getLogger().info((Object)"Phone will reboot into recovery mode");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void doRebootKexec() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    KernelBootSelectGUI ksel = new KernelBootSelectGUI();
                    String current = ksel.getVersion();
                    if (current.length() > 0) {
                        MyLogger.getLogger().info((Object)"Rebooting into kexec mode");
                        Shell shell = new Shell("rebootkexect");
                        shell.setProperty("KERNELTOBOOT", current);
                        shell.runRoot();
                        MyLogger.getLogger().info((Object)"Phone will reboot into kexec mode");
                    } else {
                        MyLogger.getLogger().info((Object)"Reboot canceled");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void doReboot() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    MyLogger.getLogger().info((Object)"Rebooting into stock mode");
                    Shell shell = new Shell("reboot");
                    shell.runRoot();
                    MyLogger.getLogger().info((Object)"Phone will reboot now");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void doInstallXRecovery() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    MyLogger.getLogger().info((Object)"Installing Recovery to device...");
                    Devices.getCurrent().doBusyboxHelper();
                    if (AdbUtility.Sysremountrw()) {
                        RecoverySelectGUI sel = new RecoverySelectGUI(Devices.getCurrent().getId());
                        String selVersion = sel.getVersion();
                        if (selVersion.length() > 0) {
                            FlasherGUI.this.doInstallCustKit();
                            AdbUtility.push("./devices/" + Devices.getCurrent().getId() + "/recovery/" + selVersion + "/recovery.tar", String.valueOf(GlobalConfig.getProperty("deviceworkdir")) + "/recovery.tar");
                            Shell shell = new Shell("installrecovery");
                            shell.runRoot();
                            MyLogger.getLogger().info((Object)"Recovery successfully installed");
                        } else {
                            MyLogger.getLogger().info((Object)"Canceled");
                        }
                    } else {
                        MyLogger.getLogger().error((Object)"Error mounting /system rw");
                    }
                }
                catch (Exception e) {
                    MyLogger.getLogger().error((Object)e.getMessage());
                }
                return null;
            }
        });
    }

    public void doEncDec() {
        Worker.post((Job)new Job(){

            public Object run() {
                EncDecGUI encdec = new EncDecGUI();
                encdec.setVisible(true);
                Object[] list = encdec.getList();
                if (list != null) {
                    String folder = null;
                    int i = 0;
                    while (i < list.length) {
                        MyLogger.getLogger().info((Object)("Decrypting " + list[i]));
                        folder = ((EncDecGUI.MyFile)list[i]).getParent();
                        SeusSinTool.decrypt(((EncDecGUI.MyFile)list[i]).getAbsolutePath());
                        ++i;
                    }
                    MyLogger.getLogger().info((Object)"Decryption finished");
                    try {
                        BundleGUI bcre = new BundleGUI(folder);
                        Bundle b2 = bcre.getBundle("flashmode");
                        if (b2 != null) {
                            MyLogger.getLogger().info((Object)"Starting bundle creation");
                            b2.createFTF();
                            MyLogger.getLogger().info((Object)"Finished bundle creation");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
    }

    public void doInstallBusyBox() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    String busybox = Devices.getCurrent().getBusybox(true);
                    if (busybox.length() > 0) {
                        AdbUtility.push(busybox, GlobalConfig.getProperty("deviceworkdir"));
                        Shell shell = new Shell("busyhelper");
                        shell.run(false);
                        shell = new Shell("instbusybox");
                        shell.setProperty("BUSYBOXINSTALLPATH", Devices.getCurrent().getBusyBoxInstallPath());
                        shell.runRoot();
                        MyLogger.getLogger().info((Object)("Installed version of busybox : " + Devices.getCurrent().getInstalledBusyboxVersion(true)));
                        MyLogger.getLogger().info((Object)"Finished");
                    } else {
                        MyLogger.getLogger().info((Object)"Busybox installation canceled");
                    }
                }
                catch (Exception e) {
                    MyLogger.getLogger().error((Object)e.getMessage());
                }
                return null;
            }
        });
    }

    public void doClearCache() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    AdbUtility.clearcache();
                    MyLogger.getLogger().info((Object)"Finished. Device will come back online. Please wait.");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void doConnectPaypal() {
        this.showInBrowser("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=PPWH7M9MNCEPA");
    }

    private boolean showInBrowser(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public void doDisableIdent() {
        if (guimode) {
            this.btnCleanroot.setEnabled(false);
            this.mntmInstallBusybox.setEnabled(false);
            this.mntmClearCache.setEnabled(false);
            this.mntmRootzergRush.setEnabled(false);
            this.mntmRootPsneuter.setEnabled(false);
            this.mntmRootEmulator.setEnabled(false);
            this.mntmRootAdbRestore.setEnabled(false);
            this.mntmUnRoot.setEnabled(false);
            this.mntmBuildpropEditor.setEnabled(false);
            this.mntmBuildpropRebrand.setEnabled(false);
            this.mntmRebootIntoRecoveryT.setEnabled(false);
            this.mntmRebootDefaultRecovery.setEnabled(false);
            this.mntmSetDefaultRecovery.setEnabled(false);
            this.mntmSetDefaultKernel.setEnabled(false);
            this.mntmRebootCustomKernel.setEnabled(false);
            this.mntmRebootDefaultKernel.setEnabled(false);
            this.btnRoot.setEnabled(false);
            this.btnXrecovery.setEnabled(false);
            this.btnKernel.setEnabled(false);
            this.btnAskRootPerms.setEnabled(false);
            this.custBtn.setEnabled(false);
            this.mntmBackupSystemApps.setEnabled(false);
        }
    }

    public void doIdent() {
        if (guimode) {
            Enumeration<Object> e = Devices.listDevices(true);
            if (!e.hasMoreElements()) {
                MyLogger.getLogger().error((Object)"No device is registered in Flashtool.");
                MyLogger.getLogger().error((Object)"You can only flash devices.");
                return;
            }
            boolean found = false;
            Properties founditems = new Properties();
            founditems.clear();
            Properties buildprop = new Properties();
            buildprop.clear();
            while (e.hasMoreElements()) {
                DeviceEntry current = Devices.getDevice((String)e.nextElement());
                String prop = current.getBuildProp();
                if (!buildprop.containsKey(prop)) {
                    String readprop = DeviceProperties.getProperty(prop);
                    buildprop.setProperty(prop, readprop);
                }
                Iterator<String> i = current.getRecognitionList().iterator();
                String localdev = buildprop.getProperty(prop);
                while (i.hasNext()) {
                    String pattern = i.next().toUpperCase();
                    if (!localdev.toUpperCase().equals(pattern)) continue;
                    founditems.put(current.getId(), current.getName());
                }
            }
            if (founditems.size() == 1) {
                found = true;
                Devices.setCurrent((String)founditems.keys().nextElement());
                if (!Devices.isWaitingForReboot()) {
                    MyLogger.getLogger().info((Object)("Connected device : " + Devices.getCurrent().getId()));
                }
            } else {
                MyLogger.getLogger().error((Object)"Cannot identify your device.");
                MyLogger.getLogger().info((Object)"Selecting from user input");
                String devid = "";
                deviceSelectGui devsel = new deviceSelectGui(null);
                devid = devsel.getDevice(founditems);
                if (devid.length() > 0) {
                    String reply;
                    found = true;
                    Devices.setCurrent(devid);
                    String prop = DeviceProperties.getProperty(Devices.getCurrent().getBuildProp());
                    if (!Devices.getCurrent().getRecognition().contains(prop) && (reply = AskBox.getReplyOf("Do you want to permanently identify this device as \n" + Devices.getCurrent().getName() + "?")).equals("yes")) {
                        Devices.getCurrent().addRecognitionToList(prop);
                    }
                    if (!Devices.isWaitingForReboot()) {
                        MyLogger.getLogger().info((Object)("Connected device : " + Devices.getCurrent().getId()));
                    }
                } else {
                    MyLogger.getLogger().error((Object)"You can only flash devices.");
                }
            }
            if (found) {
                if (!Devices.isWaitingForReboot()) {
                    MyLogger.getLogger().info((Object)("Installed version of busybox : " + Devices.getCurrent().getInstalledBusyboxVersion(false)));
                    MyLogger.getLogger().info((Object)("Android version : " + Devices.getCurrent().getVersion() + " / kernel version : " + Devices.getCurrent().getKernelVersion() + " / Build number : " + Devices.getCurrent().getBuildId()));
                }
                if (Devices.getCurrent().isRecovery()) {
                    MyLogger.getLogger().info((Object)"Phone in recovery mode");
                    this.btnRoot.setEnabled(false);
                    this.btnAskRootPerms.setEnabled(false);
                    this.doGiveRoot();
                } else {
                    boolean hasSU = Devices.getCurrent().hasSU();
                    this.btnRoot.setEnabled(!hasSU);
                    if (hasSU) {
                        boolean hasRoot = Devices.getCurrent().hasRoot();
                        if (hasRoot) {
                            this.doInstFlashtool();
                            this.doGiveRoot();
                        }
                        this.btnAskRootPerms.setEnabled(!hasRoot);
                    }
                }
                MyLogger.getLogger().debug((Object)"Now setting buttons availability - btnRoot");
                MyLogger.getLogger().debug((Object)"mtmRootzergRush menu");
                this.mntmRootzergRush.setEnabled(true);
                MyLogger.getLogger().debug((Object)"mtmRootPsneuter menu");
                this.mntmRootPsneuter.setEnabled(true);
                MyLogger.getLogger().debug((Object)"mtmRootEmulator menu");
                this.mntmRootEmulator.setEnabled(true);
                MyLogger.getLogger().debug((Object)"mtmRootAdbRestore menu");
                this.mntmRootAdbRestore.setEnabled(true);
                MyLogger.getLogger().debug((Object)"mtmUnRoot menu");
                this.mntmUnRoot.setEnabled(true);
                boolean flash = Devices.getCurrent().canFlash();
                MyLogger.getLogger().debug((Object)("flashBtn button " + flash));
                this.flashBtn.setEnabled(flash);
                MyLogger.getLogger().debug((Object)"custBtn button");
                this.custBtn.setEnabled(true);
                MyLogger.getLogger().debug((Object)"Now adding plugins");
                this.mnPlugins.removeAll();
                this.addDevicesPlugins();
                this.addGenericPlugins();
                MyLogger.getLogger().debug((Object)"Stop waiting for device");
                if (Devices.isWaitingForReboot()) {
                    Devices.stopWaitForReboot();
                }
                MyLogger.getLogger().debug((Object)"End of identification");
            }
        }
        File f = new File(String.valueOf(OS.getWorkDir()) + File.separator + "custom" + File.separator + "apps_saved" + File.separator + Devices.getCurrent().getId());
        f.mkdir();
        f = new File(String.valueOf(OS.getWorkDir()) + File.separator + "custom" + File.separator + "clean" + File.separator + Devices.getCurrent().getId());
        f.mkdir();
    }

    public void doGiveRoot() {
        this.btnCleanroot.setEnabled(true);
        this.mntmInstallBusybox.setEnabled(true);
        this.mntmClearCache.setEnabled(true);
        this.mntmBuildpropEditor.setEnabled(true);
        if (new File(String.valueOf(OS.getWorkDir()) + fsep + "devices" + fsep + Devices.getCurrent().getId() + fsep + "rebrand").isDirectory()) {
            this.mntmBuildpropRebrand.setEnabled(true);
        }
        this.mntmRebootIntoRecoveryT.setEnabled(Devices.getCurrent().canRecovery());
        this.mntmRebootDefaultRecovery.setEnabled(true);
        this.mntmSetDefaultRecovery.setEnabled(Devices.getCurrent().canRecovery());
        this.mntmSetDefaultKernel.setEnabled(Devices.getCurrent().canKernel());
        this.mntmRebootCustomKernel.setEnabled(Devices.getCurrent().canKernel());
        this.mntmRebootDefaultKernel.setEnabled(true);
        this.mntmBackupSystemApps.setEnabled(true);
        this.btnXrecovery.setEnabled(Devices.getCurrent().canRecovery());
        this.btnKernel.setEnabled(Devices.getCurrent().canKernel());
        if (!Devices.isWaitingForReboot()) {
            MyLogger.getLogger().info((Object)"Root Access Allowed");
        }
    }

    public void doAskRoot() {
        Worker.post((Job)new Job(){

            public Object run() {
                MyLogger.getLogger().warn((Object)"Please check your Phone and 'ALLOW' Superuseraccess!");
                if (!AdbUtility.hasRootPerms()) {
                    MyLogger.getLogger().error((Object)"Please Accept root permissions on the phone");
                } else {
                    FlasherGUI.this.doGiveRoot();
                }
                return null;
            }
        });
    }

    public void doBundle() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    BundleGUI bcre = new BundleGUI();
                    Bundle b2 = null;
                    b2 = bcre.getBundle("flashmode");
                    if (b2 != null) {
                        MyLogger.getLogger().info((Object)"Starting bundle creation");
                        b2.createFTF();
                        MyLogger.getLogger().info((Object)"Finished bundle creation");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MyLogger.getLogger().error((Object)e.getMessage());
                }
                return null;
            }
        });
    }

    public void doBackupSystem() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    X10Apps apps = new X10Apps();
                    for (String app : apps.getCurrent()) {
                        try {
                            AdbUtility.pull("/system/app/" + app, "." + fsep + "custom" + fsep + "apps_saved" + File.separator + Devices.getCurrent().getId());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    MyLogger.getLogger().info((Object)"Backup Finished");
                }
                catch (Exception e) {
                    MyLogger.getLogger().error((Object)e.getMessage());
                }
                return null;
            }
        });
    }

    public void doInstallCustKit() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    MyLogger.getLogger().info((Object)"Installing chargemon feature / kernel bootkit to device...");
                    Devices.getCurrent().doBusyboxHelper();
                    if (AdbUtility.Sysremountrw()) {
                        AdbUtility.push("." + fsep + "devices" + fsep + Devices.getCurrent().getId() + fsep + "bootkit" + fsep + "bootkit.tar", GlobalConfig.getProperty("deviceworkdir"));
                        Shell shell = new Shell("installbootkit");
                        shell.runRoot();
                        MyLogger.getLogger().info((Object)"bootkit successfully installed");
                    } else {
                        MyLogger.getLogger().error((Object)"Error mounting /system rw");
                    }
                }
                catch (Exception e) {
                    MyLogger.getLogger().error((Object)e.getMessage());
                }
                return null;
            }
        });
    }

    public void doInstallKernel() {
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    MyLogger.getLogger().info((Object)"Installing kernel to device...");
                    Devices.getCurrent().doBusyboxHelper();
                    if (AdbUtility.Sysremountrw()) {
                        KernelSelectGUI sel = new KernelSelectGUI(Devices.getCurrent().getId());
                        String selVersion = sel.getVersion();
                        if (selVersion.length() > 0) {
                            FlasherGUI.this.doInstallCustKit();
                            AdbUtility.push("." + fsep + "devices" + fsep + Devices.getCurrent().getId() + fsep + "kernel" + fsep + selVersion + fsep + "kernel.tar", GlobalConfig.getProperty("deviceworkdir"));
                            Shell shell = new Shell("installkernel");
                            shell.runRoot();
                            MyLogger.getLogger().info((Object)"kernel successfully installed");
                        } else {
                            MyLogger.getLogger().info((Object)"Canceled");
                        }
                    } else {
                        MyLogger.getLogger().error((Object)"Error mounting /system rw");
                    }
                }
                catch (Exception e) {
                    MyLogger.getLogger().error((Object)e.getMessage());
                }
                return null;
            }
        });
    }

    public void addDevicesPlugins() {
        try {
            File dir = new File(String.valueOf(Devices.getCurrent().getDeviceDir()) + fsep + "features");
            File[] chld = dir.listFiles();
            MyLogger.getLogger().debug((Object)("Found " + chld.length + " device plugins to add"));
            int i = 0;
            while (i < chld.length) {
                if (chld[i].isDirectory()) {
                    try {
                        Properties p = new Properties();
                        p.load(new FileInputStream(new File(String.valueOf(chld[i].getAbsolutePath()) + fsep + "feature.properties")));
                        MyLogger.getLogger().debug((Object)("Registering " + p.getProperty("classname")));
                        ClassPath.addFile(String.valueOf(chld[i].getAbsolutePath()) + fsep + p.getProperty("plugin"));
                        this.registerPlugin("device", p.getProperty("classname"), chld[i].getAbsolutePath());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addGenericPlugins() {
        try {
            File dir = new File(String.valueOf(OS.getWorkDir()) + fsep + "custom" + fsep + "features");
            File[] chld = dir.listFiles();
            MyLogger.getLogger().debug((Object)("Found " + chld.length + " generic plugins to add"));
            int i = 0;
            while (i < chld.length) {
                if (chld[i].isDirectory()) {
                    try {
                        Properties p = new Properties();
                        p.load(new FileInputStream(new File(String.valueOf(chld[i].getAbsolutePath()) + fsep + "feature.properties")));
                        ClassPath.addFile(String.valueOf(chld[i].getAbsolutePath()) + fsep + p.getProperty("plugin"));
                        this.registerPlugin("generic", p.getProperty("classname"), chld[i].getAbsolutePath());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            MyLogger.getLogger().debug((Object)e.getMessage());
        }
    }

    public void registerPlugin(String type, String classname, String workdir) {
        try {
            MyLogger.getLogger().debug((Object)("Creating instance of " + classname));
            Class<?> pluginClass = Class.forName(classname);
            MyLogger.getLogger().debug((Object)("Getting constructor of " + classname));
            Constructor<?> constr = pluginClass.getConstructor(new Class[0]);
            MyLogger.getLogger().debug((Object)("Now instanciating object of class " + classname));
            PluginInterface pluginObject = (PluginInterface)constr.newInstance(new Object[0]);
            MyLogger.getLogger().debug((Object)"Setting plugin workdir");
            pluginObject.setWorkdir(workdir);
            MyLogger.getLogger().debug((Object)"Now giving rights to plugin");
            boolean aenabled = false;
            String aversion = Devices.getCurrent().getVersion();
            Enumeration<String> e1 = pluginObject.getCompatibleAndroidVersions();
            while (e1.hasMoreElements()) {
                String pversion = e1.nextElement();
                if (!aversion.startsWith(pversion) && !pversion.equals("any")) continue;
                aenabled = true;
            }
            boolean kenabled = false;
            String kversion = Devices.getCurrent().getKernelVersion();
            Enumeration<String> e2 = pluginObject.getCompatibleKernelVersions();
            while (e2.hasMoreElements()) {
                String pversion = e2.nextElement();
                if (!kversion.equals(pversion) && !pversion.equals("any")) continue;
                kenabled = true;
            }
            boolean denabled = false;
            if (type.equals("generic")) {
                String currdevid = Devices.getCurrent().getId();
                Enumeration<String> e3 = pluginObject.getCompatibleDevices();
                while (e3.hasMoreElements()) {
                    String pversion = e3.nextElement();
                    if (!currdevid.equals(pversion) && !pversion.equals("any")) continue;
                    denabled = true;
                }
            } else {
                denabled = true;
            }
            boolean hasroot = false;
            hasroot = pluginObject.isRootNeeded() ? Devices.getCurrent().hasRoot() : true;
            JMenu pluginmenu = new JMenu(pluginObject.getName());
            JMenuItem run = new JMenuItem("Run");
            run.setEnabled(aenabled && kenabled && denabled && hasroot);
            PluginActionListener p = new PluginActionListener(pluginObject);
            run.addActionListener(p);
            JMenuItem about = new JMenuItem("About");
            PluginActionListenerAbout p1 = new PluginActionListenerAbout(pluginObject);
            about.addActionListener(p1);
            pluginmenu.add(run);
            pluginObject.setMenu(pluginmenu);
            pluginmenu.addSeparator();
            pluginmenu.add(about);
            if (type.equals("device") && aenabled && kenabled && denabled && hasroot) {
                JMenu deviceMenu = new JMenu(Devices.getCurrent().getId());
                deviceMenu.add(pluginmenu);
                this.mnPlugins.add(deviceMenu);
            } else if (aenabled && kenabled && denabled && hasroot) {
                this.mnPlugins.add(pluginmenu);
            }
        }
        catch (Exception e) {
            MyLogger.getLogger().error((Object)e.getMessage());
        }
    }

    public void doInstFlashtool() {
        try {
            if (!AdbUtility.exists("/system/flashtool")) {
                Devices.getCurrent().doBusyboxHelper();
                MyLogger.getLogger().info((Object)"Installing toolbox to device...");
                AdbUtility.push(String.valueOf(OS.getWorkDir()) + fsep + "custom" + fsep + "root" + fsep + "ftkit.tar", GlobalConfig.getProperty("deviceworkdir"));
                Shell shell = new Shell("installftkit");
                shell.runRoot();
            }
        }
        catch (Exception e) {
            MyLogger.getLogger().error((Object)e.getMessage());
        }
    }

    public static void doImportDevice(String device) throws Exception {
        File f;
        JarEntry file;
        Enumeration<JarEntry> e;
        File ftd = new File(String.valueOf(OS.getWorkDir()) + OS.getFileSeparator() + "devices" + OS.getFileSeparator() + device + ".ftd");
        String destDir = String.valueOf(OS.getWorkDir()) + File.separator + "devices";
        new File(String.valueOf(destDir) + File.separator + device).mkdir();
        JarFile jar = new JarFile(ftd);
        boolean alldirs = false;
        while (!alldirs) {
            e = jar.entries();
            alldirs = true;
            while (e.hasMoreElements()) {
                file = e.nextElement();
                f = new File(String.valueOf(destDir) + File.separator + file.getName());
                if (!file.isDirectory() || f.exists() || f.mkdir()) continue;
                alldirs = false;
            }
        }
        e = jar.entries();
        while (e.hasMoreElements()) {
            file = e.nextElement();
            f = new File(String.valueOf(destDir) + File.separator + file.getName());
            if (file.isDirectory()) continue;
            InputStream is = jar.getInputStream(file);
            FileOutputStream fos = new FileOutputStream(f);
            while (is.available() > 0) {
                fos.write(is.read());
            }
            fos.close();
            is.close();
        }
    }

    public static void doExportDevice(String device) throws Exception {
        File ftd = new File(String.valueOf(OS.getWorkDir()) + OS.getFileSeparator() + "devices" + OS.getFileSeparator() + device + ".ftd");
        byte[] buffer = new byte[10240];
        FileOutputStream stream = new FileOutputStream(ftd);
        JarOutputStream out = new JarOutputStream(stream);
        out.setLevel(1);
        File root = new File(String.valueOf(OS.getWorkDir()) + OS.getFileSeparator() + "devices" + OS.getFileSeparator() + device);
        int rootindex = root.getAbsolutePath().length();
        Collection<File> c = OS.listFileTree(root);
        for (File entry : c) {
            int nRead;
            String name = entry.getAbsolutePath().substring(rootindex - device.length());
            if (entry.isDirectory()) {
                name = String.valueOf(name) + "/";
            }
            JarEntry jarAdd = new JarEntry(name);
            out.putNextEntry(jarAdd);
            if (entry.isDirectory()) continue;
            FileInputStream in = new FileInputStream(entry);
            while ((nRead = ((InputStream)in).read(buffer, 0, buffer.length)) > 0) {
                out.write(buffer, 0, nRead);
            }
            ((InputStream)in).close();
        }
        out.close();
        stream.close();
    }

    public static void doDeleteDevice(String device) {
        String destDir = String.valueOf(OS.getWorkDir()) + File.separator + "devices" + File.separator + device;
        File folder = new File(destDir);
        FlasherGUI.deleteFolder(folder);
    }

    public static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    FlasherGUI.deleteFolder(f);
                } else {
                    f.delete();
                }
                ++n2;
            }
        }
        folder.delete();
    }

    public String chooseYaffs2() {
        JFileChooser chooser = new JFileChooser(new File("."));
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".yaffs2");
            }

            @Override
            public String getDescription() {
                return "*.yaffs2";
            }
        };
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ff);
        chooser.setDialogTitle("Choose sin file)");
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return "ERROR";
    }
}

