/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import foxtrot.Job;
import foxtrot.Worker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import org.adb.AdbUtility;
import org.adb.FastbootUtility;
import org.lang.Language;
import org.logger.MyLogger;
import org.system.Devices;
import org.system.RunOutputs;

public class FastBootToolboxGUI
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    public static final String version = "1.0";
    public static final String msg1 = "Fastboot Toolbox";
    public static final String msg2 = "by DooMLoRD";

    public FastBootToolboxGUI() {
        this.setResizable(false);
        MyLogger.getLogger().info((Object)"Launching Fastboot Toolbox 1.0 by DooMLoRD");
        this.setTitle(msg1);
        this.setAlwaysOnTop(true);
        this.setBounds(100, 100, 754, 299);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"251px"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"190px"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.UNRELATED_GAP_ROWSPEC, RowSpec.decode((String)"14px"), FormFactory.NARROW_LINE_GAP_ROWSPEC, RowSpec.decode((String)"23px"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"23px"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"23px"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"23px"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"23px")}));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MyLogger.getLogger().info((Object)"Finished Fastboot Toolbox");
                FastBootToolboxGUI.this.dispose();
            }
        });
        JLabel lblVersion = new JLabel("Version 1.0");
        lblVersion.setHorizontalAlignment(0);
        this.contentPanel.add((Component)lblVersion, "2, 2, fill, top");
        JLabel lblFrom = new JLabel(msg2);
        lblFrom.setHorizontalAlignment(0);
        this.contentPanel.add((Component)lblFrom, "6, 2, fill, top");
        JButton btnRebootIntoFastbootADB = new JButton("Reboot into fastboot mode (via ADB)");
        btnRebootIntoFastbootADB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FastBootToolboxGUI.this.adbRebootIntoFastboot();
            }
        });
        this.contentPanel.add((Component)btnRebootIntoFastbootADB, "2, 8, fill, top");
        JButton btnFastbootReboot = new JButton("Reboot device into system");
        btnFastbootReboot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FastBootToolboxGUI.this.fastbootReboot();
            }
        });
        JButton btnSelectSystemTo = new JButton("Select system to Flash");
        btnSelectSystemTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FastBootToolboxGUI.this.flashSystem();
            }
        });
        this.contentPanel.add((Component)btnSelectSystemTo, "4, 10");
        this.contentPanel.add((Component)btnFastbootReboot, "4, 16, fill, fill");
        JButton btnRebootIntoFastbootFB = new JButton("Reboot into fastboot mode (via Fastboot)");
        btnRebootIntoFastbootFB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FastBootToolboxGUI.this.rebootBackIntoFastbootMode();
            }
        });
        this.contentPanel.add((Component)btnRebootIntoFastbootFB, "6, 8, fill, top");
        JButton btnGetDeviceInfo = new JButton("Get Device Info");
        btnGetDeviceInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FastBootToolboxGUI.this.getConnectedDeviceInfo();
            }
        });
        this.contentPanel.add((Component)btnGetDeviceInfo, "6, 12, fill, top");
        JButton btnGetVerInfo = new JButton("Get Ver Info");
        btnGetVerInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FastBootToolboxGUI.this.getFastbootVerInfo();
            }
        });
        this.contentPanel.add((Component)btnGetVerInfo, "2, 12, fill, top");
        JButton btnSelectKernelToHotBoot = new JButton("Select kernel to HotBoot");
        btnSelectKernelToHotBoot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FastBootToolboxGUI.this.hotbootKernel();
            }
        });
        this.contentPanel.add((Component)btnSelectKernelToHotBoot, "2, 10, fill, top");
        JButton btnSelectKernelToFlash = new JButton("Select kernel to Flash");
        btnSelectKernelToFlash.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FastBootToolboxGUI.this.flashKernel();
            }
        });
        this.contentPanel.add((Component)btnSelectKernelToFlash, "6, 10, fill, top");
        JButton btnCheck = new JButton("CHECK Current Device Status");
        btnCheck.setFont(new Font("Dialog", 0, 11));
        this.contentPanel.add((Component)btnCheck, "4, 4, fill, fill");
        btnCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FastBootToolboxGUI.this.checkDeviceStatus();
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MyLogger.getLogger().info((Object)"Finished Fastboot Toolbox");
                FastBootToolboxGUI.this.dispose();
            }
        });
        JLabel lblMoveThisWindow = new JLabel("Move this window to the side so that you are able to see contents of main flashtool log.");
        buttonPane.add(lblMoveThisWindow);
        closeButton.setActionCommand("Close");
        buttonPane.add(closeButton);
        this.getRootPane().setDefaultButton(closeButton);
        this.setDefaultCloseOperation(2);
        this.checkDeviceStatus();
    }

    public void doFactoryReset() {
    }

    public void checkDeviceStatus() {
        String deviceStatus = "NOT FOUND";
        Devices.HasOneFastbootConnected();
        if (AdbUtility.isConnected()) {
            deviceStatus = "ADB mode";
        } else if (FastbootUtility.getDevices().hasMoreElements()) {
            deviceStatus = "FASTBOOT mode";
        }
        MyLogger.getLogger().info((Object)("Device Status: " + deviceStatus));
    }

    public void adbRebootIntoFastboot() {
        if (Devices.HasOneAdbConnected()) {
            if (Devices.getCurrent().canFastboot()) {
                Worker.post((Job)new Job(){

                    public Object run() {
                        MyLogger.getLogger().info((Object)"Please wait device is rebooting into fastboot mode (via ADB)");
                        try {
                            FastbootUtility.adbRebootFastboot();
                            MyLogger.getLogger().info((Object)"Device will soon enter fastboot mode");
                        }
                        catch (Exception e1) {
                            MyLogger.getLogger().error((Object)e1.getMessage());
                        }
                        return null;
                    }
                });
            } else {
                MyLogger.getLogger().error((Object)"This action can be done only if the connected phone has fastboot mode");
            }
        } else {
            MyLogger.getLogger().error((Object)"This action needs a connected device");
        }
    }

    public void fastbootReboot() {
        if (!Devices.HasOneFastbootConnected()) {
            MyLogger.getLogger().error((Object)"This action can only be done in fastboot mode");
            return;
        }
        Worker.post((Job)new Job(){

            public Object run() {
                MyLogger.getLogger().info((Object)"Device will now exit fastboot mode and start booting into system");
                try {
                    FastbootUtility.rebootDevice();
                }
                catch (Exception e1) {
                    MyLogger.getLogger().error((Object)e1.getMessage());
                }
                return null;
            }
        });
    }

    public void rebootBackIntoFastbootMode() {
        if (!Devices.HasOneFastbootConnected()) {
            MyLogger.getLogger().error((Object)"This action can only be done in fastboot mode");
            return;
        }
        Worker.post((Job)new Job(){

            public Object run() {
                MyLogger.getLogger().info((Object)"Please wait device is rebooting into fastboot mode (via Fastboot)");
                try {
                    FastbootUtility.rebootFastboot();
                    MyLogger.getLogger().info((Object)"Device will soon reboot back into fastboot mode");
                }
                catch (Exception e1) {
                    MyLogger.getLogger().error((Object)e1.getMessage());
                }
                return null;
            }
        });
    }

    public void getConnectedDeviceInfo() {
        if (!Devices.HasOneFastbootConnected()) {
            MyLogger.getLogger().error((Object)"This action can only be done in fastboot mode");
            return;
        }
        Worker.post((Job)new Job(){

            public Object run() {
                MyLogger.getLogger().info((Object)"Fetching connected device info");
                try {
                    RunOutputs outputsRun = FastbootUtility.getDeviceInfo();
                    MyLogger.getLogger().info((Object)("Connected device info: [ " + outputsRun.getStdOut().split("fastboot")[0].trim() + " ]"));
                }
                catch (Exception e1) {
                    MyLogger.getLogger().error((Object)e1.getMessage());
                }
                return null;
            }
        });
    }

    public void getFastbootVerInfo() {
        if (!Devices.HasOneFastbootConnected()) {
            MyLogger.getLogger().error((Object)"This action can only be done in fastboot mode");
            return;
        }
        Worker.post((Job)new Job(){

            public Object run() {
                MyLogger.getLogger().info((Object)"Fetching fastboot version info from connected device");
                try {
                    RunOutputs outputsRun = FastbootUtility.getFastbootVerInfo();
                    MyLogger.getLogger().info((Object)("FASTBOOT version info: [ " + outputsRun.getStdErr().split("\n")[0].trim() + " ]"));
                }
                catch (Exception e1) {
                    MyLogger.getLogger().error((Object)e1.getMessage());
                }
                return null;
            }
        });
    }

    public void setLanguage() {
        Language.translate(this);
    }

    public void hotbootKernel() {
        if (!Devices.HasOneFastbootConnected()) {
            MyLogger.getLogger().error((Object)"This action can only be done in fastboot mode");
            return;
        }
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    String kernel = FastBootToolboxGUI.this.chooseKernel();
                    if (kernel.equals("ERROR")) {
                        MyLogger.getLogger().error((Object)"no kernel (boot.img or kernel.sin) selected!");
                    } else {
                        MyLogger.getLogger().info((Object)("Selected kernel (boot.img or kernel.sin): " + kernel));
                        MyLogger.getLogger().info((Object)"HotBooting selected kernel");
                        RunOutputs outputsRun = FastbootUtility.hotBoot(kernel);
                        MyLogger.getLogger().info((Object)("FASTBOOT Output: \n " + outputsRun.getStdErr().trim() + "\n"));
                        MyLogger.getLogger().info((Object)"Device should now start booting with this kernel");
                    }
                }
                catch (Exception e1) {
                    MyLogger.getLogger().error((Object)e1.getMessage());
                }
                return null;
            }
        });
    }

    public void flashKernel() {
        if (!Devices.HasOneFastbootConnected()) {
            MyLogger.getLogger().error((Object)"This action can only be done in fastboot mode");
            return;
        }
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    String kernel = FastBootToolboxGUI.this.chooseKernel();
                    if (kernel.equals("ERROR")) {
                        MyLogger.getLogger().error((Object)"no kernel (boot.img or kernel.sin) selected!");
                    } else {
                        MyLogger.getLogger().info((Object)("Selected kernel (boot.img or kernel.sin): " + kernel));
                        MyLogger.getLogger().info((Object)"Flashing selected kernel");
                        RunOutputs outputsRun = FastbootUtility.flashBoot(kernel);
                        MyLogger.getLogger().info((Object)("FASTBOOT Output: \n " + outputsRun.getStdErr().trim() + "\n"));
                        MyLogger.getLogger().info((Object)"Please check the log before rebooting into system");
                    }
                }
                catch (Exception e1) {
                    MyLogger.getLogger().error((Object)e1.getMessage());
                }
                return null;
            }
        });
    }

    public void flashSystem() {
        if (!Devices.HasOneFastbootConnected()) {
            MyLogger.getLogger().error((Object)"This action can only be done in fastboot mode");
            return;
        }
        Worker.post((Job)new Job(){

            public Object run() {
                try {
                    String system = FastBootToolboxGUI.this.chooseSystem();
                    if (system.equals("ERROR")) {
                        MyLogger.getLogger().error((Object)"no system (system.img or system.sin) selected!");
                    } else {
                        MyLogger.getLogger().info((Object)("Selected system (system.img or system.sin): " + system));
                        MyLogger.getLogger().info((Object)"Flashing selected system");
                        RunOutputs outputsRun = FastbootUtility.flashSystem(system);
                        MyLogger.getLogger().info((Object)"Please check the log before rebooting into system");
                    }
                }
                catch (Exception e1) {
                    MyLogger.getLogger().error((Object)e1.getMessage());
                }
                return null;
            }
        });
    }

    public String chooseKernel() {
        JFileChooser chooser = new JFileChooser(new File("."));
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                if (f.getName().toUpperCase().endsWith(".IMG")) {
                    return true;
                }
                if (f.getName().toUpperCase().endsWith(".ELF")) {
                    return true;
                }
                return f.getName().equals("kernel.sin");
            }

            @Override
            public String getDescription() {
                return "kernel IMG/ELF file or kernel.sin";
            }
        };
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ff);
        chooser.setDialogTitle("Choose kernel file (boot.img or kernel.sin)");
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return "ERROR";
    }

    public String chooseSystem() {
        JFileChooser chooser = new JFileChooser(new File("."));
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                if (f.getName().endsWith(".img") && f.getName().contains("system")) {
                    return true;
                }
                return f.getName().endsWith(".sin") && f.getName().contains("system");
            }

            @Override
            public String getDescription() {
                return "System IMG file or system.sin";
            }
        };
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ff);
        chooser.setDialogTitle("Choose system file (system.img or system.sin)");
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return "ERROR";
    }
}

