/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import gui.SortedSizeListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.lang.Language;

public class EncDecGUI
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private JTextField textField;
    JList listFiles;
    JList listToConvert;
    DefaultListModel listFilesModel = new DefaultListModel();
    DefaultListModel listToConvertModel = new DefaultListModel();
    SortedSizeListModel sortedFilesModel = new SortedSizeListModel(this.listFilesModel);
    SortedSizeListModel sortedToConvertModel = new SortedSizeListModel(this.listToConvertModel);

    public EncDecGUI() {
        this.setName("EncDecGUI");
        this.setResizable(false);
        this.setModal(true);
        this.setTitle("Decryption wizard");
        this.setBounds(100, 100, 615, 300);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"51dlu:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(48dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"42dlu"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"53dlu:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(24dlu;default)"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EncDecGUI.this.listToConvertModel.removeAllElements();
                EncDecGUI.this.dispose();
            }
        });
        JLabel lblSourceFolder = new JLabel("Source folder :");
        lblSourceFolder.setName("lblSourceFolder");
        this.contentPanel.add((Component)lblSourceFolder, "2, 2, 3, 1, left, default");
        this.textField = new JTextField();
        this.textField.setEditable(false);
        this.contentPanel.add((Component)this.textField, "2, 4, 7, 1, fill, default");
        this.textField.setColumns(10);
        JButton button = new JButton("...");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EncDecGUI.this.doChoose();
            }
        });
        this.contentPanel.add((Component)button, "10, 4, right, center");
        JLabel lblFiles = new JLabel("Files");
        lblFiles.setName("lblFiles");
        this.contentPanel.add((Component)lblFiles, "2, 8, 3, 1, center, default");
        JLabel lblFilesToConvert = new JLabel("Files to convert");
        lblFilesToConvert.setName("lblFilesToConvert");
        this.contentPanel.add((Component)lblFilesToConvert, "8, 8, 3, 1, center, default");
        JScrollPane scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "2, 10, 3, 7, fill, fill");
        this.listFiles = new JList();
        this.listFiles.setModel(this.sortedFilesModel);
        scrollPane.setViewportView(this.listFiles);
        scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "8, 10, 3, 7, fill, fill");
        this.listToConvert = new JList();
        this.listToConvert.setModel(this.sortedToConvertModel);
        scrollPane.setViewportView(this.listToConvert);
        button = new JButton("->");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] values = EncDecGUI.this.listFiles.getSelectedValues();
                int i = 0;
                while (i < values.length) {
                    EncDecGUI.this.listToConvertModel.addElement(values[i]);
                    EncDecGUI.this.listFilesModel.removeElement(values[i]);
                    ++i;
                }
            }
        });
        this.contentPanel.add((Component)button, "6, 12, center, center");
        button = new JButton("<-");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] values = EncDecGUI.this.listToConvert.getSelectedValues();
                int i = 0;
                while (i < values.length) {
                    EncDecGUI.this.listToConvertModel.removeElement(values[i]);
                    EncDecGUI.this.listFilesModel.addElement(values[i]);
                    ++i;
                }
            }
        });
        this.contentPanel.add((Component)button, "6, 14, center, center");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        okButton.setName("okButton");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EncDecGUI.this.dispose();
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setName("cancelButton");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EncDecGUI.this.listToConvertModel.removeAllElements();
                EncDecGUI.this.dispose();
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        this.setLanguage();
    }

    public void setLanguage() {
        Language.translate(this);
    }

    public void doChoose() {
        JFileChooser chooser = new JFileChooser();
        if (this.textField.getText().length() == 0) {
            chooser.setCurrentDirectory(new File("."));
        } else {
            chooser.setCurrentDirectory(new File(this.textField.getText()));
        }
        chooser.setDialogTitle("Choose a folder");
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(this) == 0) {
            this.textField.setText(chooser.getSelectedFile().getAbsolutePath());
            this.dirlist();
        }
    }

    private void dirlist() {
        this.listFilesModel.removeAllElements();
        this.listToConvertModel.removeAllElements();
        MyFile dir = new MyFile(this.textField.getText());
        MyFile[] chld = dir.listFiles();
        int i = 0;
        while (i < chld.length) {
            if (chld[i].isFile()) {
                this.listFilesModel.addElement(chld[i]);
            }
            ++i;
        }
        if (chld.length > 0) {
            this.listFiles.setSelectionInterval(0, 0);
        }
    }

    public Object[] getList() {
        if (this.listToConvertModel.getSize() > 0) {
            this.listToConvert.setSelectionInterval(0, this.listToConvertModel.getSize() - 1);
            return this.listToConvert.getSelectedValues();
        }
        return null;
    }

    public class MyFile
    extends File {
        private static final long serialVersionUID = 1L;

        public MyFile(String path) {
            super(path);
        }

        @Override
        public String toString() {
            return this.getName();
        }

        public MyFile[] listFiles() {
            File[] f = super.listFiles();
            Vector<MyFile> v = new Vector<MyFile>();
            int i = 0;
            while (i < f.length) {
                MyFile mf = new MyFile(f[i].getAbsolutePath());
                v.add(mf);
                ++i;
            }
            MyFile[] list = new MyFile[v.size()];
            v.toArray(list);
            return list;
        }
    }

    class MyFilter
    implements FilenameFilter {
        String filter;

        public MyFilter(String lfilter) {
            this.filter = lfilter;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toUpperCase().endsWith(this.filter.toUpperCase());
        }
    }
}

