/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import flashsystem.SinFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import org.logger.MyLogger;
import org.system.Elf;

public class ElfUnpacker
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    private JTextField textElf;
    private JTextField textParts;
    private JButton btnDumpData;
    private Elf elfobj;

    public ElfUnpacker() {
        this.setTitle("ELF Unpacker");
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 450, 220);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblElfFile = new JLabel("Elf File :");
        this.contentPanel.add((Component)lblElfFile, "2, 2, 3, 1");
        this.textElf = new JTextField();
        this.contentPanel.add((Component)this.textElf, "2, 4, 3, 1, fill, default");
        this.textElf.setColumns(10);
        JButton button = new JButton("...");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String file = ElfUnpacker.this.chooseElf();
                if (!file.equals("ERROR")) {
                    try {
                        if (file.toLowerCase().endsWith("sin")) {
                            SinFile sin = new SinFile(file);
                            if (sin.getDataType().equals("elf")) {
                                sin.dumpImage();
                                file = sin.getImageFileName();
                                ElfUnpacker.this.textElf.setText(file);
                                ElfUnpacker.this.elfobj = new Elf(new File(file));
                                ElfUnpacker.this.textParts.setText(Integer.toString(ElfUnpacker.this.elfobj.getNumPrograms()));
                                ElfUnpacker.this.btnDumpData.setEnabled(true);
                                MyLogger.getLogger().info((Object)"You can now press the Unpack button to get the elf data content");
                            } else {
                                ElfUnpacker.this.textElf.setText("");
                                ElfUnpacker.this.textParts.setText("");
                                ElfUnpacker.this.btnDumpData.setEnabled(false);
                                MyLogger.getLogger().error((Object)(String.valueOf(sin.getShortFileName()) + " does not contain elf data"));
                            }
                        } else {
                            ElfUnpacker.this.textElf.setText(file);
                            ElfUnpacker.this.elfobj = new Elf(new File(file));
                            ElfUnpacker.this.textParts.setText(Integer.toString(ElfUnpacker.this.elfobj.getNumPrograms()));
                            ElfUnpacker.this.btnDumpData.setEnabled(true);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.contentPanel.add((Component)button, "6, 4");
        JLabel lblPartitionInfo = new JLabel("Number of parts :");
        this.contentPanel.add((Component)lblPartitionInfo, "2, 6, 3, 1");
        this.textParts = new JTextField();
        this.contentPanel.add((Component)this.textParts, "2, 8, 3, 1, fill, default");
        this.textParts.setColumns(10);
        this.btnDumpData = new JButton("Unpack");
        this.btnDumpData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    ElfUnpacker.this.elfobj.unpack();
                }
                catch (Exception e) {
                    MyLogger.getLogger().error((Object)e.getMessage());
                }
            }
        });
        this.btnDumpData.setEnabled(false);
        this.contentPanel.add((Component)this.btnDumpData, "2, 10, center, center");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("Close");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ElfUnpacker.this.dispose();
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
    }

    public String chooseElf() {
        JFileChooser chooser = new JFileChooser(new File("."));
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                if (f.getName().endsWith(".elf")) {
                    return true;
                }
                return f.getName().endsWith(".sin");
            }

            @Override
            public String getDescription() {
                return "*.elf *.sin";
            }
        };
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ff);
        chooser.setDialogTitle("Choose sin file)");
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return "ERROR";
    }
}

