/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import flashsystem.SinFile;
import gui.BusyBoxSelectGUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import org.system.DeviceEntry;
import org.system.Devices;
import org.system.OS;
import org.system.PropertiesFile;

public class DeviceEditorUI
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    private JTextField deviceid;
    private JTextField devicename;
    private JTextField buildprop;
    private JTextField recognition;
    private JTextField loaderpath;
    private JTextField busyboxinstall;
    private JTextField busyboxversion;
    private PropertiesFile config;
    private JCheckBox canflashmode;
    private JCheckBox canfastboot;
    private DeviceEntry _ent = null;
    private Properties BusyboxBag = new Properties();

    public DeviceEditorUI() {
        this.setModal(true);
        this.config = new PropertiesFile("org/system/ressources/deviceTemplate.properties", "");
        this.setTitle("Device Editor");
        this.setBounds(100, 100, 461, 368);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"right:max(31dlu;default):grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblDeviceId = new JLabel("Device ID");
        this.contentPanel.add((Component)lblDeviceId, "2, 4, right, default");
        this.deviceid = new JTextField();
        this.contentPanel.add((Component)this.deviceid, "4, 4, fill, default");
        this.deviceid.setColumns(10);
        JLabel lblDeviceName = new JLabel("Device Name");
        this.contentPanel.add((Component)lblDeviceName, "2, 6, right, default");
        this.devicename = new JTextField();
        this.contentPanel.add((Component)this.devicename, "4, 6, fill, default");
        this.devicename.setColumns(10);
        JLabel lblBuildpropProperty = new JLabel("Build.prop property");
        this.contentPanel.add((Component)lblBuildpropProperty, "2, 8, right, default");
        this.buildprop = new JTextField();
        this.contentPanel.add((Component)this.buildprop, "4, 8, fill, default");
        this.buildprop.setColumns(10);
        JLabel lblRecognitionPatterns = new JLabel("Recognition patterns");
        this.contentPanel.add((Component)lblRecognitionPatterns, "2, 10, right, default");
        this.recognition = new JTextField();
        this.contentPanel.add((Component)this.recognition, "4, 10, fill, default");
        this.recognition.setColumns(10);
        JLabel lblLoader = new JLabel("Loader");
        this.contentPanel.add((Component)lblLoader, "2, 12, right, default");
        this.loaderpath = new JTextField();
        this.loaderpath.setEditable(false);
        this.contentPanel.add((Component)this.loaderpath, "4, 12, fill, default");
        this.loaderpath.setColumns(10);
        JButton btnNewButton = new JButton("...");
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DeviceEditorUI.this.loaderpath.setText(DeviceEditorUI.this.doChoose());
                try {
                    SinFile l = new SinFile(DeviceEditorUI.this.loaderpath.getText());
                    if (l.getSinHeader().getNbHashBlocks() > 1) {
                        JOptionPane.showMessageDialog(null, "This file is not a loader");
                        DeviceEditorUI.this.loaderpath.setText("");
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.contentPanel.add((Component)btnNewButton, "6, 12");
        JLabel lblBusyboxInstallPath = new JLabel("Busybox install path");
        this.contentPanel.add((Component)lblBusyboxInstallPath, "2, 14, right, default");
        this.busyboxinstall = new JTextField();
        this.contentPanel.add((Component)this.busyboxinstall, "4, 14, fill, default");
        this.busyboxinstall.setColumns(10);
        JLabel lblDefaultBusybox = new JLabel("Default busybox");
        this.contentPanel.add((Component)lblDefaultBusybox, "2, 16, right, default");
        this.busyboxversion = new JTextField();
        this.busyboxversion.setEditable(false);
        this.contentPanel.add((Component)this.busyboxversion, "4, 16, fill, default");
        this.busyboxversion.setColumns(10);
        JButton button = new JButton("...");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DeviceEditorUI.this.fillBusybox();
                BusyBoxSelectGUI bui = new BusyBoxSelectGUI(DeviceEditorUI.this.BusyboxBag);
                String result = bui.getVersion();
                if (result.length() > 0) {
                    DeviceEditorUI.this.busyboxversion.setText(result);
                }
            }
        });
        this.contentPanel.add((Component)button, "6, 16");
        this.canflashmode = new JCheckBox("Flash mode");
        this.contentPanel.add((Component)this.canflashmode, "2, 18");
        this.canfastboot = new JCheckBox("Fastboot mode");
        this.contentPanel.add((Component)this.canfastboot, "2, 20");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (DeviceEditorUI.this.deviceid.getText().length() == 0) {
                    JOptionPane.showMessageDialog(null, "The deviceID must be set");
                    return;
                }
                boolean deviceExists = false;
                File[] list = new File(String.valueOf(OS.getWorkDir()) + OS.getFileSeparator() + "devices").listFiles();
                int i = 0;
                while (i < list.length) {
                    if (list[i].getName().toUpperCase().equals(DeviceEditorUI.this.deviceid.getText().toUpperCase())) {
                        deviceExists = true;
                    }
                    ++i;
                }
                if (deviceExists && DeviceEditorUI.this._ent == null) {
                    JOptionPane.showMessageDialog(null, "This deviceID already exists");
                    return;
                }
                DeviceEditorUI.this.config.setProperty("internalname", DeviceEditorUI.this.deviceid.getText().toUpperCase());
                if (DeviceEditorUI.this.devicename.getText().length() == 0) {
                    JOptionPane.showMessageDialog(null, "The device name must be set");
                    return;
                }
                Enumeration<Object> e = Devices.listDevices(true);
                while (e.hasMoreElements()) {
                    String dev = (String)e.nextElement();
                    DeviceEntry ent = Devices.getDevice(dev);
                    if (!DeviceEditorUI.this.devicename.getText().toUpperCase().equals(ent.getName().toUpperCase())) continue;
                    if (DeviceEditorUI.this._ent != null) {
                        if (DeviceEditorUI.this._ent.getName().toUpperCase().equals(ent.getName().toUpperCase())) continue;
                        JOptionPane.showMessageDialog(null, "The given name already exists for another device in your collection");
                        return;
                    }
                    JOptionPane.showMessageDialog(null, "The given name already exists for another device in your collection");
                    return;
                }
                DeviceEditorUI.this.config.setProperty("realname", DeviceEditorUI.this.devicename.getText());
                if (DeviceEditorUI.this.buildprop.getText().length() == 0) {
                    JOptionPane.showMessageDialog(null, "The build.prop property must be set");
                    return;
                }
                DeviceEditorUI.this.config.setProperty("buildprop", DeviceEditorUI.this.buildprop.getText());
                if (DeviceEditorUI.this.recognition.getText().length() == 0) {
                    JOptionPane.showMessageDialog(null, "The recognition pattern list must be set");
                    return;
                }
                DeviceEditorUI.this.config.setProperty("recognition", DeviceEditorUI.this.recognition.getText());
                if (DeviceEditorUI.this.loaderpath.getText().length() == 0) {
                    JOptionPane.showMessageDialog(null, "You must add a loader");
                    return;
                }
                DeviceEditorUI.this.config.setProperty("loader", OS.getMD5(new File(DeviceEditorUI.this.loaderpath.getText())));
                if (DeviceEditorUI.this.busyboxversion.getText().length() == 0) {
                    JOptionPane.showMessageDialog(null, "You must choose a busybox default version");
                    return;
                }
                DeviceEditorUI.this.config.setProperty("busyboxhelper", DeviceEditorUI.this.busyboxversion.getText());
                if (DeviceEditorUI.this.busyboxinstall.getText().length() == 0) {
                    JOptionPane.showMessageDialog(null, "You must set busybox install path on the phone");
                    return;
                }
                DeviceEditorUI.this.config.setProperty("busyboxinstallpath", DeviceEditorUI.this.busyboxinstall.getText());
                DeviceEditorUI.this.config.setProperty("canflash", DeviceEditorUI.this.canflashmode.isSelected() ? "true" : "false");
                DeviceEditorUI.this.config.setProperty("canfastboot", DeviceEditorUI.this.canfastboot.isSelected() ? "true" : "false");
                File f = new File(String.valueOf(OS.getWorkDir()) + "/devices/" + DeviceEditorUI.this.deviceid.getText().toUpperCase());
                File f1 = new File(String.valueOf(f.getAbsolutePath()) + OS.getFileSeparator() + "busybox");
                File f2 = new File(String.valueOf(f.getAbsolutePath()) + OS.getFileSeparator() + "features");
                if (!f.exists()) {
                    f.mkdir();
                }
                if (!f1.exists()) {
                    f1.mkdir();
                }
                if (!f2.exists()) {
                    f2.mkdir();
                }
                DeviceEditorUI.this.config.write(String.valueOf(OS.getWorkDir()) + "/devices/" + DeviceEditorUI.this.deviceid.getText().toUpperCase() + "/" + DeviceEditorUI.this.deviceid.getText().toUpperCase() + ".properties", "UTF-8");
                OS.copyfile(DeviceEditorUI.this.loaderpath.getText(), String.valueOf(f.getAbsolutePath()) + "/loader.sin");
                Enumeration<Object> en = DeviceEditorUI.this.BusyboxBag.keys();
                while (en.hasMoreElements()) {
                    String version = (String)en.nextElement();
                    String file = String.valueOf(f1.getAbsolutePath()) + OS.getFileSeparator() + version + OS.getFileSeparator() + "busybox";
                    if (new File(file).exists()) continue;
                    new File(String.valueOf(f1.getAbsolutePath()) + OS.getFileSeparator() + version).mkdir();
                    OS.copyfile(DeviceEditorUI.this.BusyboxBag.getProperty(version), file);
                }
                DeviceEditorUI.this.dispose();
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DeviceEditorUI.this.dispose();
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
    }

    public String doChoose() {
        JFileChooser chooser = new JFileChooser(new File("."));
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().toUpperCase().endsWith(".SIN");
            }

            @Override
            public String getDescription() {
                return "*.sin";
            }
        };
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ff);
        chooser.setDialogTitle("Choose loader");
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return "";
    }

    public void setEntry(DeviceEntry ent) {
        this._ent = ent;
        this.deviceid.setText(ent.getId());
        this.deviceid.setEditable(false);
        this.devicename.setText(ent.getName());
        this.buildprop.setText(ent.getBuildProp());
        this.recognition.setText(ent.getRecognition());
        this.loaderpath.setText(ent.getLoader());
        this.busyboxinstall.setText(ent.getBusyBoxInstallPath());
        this.busyboxversion.setText(new File(ent.getBusybox(false)).getParentFile().getName());
        this.canflashmode.setSelected(ent.canFlash());
        this.canfastboot.setSelected(ent.canFastboot());
    }

    public void fillBusybox() {
        File dir = new File(String.valueOf(OS.getWorkDir()) + "/devices/" + this.deviceid.getText() + "/busybox");
        File[] chld = dir.listFiles();
        if (chld != null) {
            int i = 0;
            while (i < chld.length) {
                if (chld[i].isDirectory()) {
                    this.BusyboxBag.setProperty(chld[i].getName(), String.valueOf(chld[i].getAbsolutePath()) + "/busybox");
                }
                ++i;
            }
        }
    }
}

