/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import flashsystem.BytesUtil;
import flashsystem.HexDump;
import flashsystem.io.USBFlash;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import org.system.Device;

public class CustomFlashUI
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    private JTextPane textPaneReply;
    private JTextPane textPaneCommand;

    public CustomFlashUI() {
        this.setTitle("Raw I/O Module");
        this.setBounds(100, 100, 450, 370);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(35dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(61dlu;default)"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JButton btnNewButton = new JButton("Open Device");
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    USBFlash.open(Device.getLastConnected(false).getPid());
                }
                catch (IOException iOException) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.contentPanel.add((Component)btnNewButton, "2, 2, left, center");
        JLabel lblNewLabel = new JLabel("Array to send :");
        this.contentPanel.add((Component)lblNewLabel, "2, 4, default, center");
        JButton btnNewButton_1 = new JButton("Send");
        btnNewButton_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String packet = CustomFlashUI.this.textPaneCommand.getText().trim();
                if (packet.contains(" ")) {
                    packet = packet.replaceAll(" ", "");
                }
                if (packet.contains(",")) {
                    packet = packet.replaceAll(",", "");
                }
                Byte[] b1 = BytesUtil.getBytes(packet);
                byte[] b2 = new byte[b1.length];
                int i = 0;
                while (i < b1.length) {
                    b2[i] = b1[i];
                    ++i;
                }
                try {
                    USBFlash.write(b2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.contentPanel.add((Component)btnNewButton_1, "4, 4");
        JScrollPane scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "2, 6, 7, 1, fill, fill");
        this.textPaneCommand = new JTextPane();
        scrollPane.setViewportView(this.textPaneCommand);
        JButton btnReadReply = new JButton("Read Reply");
        btnReadReply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    USBFlash.readReply();
                    CustomFlashUI.this.textPaneReply.setText(HexDump.toHex(USBFlash.getLastReply()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.contentPanel.add((Component)btnReadReply, "2, 8");
        scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "2, 10, 7, 1, fill, fill");
        this.textPaneReply = new JTextPane();
        scrollPane.setViewportView(this.textPaneReply);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("Close");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                USBFlash.close();
                CustomFlashUI.this.dispose();
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
    }
}

