/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import flashsystem.Bundle;
import flashsystem.BundleMetaData;
import gui.FirmwareFileFilter;
import gui.SortedNameListModel;
import gui.deviceSelectGui;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.lang.Language;
import org.system.DeviceEntry;
import org.system.Devices;
import org.system.OS;

public class BundleGUI
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    JButton okButton;
    private JTextField folderSource;
    private JTextField device;
    private JTextField version;
    private JTextField branding;
    private JList listFolder;
    private JCheckBox chckbxICS;
    JScrollPane scrollPane;
    DefaultListModel listFolderModel = new DefaultListModel();
    SortedNameListModel sortedListFolderModel = new SortedNameListModel(this.listFolderModel);
    DefaultMutableTreeNode root;
    DefaultTreeModel listFirmwareModel;
    boolean retcode = false;
    BundleMetaData meta = new BundleMetaData();
    JTree listFirmware;
    private Properties categoryNodes = new Properties();

    private void dirlist() {
        this.listFolderModel.removeAllElements();
        this.root.removeAllChildren();
        this.listFirmwareModel.reload(this.root);
        this.meta.clear();
        this.categoryNodes.clear();
        int i = 0;
        while (i < this.listFirmware.getRowCount()) {
            this.listFirmware.expandRow(i);
            ++i;
        }
        File[] list = new File(this.folderSource.getText()).listFiles(new FirmwareFileFilter());
        int i2 = 0;
        while (i2 < list.length) {
            try {
                this.meta.process(list[i2].getName(), list[i2].getAbsolutePath());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.listFolderModel.addElement(list[i2].getName());
            ++i2;
        }
    }

    public BundleGUI(String folder) {
        this.init();
        this.folderSource.setText(folder);
        this.dirlist();
    }

    public BundleGUI() {
        this.init();
    }

    public void init() {
        this.setResizable(false);
        this.setName("BundleGUI");
        this.setTitle("Bundle Creation");
        this.setModal(true);
        this.setBounds(100, 100, 687, 380);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(198dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(36dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(105dlu;default):grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(59dlu;default)"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(9dlu;default)"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(15dlu;default)"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JPanel panel = new JPanel();
        this.contentPanel.add((Component)panel, "2, 2, 3, 1, fill, fill");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(197dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblSelectSourceFolder = new JLabel("Select source folder :");
        lblSelectSourceFolder.setName("lblSelectSourceFolder");
        panel.add((Component)lblSelectSourceFolder, "2, 2, 3, 1");
        this.folderSource = new JTextField();
        this.folderSource.setEditable(false);
        panel.add((Component)this.folderSource, "2, 4, fill, default");
        this.folderSource.setColumns(10);
        JButton button = new JButton("...");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BundleGUI.this.doChoose();
            }
        });
        panel.add((Component)button, "4, 4, left, default");
        panel = new JPanel();
        this.contentPanel.add((Component)panel, "6, 2, 1, 3, fill, fill");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JLabel lblDevice = new JLabel("Device :");
        lblDevice.setName("lblDevice");
        panel.add((Component)lblDevice, "2, 2");
        this.device = new JTextField();
        panel.add((Component)this.device, "4, 2");
        this.device.setColumns(10);
        JLabel lblVersion = new JLabel("Version :");
        lblVersion.setName("lblVersion");
        panel.add((Component)lblVersion, "2, 4");
        this.version = new JTextField();
        panel.add((Component)this.version, "4, 4");
        this.version.setColumns(10);
        JLabel lblBranding = new JLabel("Branding :");
        lblBranding.setName("lblBranding");
        panel.add((Component)lblBranding, "2, 6");
        this.branding = new JTextField();
        panel.add((Component)this.branding, "4, 6");
        this.branding.setColumns(10);
        JPanel panel_1 = new JPanel();
        panel.add((Component)panel_1, "2, 8, 3, 1, left, fill");
        this.chckbxICS = new JCheckBox("Disable Final Verification Check");
        panel_1.add(this.chckbxICS);
        JLabel lblFirmwareList = new JLabel("Folder list :");
        lblFirmwareList.setName("lblFirmwareList");
        this.contentPanel.add((Component)lblFirmwareList, "2, 6");
        JLabel lblFirmwareContent = new JLabel("Firmware content :");
        lblFirmwareContent.setName("lblFirmwareContent");
        this.contentPanel.add((Component)lblFirmwareContent, "6, 6");
        JScrollPane scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "2, 8, 1, 5, fill, fill");
        this.listFolder = new JList();
        this.listFolder.setModel(this.sortedListFolderModel);
        scrollPane.setViewportView(this.listFolder);
        JButton button2 = new JButton("->");
        button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Object[] values = BundleGUI.this.listFolder.getSelectedValues();
                int i = 0;
                while (i < values.length) {
                    String categ = BundleGUI.this.meta.getCategorie(BundleGUI.this.meta.getInternal((String)values[i]));
                    DefaultMutableTreeNode newnode = (DefaultMutableTreeNode)BundleGUI.this.categoryNodes.get(categ);
                    if (newnode == null) {
                        newnode = new DefaultMutableTreeNode(categ);
                        BundleGUI.this.categoryNodes.put(categ, newnode);
                        BundleGUI.this.root.add(newnode);
                    }
                    DefaultMutableTreeNode newchild = new DefaultMutableTreeNode(BundleGUI.this.meta.getInternal((String)values[i]));
                    newnode.add(newchild);
                    BundleGUI.this.listFirmwareModel.reload(BundleGUI.this.root);
                    int j = 0;
                    while (j < BundleGUI.this.listFirmware.getRowCount()) {
                        BundleGUI.this.listFirmware.expandRow(j);
                        ++j;
                    }
                    BundleGUI.this.listFolderModel.removeElement(values[i]);
                    ++i;
                }
            }
        });
        this.contentPanel.add((Component)button2, "4, 8, center, default");
        this.scrollPane = new JScrollPane();
        this.contentPanel.add((Component)this.scrollPane, "6, 8, 1, 5, fill, fill");
        this.root = new DefaultMutableTreeNode("Content");
        this.listFirmware = new JTree(this.root);
        this.listFirmware.getSelectionModel().setSelectionMode(1);
        this.listFirmwareModel = (DefaultTreeModel)this.listFirmware.getModel();
        this.scrollPane.setViewportView(this.listFirmware);
        button2 = new JButton("<-");
        button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TreePath[] path = BundleGUI.this.listFirmware.getSelectionPaths();
                int i = 0;
                while (i < path.length) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path[i].getLastPathComponent();
                    if (!node.isLeaf()) {
                        Enumeration<TreeNode> list = node.children();
                        while (list.hasMoreElements()) {
                            DefaultMutableTreeNode lnode = (DefaultMutableTreeNode)list.nextElement();
                            node.remove(lnode);
                            BundleGUI.this.listFolderModel.addElement(BundleGUI.this.meta.getExternal(lnode.toString()));
                        }
                        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                        parent.remove(node);
                        BundleGUI.this.categoryNodes.remove(node.toString());
                    } else {
                        BundleGUI.this.listFolderModel.addElement(BundleGUI.this.meta.getExternal(node.toString()));
                        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                        parent.remove(node);
                        if (parent.getChildCount() == 0) {
                            DefaultMutableTreeNode parentparent = (DefaultMutableTreeNode)parent.getParent();
                            parentparent.remove(parent);
                            BundleGUI.this.categoryNodes.remove(parent.toString());
                        }
                    }
                    BundleGUI.this.listFirmwareModel.reload(BundleGUI.this.root);
                    int j = 0;
                    while (j < BundleGUI.this.listFirmware.getRowCount()) {
                        BundleGUI.this.listFirmware.expandRow(j);
                        ++j;
                    }
                    ++i;
                }
            }
        });
        this.contentPanel.add((Component)button2, "4, 10, center, default");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BundleGUI.this.retcode = false;
                BundleGUI.this.dispose();
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.okButton = new JButton("OK");
        this.okButton.setName("okButton");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                boolean bl = BundleGUI.this.retcode = BundleGUI.this.version.getText().length() > 0 && BundleGUI.this.device.getText().length() > 0 && BundleGUI.this.branding.getText().length() > 0 && BundleGUI.this.root.getChildCount() >= 1;
                if (BundleGUI.this.retcode) {
                    if (new File("./firmwares/" + BundleGUI.this.device.getText() + "_" + BundleGUI.this.version.getText() + "_" + BundleGUI.this.branding.getText() + ".ftf").exists()) {
                        JOptionPane.showMessageDialog(null, "You already used this device/version/branding for another bundle");
                    } else if (BundleGUI.this.root.getChildAt(0).getChildCount() == 1) {
                        String md5 = OS.getMD5(new File(String.valueOf(BundleGUI.this.folderSource.getText()) + OS.getFileSeparator() + BundleGUI.this.meta.getExternal(BundleGUI.this.root.getChildAt(0).getChildAt(0).toString()))).toUpperCase();
                        Enumeration<Object> e = Devices.listDevices(false);
                        boolean found = false;
                        while (e.hasMoreElements() && !found) {
                            DeviceEntry entry = Devices.getDevice((String)e.nextElement());
                            if (md5.equals(entry.getLoaderMD5())) {
                                found = true;
                            }
                            if (!entry.hasUnlockedLoader() || !md5.equals(entry.getLoaderUnlockedMD5())) continue;
                            found = true;
                        }
                        if (found) {
                            JOptionPane.showMessageDialog(null, "A Bundle cannot contain only a loader");
                        } else {
                            BundleGUI.this.dispose();
                        }
                    } else {
                        BundleGUI.this.dispose();
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "You must fill all fields and have at least one file in the firmware list");
                }
            }
        });
        this.okButton.setActionCommand("OK");
        buttonPane.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setName("cancelButton");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BundleGUI.this.retcode = false;
                BundleGUI.this.dispose();
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        try {
            this.dirlist();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLanguage();
    }

    public void doChoose() {
        JFileChooser chooser = new JFileChooser();
        if (this.folderSource.getText().length() == 0) {
            chooser.setCurrentDirectory(new File("."));
        } else {
            chooser.setCurrentDirectory(new File(this.folderSource.getText()));
        }
        chooser.setDialogTitle("Choose a folder");
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(this) == 0) {
            this.folderSource.setText(chooser.getSelectedFile().getAbsolutePath());
            this.dirlist();
        }
    }

    public void setLanguage() {
        Language.translate(this);
    }

    public Bundle getBundle(String mode) {
        this.setVisible(true);
        if (this.retcode) {
            Bundle b2 = new Bundle();
            Enumeration e = this.listFolderModel.elements();
            while (e.hasMoreElements()) {
                this.meta.remove(this.meta.getInternal((String)e.nextElement()));
            }
            b2.setMeta(this.meta);
            deviceSelectGui devsel = new deviceSelectGui(b2);
            devsel.isSelected();
            b2.setDevice(this.device.getText());
            b2.setVersion(this.version.getText());
            b2.setBranding(this.branding.getText());
            b2.setCmd25(this.chckbxICS.isSelected() ? "true" : "flase");
            return b2;
        }
        return null;
    }
}

