/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import org.adb.AdbUtility;
import org.apache.commons.io.IOUtils;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.lang.Language;
import org.logger.MyLogger;
import org.system.Devices;
import org.system.GlobalConfig;
import org.system.OS;
import org.system.Shell;

public class BuildPropGUI
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private static String fsep = OS.getFileSeparator();
    private File f;
    private RSyntaxTextArea textArea;
    private JTextField textPath;
    private JTextField textFile;
    private String localfile;
    private JButton btnSave;
    private JTextField searchField;
    private JCheckBox regexCB;
    private JCheckBox matchCaseCB;

    public void loadFile(JTextArea area) {
        try {
            if (this.textPath.getText().endsWith("/")) {
                this.textPath.setText(this.textPath.getText().substring(0, this.textPath.getText().length() - 1));
            }
            this.localfile = String.valueOf(Devices.getCurrent().getWorkDir()) + fsep + this.textFile.getText();
            AdbUtility.pull(String.valueOf(this.textPath.getText()) + "/" + this.textFile.getText(), String.valueOf(Devices.getCurrent().getWorkDir()) + fsep + this.textFile.getText());
            this.f = new File(this.localfile);
            FileReader fr = new FileReader(this.f);
            area.read(fr, null);
            area.setCaretPosition(0);
            fr.close();
            this.btnSave.setEnabled(true);
            this.setTitle(String.valueOf(this.textPath.getText()) + "/" + this.textFile.getText());
        }
        catch (Exception e) {
            MyLogger.getLogger().error((Object)e.getMessage());
        }
    }

    public void writeFile(JTextArea area) {
        try {
            try {
                FileOutputStream fout = new FileOutputStream(this.f);
                IOUtils.write((String)area.getText(), (OutputStream)fout, (String)"ISO-8859-1");
                fout.close();
            }
            catch (IOException exception) {
                MyLogger.getLogger().error((Object)exception.getMessage());
                try {
                    if (AdbUtility.Sysremountrw()) {
                        AdbUtility.push(this.localfile, String.valueOf(GlobalConfig.getProperty("deviceworkdir")) + "/" + this.textFile.getText() + "_new");
                        String stat = AdbUtility.getFilePerms(String.valueOf(this.textPath.getText()) + "/" + this.textFile.getText());
                        int access = stat.indexOf("Access:");
                        int uid = stat.indexOf("Uid:");
                        int gid = stat.indexOf("Gid:");
                        String saccess = stat.substring(access, uid);
                        String suid = stat.substring(uid, gid);
                        String sgid = stat.substring(gid);
                        int astart = saccess.indexOf("(") + 1;
                        int aend = saccess.indexOf("/");
                        int ustart = suid.indexOf("(") + 1;
                        int uend = suid.indexOf("/");
                        int gstart = sgid.indexOf("(") + 1;
                        int gend = sgid.indexOf("/");
                        Shell shell = new Shell("pushfile");
                        shell.setProperty("VFILE", this.textFile.getText());
                        shell.setProperty("VPATH", this.textPath.getText());
                        shell.setProperty("VUID", suid.substring(ustart, uend).trim());
                        shell.setProperty("VGID", sgid.substring(gstart, gend).trim());
                        shell.setProperty("VPERM", saccess.substring(astart, aend).trim());
                        shell.runRoot();
                    } else {
                        MyLogger.getLogger().info((Object)"Error mounting /system rw");
                    }
                }
                catch (Exception exception2) {
                    MyLogger.getLogger().error((Object)exception2.getMessage());
                }
            }
        }
        finally {
            try {
                if (AdbUtility.Sysremountrw()) {
                    AdbUtility.push(this.localfile, String.valueOf(GlobalConfig.getProperty("deviceworkdir")) + "/" + this.textFile.getText() + "_new");
                    String stat = AdbUtility.getFilePerms(String.valueOf(this.textPath.getText()) + "/" + this.textFile.getText());
                    int access = stat.indexOf("Access:");
                    int uid = stat.indexOf("Uid:");
                    int gid = stat.indexOf("Gid:");
                    String saccess = stat.substring(access, uid);
                    String suid = stat.substring(uid, gid);
                    String sgid = stat.substring(gid);
                    int astart = saccess.indexOf("(") + 1;
                    int aend = saccess.indexOf("/");
                    int ustart = suid.indexOf("(") + 1;
                    int uend = suid.indexOf("/");
                    int gstart = sgid.indexOf("(") + 1;
                    int gend = sgid.indexOf("/");
                    Shell shell = new Shell("pushfile");
                    shell.setProperty("VFILE", this.textFile.getText());
                    shell.setProperty("VPATH", this.textPath.getText());
                    shell.setProperty("VUID", suid.substring(ustart, uend).trim());
                    shell.setProperty("VGID", sgid.substring(gstart, gend).trim());
                    shell.setProperty("VPERM", saccess.substring(astart, aend).trim());
                    shell.runRoot();
                } else {
                    MyLogger.getLogger().info((Object)"Error mounting /system rw");
                }
            }
            catch (Exception exception) {
                MyLogger.getLogger().error((Object)exception.getMessage());
            }
        }
    }

    public BuildPropGUI() {
        this.setTitle("File Editor");
        this.setName("BuildPropGUI");
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 549, 466);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(25dlu;default)"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BuildPropGUI.this.dispose();
            }
        });
        JLabel lblPath = new JLabel("path:");
        this.contentPane.add((Component)lblPath, "2, 2, right, default");
        this.textPath = new JTextField();
        this.textPath.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent arg0) {
                BuildPropGUI.this.textArea.setText("");
                BuildPropGUI.this.btnSave.setEnabled(false);
                if (BuildPropGUI.this.f != null) {
                    BuildPropGUI.this.f.delete();
                }
            }
        });
        this.contentPane.add((Component)this.textPath, "4, 2, fill, center");
        this.textPath.setColumns(10);
        JLabel lblNewLabel = new JLabel("File :");
        this.contentPane.add((Component)lblNewLabel, "6, 2, right, default");
        this.textArea = new RSyntaxTextArea(25, 70);
        this.textFile = new JTextField();
        this.textFile.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                BuildPropGUI.this.textArea.setText("");
                BuildPropGUI.this.btnSave.setEnabled(false);
                if (BuildPropGUI.this.f != null) {
                    BuildPropGUI.this.f.delete();
                }
            }
        });
        this.contentPane.add((Component)this.textFile, "8, 2, fill, center");
        this.textFile.setColumns(10);
        JToolBar toolBar = new JToolBar();
        this.contentPane.add((Component)toolBar, "2, 4, 7, 1");
        this.searchField = new JTextField(30);
        toolBar.add(this.searchField);
        JButton b2 = new JButton("Find Next");
        b2.setActionCommand("FindNext");
        b2.addActionListener(this);
        toolBar.add(b2);
        b2 = new JButton("Find Previous");
        b2.setActionCommand("FindPrev");
        b2.addActionListener(this);
        toolBar.add(b2);
        this.regexCB = new JCheckBox("Regex");
        toolBar.add(this.regexCB);
        this.matchCaseCB = new JCheckBox("Match Case");
        toolBar.add(this.matchCaseCB);
        RTextScrollPane scrollPane = new RTextScrollPane((RTextArea)this.textArea);
        this.contentPane.add((Component)scrollPane, "2, 6, 7, 19, fill, fill");
        this.btnSave = new JButton("Save");
        this.btnSave.setEnabled(false);
        this.btnSave.setName("btnSave");
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BuildPropGUI.this.writeFile((JTextArea)BuildPropGUI.this.textArea);
            }
        });
        this.contentPane.add((Component)this.btnSave, "2, 26");
        JButton btnReload = new JButton("Reload");
        btnReload.setName("btnReload");
        btnReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BuildPropGUI.this.loadFile((JTextArea)BuildPropGUI.this.textArea);
            }
        });
        this.contentPane.add((Component)btnReload, "4, 26");
        JButton btnClose = new JButton("Close");
        btnClose.setName("btnClose");
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BuildPropGUI.this.dispose();
            }
        });
        this.contentPane.add((Component)btnClose, "8, 26, right, default");
        this.setLanguage();
    }

    public void setLanguage() {
        Language.translate(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("FindNext".equals(command)) {
            String text = this.searchField.getText();
            if (text.length() == 0) {
                return;
            }
            boolean forward = true;
            boolean matchCase = this.matchCaseCB.isSelected();
            boolean wholeWord = false;
            boolean regex = this.regexCB.isSelected();
            SearchContext ctx = new SearchContext();
            ctx.setSearchFor(text);
            ctx.setSearchForward(forward);
            ctx.setWholeWord(wholeWord);
            ctx.setRegularExpression(regex);
            ctx.setMatchCase(matchCase);
            boolean found = SearchEngine.find((JTextArea)this.textArea, (SearchContext)ctx);
            if (!found) {
                JOptionPane.showMessageDialog(this, "Text not found");
            }
        } else if ("FindPrev".equals(command)) {
            String text = this.searchField.getText();
            if (text.length() == 0) {
                return;
            }
            boolean forward = false;
            boolean matchCase = this.matchCaseCB.isSelected();
            boolean wholeWord = false;
            boolean regex = this.regexCB.isSelected();
            SearchContext ctx = new SearchContext();
            ctx.setSearchFor(text);
            ctx.setSearchForward(forward);
            ctx.setWholeWord(wholeWord);
            ctx.setRegularExpression(regex);
            ctx.setMatchCase(matchCase);
            boolean found = SearchEngine.find((JTextArea)this.textArea, (SearchContext)ctx);
            if (!found) {
                JOptionPane.showMessageDialog(this, "Text not found");
            }
        }
    }
}

