/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import gui.ApkAdd;
import gui.X10Apps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import org.system.Devices;

public class AppListManager
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private JTable tableX10;
    private JTable tableCustom;
    private DefaultTableModel modelX10;
    private DefaultTableModel modelCustom;
    private X10Apps _apps;

    public AppListManager(X10Apps apps) {
        this._apps = apps;
        this.setTitle("Application List Manager");
        this.setModal(true);
        this.setResizable(false);
        this.setBounds(100, 100, 450, 300);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JTabbedPane tabbedPane = new JTabbedPane(1);
        this.contentPanel.add((Component)tabbedPane, "2, 2, fill, fill");
        JPanel panel = new JPanel();
        tabbedPane.addTab(String.valueOf(Devices.getCurrent().getId()) + " Applications", null, panel, null);
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JScrollPane scrollPane = new JScrollPane();
        panel.add((Component)scrollPane, "2, 2, 1, 3, fill, fill");
        this.tableX10 = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return false;
            }
        };
        this.tableX10.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                if (arg0.getClickCount() == 2) {
                    ApkAdd add = new ApkAdd((String)AppListManager.this.modelX10.getValueAt(AppListManager.this.tableX10.getSelectedRow(), 0), (String)AppListManager.this.modelX10.getValueAt(AppListManager.this.tableX10.getSelectedRow(), 1));
                    String[] result = add.getEntry();
                    AppListManager.this._apps.modApk(result[0], result[1]);
                    AppListManager.this.fillLists();
                }
            }
        });
        this.tableX10.setSelectionMode(0);
        scrollPane.setViewportView(this.tableX10);
        panel = new JPanel();
        tabbedPane.addTab("Custom Applications", null, panel, null);
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        scrollPane = new JScrollPane();
        panel.add((Component)scrollPane, "2, 2, fill, fill");
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem mntmAdd = new JMenuItem("Add");
        mntmAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ApkAdd add = new ApkAdd("", "");
                String[] result = add.getEntry();
                if (result[0].length() > 0) {
                    AppListManager.this._apps.addApk(new File(result[0]), result[1]);
                    AppListManager.this.fillLists();
                }
            }
        });
        popupMenu.add(mntmAdd);
        this.tableCustom = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return false;
            }
        };
        this.tableCustom.setAutoCreateRowSorter(true);
        this.tableCustom.setSelectionMode(0);
        this.tableCustom.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                if (arg0.getClickCount() == 2) {
                    ApkAdd add = new ApkAdd((String)AppListManager.this.modelCustom.getValueAt(AppListManager.this.tableCustom.getSelectedRow(), 0), (String)AppListManager.this.modelCustom.getValueAt(AppListManager.this.tableCustom.getSelectedRow(), 1));
                    String[] result = add.getEntry();
                    AppListManager.this._apps.modApk(result[0], result[1]);
                    AppListManager.this.fillLists();
                }
            }
        });
        scrollPane.setViewportView(this.tableCustom);
        AppListManager.addPopup(this.tableCustom, popupMenu);
        AppListManager.addPopup(scrollPane, popupMenu);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("Close");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AppListManager.this.dispose();
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.fillLists();
    }

    private void fillLists() {
        this.modelX10 = new DefaultTableModel();
        this.tableX10.setModel(this.modelX10);
        this.modelX10.addColumn("APK Name");
        this.modelX10.addColumn("Presentation Name");
        for (String string : this._apps.deviceList().keySet()) {
            Object[] objectArray = new String[]{string, this._apps.getRealName(string)};
            this.modelX10.addRow(objectArray);
        }
        this.tableX10.setAutoCreateColumnsFromModel(false);
        this.sortAllRowsBy(this.modelX10, 0, true);
        this.modelCustom = new DefaultTableModel();
        this.tableCustom.setModel(this.modelCustom);
        this.modelCustom.addColumn("APK Name");
        this.modelCustom.addColumn("Presentation Name");
        for (String string : this._apps.customList().keySet()) {
            Object[] row = new String[]{string, this._apps.getRealName(string)};
            this.modelCustom.addRow(row);
        }
        this.tableCustom.setAutoCreateColumnsFromModel(false);
        this.sortAllRowsBy(this.modelCustom, 0, true);
    }

    private static void addPopup(Component component, final JPopupMenu popup) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }

    public void sortAllRowsBy(DefaultTableModel model, int colIndex, boolean ascending) {
        Vector<Vector> data = model.getDataVector();
        Collections.sort(data, new ColumnSorter(colIndex, ascending));
        model.fireTableStructureChanged();
    }

    public class ColumnSorter
    implements Comparator<Object> {
        int colIndex;
        boolean ascending;

        ColumnSorter(int colIndex, boolean ascending) {
            this.colIndex = colIndex;
            this.ascending = ascending;
        }

        @Override
        public int compare(Object a2, Object b2) {
            Vector v1 = (Vector)a2;
            Vector v2 = (Vector)b2;
            Object o1 = v1.get(this.colIndex);
            Object o2 = v2.get(this.colIndex);
            if (o1 instanceof String && ((String)o1).length() == 0) {
                o1 = null;
            }
            if (o2 instanceof String && ((String)o2).length() == 0) {
                o2 = null;
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 instanceof Comparable) {
                if (this.ascending) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return ((Comparable)o2).compareTo(o1);
            }
            if (this.ascending) {
                return o1.toString().compareTo(o2.toString());
            }
            return o2.toString().compareTo(o1.toString());
        }
    }
}

