/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import gui.ApkFileFilter;
import gui.SortedNameListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.lang.Language;

public class ApkInstallGUI
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    JButton okButton;
    private JTextField folderSource;
    private JList listFolder;
    DefaultListModel listFolderModel = new DefaultListModel();
    SortedNameListModel sortedListFolderModel = new SortedNameListModel(this.listFolderModel);

    private void dirlist() {
        this.listFolderModel.removeAllElements();
        File[] list = new File(this.folderSource.getText()).listFiles(new ApkFileFilter());
        int i = 0;
        while (i < list.length) {
            this.listFolderModel.addElement(list[i].getName());
            ++i;
        }
    }

    public ApkInstallGUI(String folder) {
        this.init();
        this.folderSource.setText(folder);
        this.dirlist();
    }

    public ApkInstallGUI() {
        this.init();
    }

    public void init() {
        this.setResizable(false);
        this.setName("ApkInstallGUI");
        this.setTitle("APK Installer");
        this.setModal(true);
        this.setBounds(100, 100, 606, 357);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(309dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(19dlu;default):grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(9dlu;default)"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(11dlu;default)"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblSelectSourceFolder = new JLabel("Select source folder :");
        lblSelectSourceFolder.setName("lblSelectSourceFolder");
        this.contentPanel.add((Component)lblSelectSourceFolder, "2, 2");
        this.folderSource = new JTextField();
        this.contentPanel.add((Component)this.folderSource, "2, 4, fill, center");
        this.folderSource.setEditable(false);
        this.folderSource.setColumns(10);
        JButton button = new JButton("...");
        this.contentPanel.add((Component)button, "4, 4, center, default");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ApkInstallGUI.this.doChoose();
            }
        });
        JLabel lblFirmwareList = new JLabel("Folder list :");
        lblFirmwareList.setName("lblFirmwareList");
        this.contentPanel.add((Component)lblFirmwareList, "2, 6");
        JScrollPane scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "2, 8, 3, 5, fill, fill");
        this.listFolder = new JList();
        this.listFolder.setModel(this.sortedListFolderModel);
        scrollPane.setViewportView(this.listFolder);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ApkInstallGUI.this.folderSource.setText("");
                ApkInstallGUI.this.dispose();
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.okButton = new JButton("OK");
        this.okButton.setName("okButton");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ApkInstallGUI.this.dispose();
            }
        });
        this.okButton.setActionCommand("OK");
        buttonPane.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setName("cancelButton");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ApkInstallGUI.this.folderSource.setText("");
                ApkInstallGUI.this.dispose();
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        try {
            this.dirlist();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLanguage();
    }

    public void doChoose() {
        JFileChooser chooser = new JFileChooser();
        if (this.folderSource.getText().length() == 0) {
            chooser.setCurrentDirectory(new File("."));
        } else {
            chooser.setCurrentDirectory(new File(this.folderSource.getText()));
        }
        chooser.setDialogTitle("Choose a folder");
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(this) == 0) {
            this.folderSource.setText(chooser.getSelectedFile().getAbsolutePath());
            this.dirlist();
        }
    }

    public void setLanguage() {
        Language.translate(this);
    }

    public String getFolder() {
        this.setVisible(true);
        return this.folderSource.getText();
    }
}

