/*
 * Decompiled with CFR 0.152.
 */
package flashsystem.io;

import flashsystem.S1Packet;
import flashsystem.X10FlashException;
import java.io.IOException;
import org.logger.MyLogger;
import win32lib.JKernel32;

public class USBFlashWin32 {
    private static int lastflags;
    private static byte[] lastreply;

    public static void windowsOpen(String pid) throws IOException {
        block2: {
            try {
                MyLogger.getLogger().info((Object)"Opening device for R/W");
                JKernel32.openDevice();
            }
            catch (Exception e) {
                if (lastreply != null) break block2;
                throw new IOException("Unable to read from device");
            }
        }
    }

    public static void windowsClose() {
        JKernel32.closeDevice();
    }

    private static void windowsSleep(int len) {
        try {
            Thread.sleep(len);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean windowsWriteS1(S1Packet p) throws IOException, X10FlashException {
        JKernel32.writeBytes(p.getByteArray());
        return true;
    }

    public static boolean windowsWrite(byte[] array) throws IOException, X10FlashException {
        JKernel32.writeBytes(array);
        return true;
    }

    public static void windowsReadS1Reply() throws X10FlashException, IOException {
        S1Packet p = null;
        boolean finished = false;
        while (!finished) {
            byte[] read = JKernel32.readBytes(65536);
            if (p == null) {
                p = new S1Packet(read);
            } else {
                p.addData(read);
            }
            boolean bl = finished = !p.hasMoreToRead();
        }
        p.validate();
        lastreply = p.getDataArray();
        lastflags = p.getFlags();
    }

    public static void windowsReadReply() throws X10FlashException, IOException {
        lastreply = JKernel32.readBytes(65536);
    }

    public static int windowsGetLastFlags() {
        return lastflags;
    }

    public static byte[] windowsGetLastReply() {
        return lastreply;
    }
}

