/*
 * Decompiled with CFR 0.152.
 */
package flashsystem.io;

import flashsystem.S1Packet;
import flashsystem.X10FlashException;
import java.io.IOException;
import linuxlib.JUsb;
import org.logger.MyLogger;

public class USBFlashLinux {
    private static int lastflags;
    private static byte[] lastreply;

    public static void linuxOpen(String pid) throws IOException, Exception {
        MyLogger.getLogger().info((Object)"Opening device for R/W");
        JUsb.fillDevice(false);
        JUsb.open();
        MyLogger.getLogger().info((Object)"Device ready for R/W.");
    }

    public static void linuxWriteS1(S1Packet p) throws IOException, X10FlashException {
        try {
            JUsb.writeBytes(p.getByteArray());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static void linuxWrite(byte[] array) throws IOException, X10FlashException {
        try {
            JUsb.writeBytes(array);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void linuxReadS1Reply() throws X10FlashException, IOException {
        S1Packet p = null;
        boolean finished = false;
        try {
            while (!finished) {
                byte[] b2 = JUsb.readBytes();
                if (p == null) {
                    p = new S1Packet(b2);
                } else {
                    p.addData(b2);
                }
                boolean bl = finished = !p.hasMoreToRead();
            }
            p.validate();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (p != null) {
                p.release();
            }
            p = null;
        }
        if (p != null) {
            lastreply = p.getDataArray();
            lastflags = p.getFlags();
            p.release();
        } else {
            lastreply = null;
            lastflags = 0;
        }
        if (lastreply == null) {
            throw new X10FlashException("Cannot read from device");
        }
    }

    public static void linuxReadS1Reply(int timeout) throws X10FlashException, IOException {
        S1Packet p = null;
        boolean finished = false;
        try {
            while (!finished) {
                byte[] b2 = JUsb.readBytes(timeout);
                if (p == null) {
                    p = new S1Packet(b2);
                } else {
                    p.addData(b2);
                }
                boolean bl = finished = !p.hasMoreToRead();
            }
            p.validate();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (p != null) {
                p.release();
            }
            p = null;
        }
        if (p != null) {
            lastreply = p.getDataArray();
            lastflags = p.getFlags();
            p.release();
        } else {
            lastreply = null;
            lastflags = 0;
        }
    }

    public static void linuxReadReply() throws X10FlashException, IOException {
        try {
            lastreply = JUsb.readBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int linuxGetLastFlags() {
        return lastflags;
    }

    public static byte[] linuxGetLastReply() {
        return lastreply;
    }

    public static void linuxClose() {
        try {
            JUsb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

