/*
 * Decompiled with CFR 0.152.
 */
package flashsystem;

import flashsystem.Bundle;
import flashsystem.BundleEntry;
import flashsystem.BytesUtil;
import flashsystem.Command;
import flashsystem.HexDump;
import flashsystem.LoaderInfo;
import flashsystem.SinFile;
import flashsystem.TaEntry;
import flashsystem.TaFile;
import flashsystem.TaParseException;
import flashsystem.X10FlashException;
import flashsystem.io.USBFlash;
import gui.LoaderRootFilter;
import gui.LoaderSelectorGUI;
import gui.deviceSelectGui;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.logger.MyLogger;
import org.logger.TextAreaAppender;
import org.system.Device;
import org.system.DeviceChangedListener;
import org.system.OS;
import org.system.TextFile;

public class X10flash {
    private Bundle _bundle;
    private Command cmd;
    private LoaderInfo phoneprops = null;

    public X10flash(Bundle bundle) {
        this._bundle = bundle;
    }

    public void setFlashState(boolean ongoing) throws IOException, X10FlashException {
        if (ongoing) {
            this.cmd.send(13, Command.TA_EDREAM_FLASH_STARTUP_SHUTDOWN_RESULT_ONGOING, false);
        } else {
            this.cmd.send(13, Command.TA_EDREAM_FLASH_STARTUP_SHUTDOWN_RESULT_FINISHED, false);
            this.cmd.send(13, Command.TA_FLASH_STARTUP_SHUTDOWN_RESULT_FINISHED, false);
        }
    }

    private void sendTA(InputStream in, String name) throws FileNotFoundException, IOException, X10FlashException {
        try {
            TaFile ta = new TaFile(in);
            MyLogger.getLogger().info((Object)("Flashing " + name));
            Vector<TaEntry> entries = ta.entries();
            int i = 0;
            while (i < entries.size()) {
                this.sendTAUnit(entries.get(i));
                ++i;
            }
        }
        catch (TaParseException tae) {
            MyLogger.getLogger().error((Object)"Error parsing TA file. Skipping");
        }
    }

    public void sendTAUnit(TaEntry ta) throws X10FlashException, IOException {
        MyLogger.getLogger().info((Object)("Writing TA unit : " + HexDump.toHex(ta.getWordbyte())));
        if (!this._bundle.simulate()) {
            this.cmd.send(13, ta.getWordbyte(), false);
        }
    }

    public String dumpProperty(int prnumber, String format) throws IOException, X10FlashException {
        MyLogger.getLogger().info((Object)"Start Reading property");
        MyLogger.getLogger().debug((Object)("%%% read TA property id=" + prnumber));
        this.cmd.send(12, BytesUtil.getBytesWord(prnumber, 4), false);
        MyLogger.updateProgress();
        String reply = "";
        if (format.equals("hex")) {
            reply = this.cmd.getLastReplyHex();
        }
        if (format.equals("string")) {
            reply = this.cmd.getLastReplyString();
        }
        reply = reply.replace("[", "");
        reply = reply.replace("]", "");
        reply = reply.replace(",", "");
        MyLogger.getLogger().info((Object)"Reading TA finished.");
        return reply;
    }

    public Vector<TaEntry> dumpProperties() {
        Vector<TaEntry> v = new Vector<TaEntry>();
        try {
            MyLogger.getLogger().info((Object)"Start Dumping TA");
            MyLogger.initProgress(9789);
            int i = 0;
            while (i < 4920) {
                try {
                    this.cmd.send(12, BytesUtil.getBytesWord(i, 4), false);
                    String reply = this.cmd.getLastReplyHex();
                    reply = reply.replace("[", "");
                    reply = reply.replace("]", "");
                    reply = reply.replace(",", "");
                    if (this.cmd.getLastReplyLength() > 0) {
                        TaEntry ta = new TaEntry();
                        ta.setPartition(HexDump.toHex(i));
                        ta.addData(reply.trim());
                        v.add(ta);
                    }
                }
                catch (X10FlashException x10FlashException) {
                    // empty catch block
                }
                ++i;
            }
            MyLogger.initProgress(0);
            MyLogger.getLogger().info((Object)"Dumping TA finished.");
        }
        catch (Exception ioe) {
            MyLogger.initProgress(0);
            MyLogger.getLogger().error((Object)ioe.getMessage());
            MyLogger.getLogger().error((Object)"Error dumping TA. Aborted");
            this.closeDevice();
        }
        return v;
    }

    public void BackupTA() throws IOException, X10FlashException {
        this.openTA(2);
        TextFile tazone = new TextFile(String.valueOf(OS.getWorkDir()) + "/custom/ta/" + this.getPhoneProperty("MSN") + "-" + TextAreaAppender.timestamp + ".ta", "ISO8859-1");
        tazone.open(false);
        try {
            MyLogger.getLogger().info((Object)"Start Dumping TA");
            MyLogger.initProgress(9789);
            int i = 0;
            while (i < 4920) {
                try {
                    MyLogger.getLogger().debug((Object)("%%% read TA property id=" + i));
                    this.cmd.send(12, BytesUtil.getBytesWord(i, 4), false);
                    String reply = this.cmd.getLastReplyHex();
                    reply = reply.replace("[", "");
                    reply = reply.replace("]", "");
                    reply = reply.replace(",", "");
                    if (this.cmd.getLastReplyLength() > 0) {
                        tazone.writeln(String.valueOf(HexDump.toHex(i)) + " " + HexDump.toHex(this.cmd.getLastReplyLength()) + " " + reply.trim());
                    }
                }
                catch (X10FlashException x10FlashException) {
                    // empty catch block
                }
                ++i;
            }
            MyLogger.initProgress(0);
            tazone.close();
            this.closeTA();
        }
        catch (Exception ioe) {
            tazone.close();
            this.closeTA();
            MyLogger.initProgress(0);
            MyLogger.getLogger().error((Object)ioe.getMessage());
            MyLogger.getLogger().error((Object)"Error dumping TA. Aborted");
        }
    }

    public void RestoreTA(String tafile) throws FileNotFoundException, IOException, X10FlashException {
        this.openTA(2);
        this.sendTA(new FileInputStream(tafile), "preset");
        this.closeTA();
        MyLogger.initProgress(0);
    }

    private void processHeader(SinFile sin) throws X10FlashException {
        try {
            MyLogger.getLogger().info((Object)"    Checking header");
            this.cmd.send(5, sin.getHeaderBytes(), false);
            if (USBFlash.getLastFlags() == 0) {
                this.getLastError();
            }
        }
        catch (IOException ioe) {
            throw new X10FlashException("Error in processHeader : " + ioe.getMessage());
        }
    }

    public void getLastError() throws IOException, X10FlashException {
        this.cmd.send(7, Command.VALNULL, false);
    }

    private void uploadImage(SinFile sin) throws X10FlashException {
        try {
            this.processHeader(sin);
            MyLogger.getLogger().info((Object)"    Flashing data");
            int j = 0;
            while ((long)j < sin.getNbChunks()) {
                this.cmd.send(6, sin.getChunckBytes(j), sin.getNbChunks() < (long)(j + 1));
                ++j;
            }
            if (USBFlash.getLastFlags() == 0) {
                this.getLastError();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new X10FlashException(e.getMessage());
        }
    }

    public void sendLoader() throws FileNotFoundException, IOException, X10FlashException {
        MyLogger.getLogger().info((Object)"Processing loader");
        if (this._bundle.hasLoader()) {
            SinFile sin = new SinFile(this._bundle.getLoader().getAbsolutePath());
            sin.setChunkSize(4096L);
            this.uploadImage(sin);
        } else {
            String LoaderHandler;
            File dir = new File(String.valueOf(OS.getWorkDir()) + "/loaders");
            File[] filelist = dir.listFiles(new LoaderRootFilter(LoaderHandler = this.phoneprops.getProperty("LOADER_ROOT")));
            if (filelist.length > 1) {
                LoaderSelectorGUI sel = new LoaderSelectorGUI(filelist);
                String loader = sel.getVersion();
                if (loader.length() > 0) {
                    SinFile sin = new SinFile(String.valueOf(OS.getWorkDir()) + "/loaders/" + loader);
                    sin.setChunkSize(4096L);
                    this.uploadImage(sin);
                }
            } else if (filelist.length == 1) {
                SinFile sin = new SinFile(filelist[0].getAbsolutePath());
                sin.setChunkSize(4096L);
                this.uploadImage(sin);
            } else {
                String devid = "";
                deviceSelectGui devsel = new deviceSelectGui(null);
                devid = devsel.getDevice(new Properties());
                SinFile sin = new SinFile(String.valueOf(OS.getWorkDir()) + "/devices/" + devid + "/loader.sin");
                sin.setChunkSize(4096L);
                this.uploadImage(sin);
                FileInputStream fin = new FileInputStream(new File(String.valueOf(OS.getWorkDir()) + "/devices/" + devid + "/loader.sin"));
                FileOutputStream fout = new FileOutputStream(String.valueOf(OS.getWorkDir()) + "/loaders/" + new File(String.valueOf(this.phoneprops.getProperty("LOADER_ROOT")) + ".sin"));
                try {
                    byte[] b2 = new byte[1];
                    int read = fin.read(b2);
                    while (read == 1) {
                        fout.write(b2);
                        read = fin.read(b2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                fout.flush();
                fout.close();
                fin.close();
            }
        }
        USBFlash.readS1Reply(5000);
        this.hookDevice(true);
    }

    public void sendLoader(File loader) throws FileNotFoundException, IOException, X10FlashException {
        MyLogger.getLogger().info((Object)"Processing loader");
        SinFile sin = new SinFile(loader.getAbsolutePath());
        sin.setChunkSize(4096L);
        this.uploadImage(sin);
        USBFlash.readS1Reply(5000);
        this.hookDevice(true);
    }

    public void sendPartition() throws FileNotFoundException, IOException, X10FlashException {
        if (this._bundle.hasPartition()) {
            BundleEntry entry = this._bundle.getPartition();
            MyLogger.getLogger().info((Object)("Processing " + entry.getName()));
            this.closeTA();
            SinFile sin = new SinFile(entry.getAbsolutePath());
            sin.setChunkSize(65536L);
            this.uploadImage(sin);
            this.openTA(2);
        }
    }

    public void sendImages() throws FileNotFoundException, IOException, X10FlashException {
        int i = 1;
        while (i <= this._bundle.getMeta().getNbCategs()) {
            String categ = this._bundle.getMeta().getCagorie(i);
            if (this._bundle.getMeta().isCategEnabled(categ)) {
                Enumeration<String> entries = this._bundle.getMeta().getEntriesOf(categ, true);
                while (entries.hasMoreElements()) {
                    String entry = entries.nextElement();
                    BundleEntry bent = this._bundle.getEntry(entry);
                    MyLogger.getLogger().info((Object)("Processing " + bent.getName()));
                    SinFile sin = new SinFile(bent.getAbsolutePath());
                    sin.setChunkSize(65536L);
                    this.uploadImage(sin);
                    MyLogger.getLogger().debug((Object)("Flashing " + bent.getName() + " finished"));
                }
            }
            ++i;
        }
    }

    public String getPhoneProperty(String property) {
        return this.phoneprops.getProperty(property);
    }

    public void openTA(int partition) throws X10FlashException, IOException {
        this.cmd.send(9, BytesUtil.getBytesWord(partition, 1), false);
    }

    public void closeTA() throws X10FlashException, IOException {
        this.cmd.send(10, Command.VALNULL, false);
    }

    public void sendTAFiles() throws FileNotFoundException, IOException, X10FlashException {
        Enumeration<String> entries = this._bundle.getMeta().getEntriesOf("TA", true);
        while (entries.hasMoreElements()) {
            String entry = entries.nextElement();
            BundleEntry bent = this._bundle.getEntry(entry);
            if (!bent.getName().toUpperCase().contains("SIM")) {
                this.sendTA(bent.getInputStream(), bent.getName());
            } else {
                MyLogger.getLogger().warn((Object)("This file is ignored : " + bent.getName()));
            }
            MyLogger.getLogger().debug((Object)("Flashing " + bent.getName() + " finished"));
        }
    }

    public void flashDevice() {
        try {
            MyLogger.getLogger().info((Object)"Start Flashing");
            this.sendLoader();
            if (this._bundle.hasCmd25()) {
                MyLogger.getLogger().info((Object)"Disabling final data verification check");
                byte[] byArray = new byte[6];
                byArray[1] = 1;
                byArray[5] = 1;
                this.cmd.send(25, byArray, false);
            }
            this.openTA(2);
            this.setFlashState(true);
            this.sendPartition();
            this.sendTAFiles();
            this.sendImages();
            this.setFlashState(false);
            this.closeTA();
            this.closeDevice(1);
            MyLogger.getLogger().info((Object)"Flashing finished.");
            MyLogger.getLogger().info((Object)"Please unplug and start your phone");
            MyLogger.getLogger().info((Object)"For flashtool, Unknown Sources and Debugging must be checked in phone settings");
            MyLogger.initProgress(0);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            this.closeDevice();
            MyLogger.getLogger().error((Object)ioe.getMessage());
            MyLogger.getLogger().error((Object)"Error flashing. Aborted");
            MyLogger.initProgress(0);
        }
    }

    public boolean openDevice() {
        return this.openDevice(this._bundle.simulate());
    }

    public boolean deviceFound() {
        boolean found = false;
        try {
            Thread.sleep(500L);
            found = Device.getLastConnected(false).getPid().equals("ADDE");
        }
        catch (Exception e) {
            found = false;
        }
        return found;
    }

    public void endSession() throws X10FlashException, IOException {
        MyLogger.getLogger().info((Object)"Ending flash session");
        this.cmd.send(4, Command.VALNULL, false);
    }

    public void endSession(int param) throws X10FlashException, IOException {
        MyLogger.getLogger().info((Object)"Ending flash session");
        this.cmd.send(4, BytesUtil.getBytesWord(param, 1), false);
    }

    public void closeDevice() {
        try {
            this.endSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
        USBFlash.close();
        DeviceChangedListener.pause(false);
    }

    public void closeDevice(int par) {
        try {
            this.endSession(par);
        }
        catch (Exception exception) {
            // empty catch block
        }
        USBFlash.close();
        DeviceChangedListener.pause(false);
    }

    public void hookDevice(boolean printProps) throws X10FlashException, IOException {
        this.cmd.send(1, Command.VALNULL, false);
        this.phoneprops.update(this.cmd.getLastReplyString());
        if (this.getPhoneProperty("ROOTING_STATUS") == null) {
            this.phoneprops.setProperty("ROOTING_STATUS", "UNROOTABLE");
        }
        if (this.phoneprops.getProperty("VER").startsWith("r")) {
            this.phoneprops.setProperty("ROOTING_STATUS", "ROOTED");
        }
        if (printProps) {
            MyLogger.getLogger().info((Object)("Loader : " + this.phoneprops.getProperty("LOADER_ROOT") + " - Version : " + this.phoneprops.getProperty("VER") + " / Bootloader status : " + this.phoneprops.getProperty("ROOTING_STATUS")));
        }
    }

    public boolean openDevice(boolean simulate) {
        if (simulate) {
            return true;
        }
        MyLogger.initProgress(this._bundle.getMaxProgress());
        boolean found = false;
        try {
            USBFlash.open("ADDE");
            try {
                MyLogger.getLogger().info((Object)"Reading device information");
                USBFlash.readS1Reply();
                this.phoneprops = new LoaderInfo(new String(USBFlash.getLastReply()));
                MyLogger.getLogger().info((Object)"Phone ready for flashmode operations.");
            }
            catch (Exception e) {
                e.printStackTrace();
                MyLogger.getLogger().info((Object)"Unable to read from phone after having opened it.");
                MyLogger.getLogger().info((Object)"trying to continue anyway");
            }
            this.cmd = new Command(this._bundle.simulate());
            this.hookDevice(false);
            found = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            found = false;
        }
        return found;
    }
}

