/*
 * Decompiled with CFR 0.152.
 */
package flashsystem;

import flashsystem.TaEntry;
import flashsystem.TaParseException;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Scanner;
import java.util.Vector;

public class TaFile {
    FileInputStream _in;
    Scanner _scanner;
    Vector<TaEntry> entries = new Vector();

    public TaFile(InputStream in) throws TaParseException {
        TaEntry entry = new TaEntry();
        this._in = (FileInputStream)in;
        this._scanner = new Scanner(in);
        String partition = "";
        boolean beginentry = false;
        while (this._scanner.hasNextLine()) {
            String line = this._scanner.nextLine().trim();
            if (line.startsWith("/") || line.length() <= 4) continue;
            Scanner scanline = new Scanner(line);
            scanline.useDelimiter(" ");
            while (scanline.hasNext()) {
                String elem = scanline.next();
                if (elem.length() == 8) {
                    String size;
                    if (entry.getPartition().length() == 0) {
                        entry.setPartition(elem);
                        size = scanline.next();
                        if (size.length() == 4) {
                            entry.setSize(size);
                            continue;
                        }
                        throw new TaParseException("Next to unit should be the size on 4 digits");
                    }
                    entry.close();
                    this.entries.add(entry);
                    entry = new TaEntry();
                    entry.setPartition(elem);
                    size = scanline.next();
                    if (size.length() == 4) {
                        entry.setSize(size);
                        continue;
                    }
                    throw new TaParseException("Next to unit should be the size on 4 digits");
                }
                if (elem.length() != 2) continue;
                entry.addData(elem);
            }
        }
        entry.close();
        this.entries.add(entry);
        try {
            this._in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Vector<TaEntry> entries() {
        return this.entries;
    }

    public String toString() {
        String result = "";
        for (TaEntry entry : this.entries()) {
            result = String.valueOf(result) + entry + "\n";
        }
        return result;
    }
}

